/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test;

import junit.framework.TestCase;
import org.exist.xmldb.RemoteCollection;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public abstract class RemoteDBTest
extends TestCase {
    protected static final String URI = "xmldb:exist://localhost:8081/exist/xmlrpc";
    private static final String COLLECTION_NAME = "unit-testing-collection-Citt\u00e0";
    public static final String DB_DRIVER = "org.exist.xmldb.DatabaseImpl";
    private RemoteCollection collection = null;

    public RemoteDBTest(String name) {
        super(name);
    }

    protected void setUpRemoteDatabase() throws Exception, ClassNotFoundException, InstantiationException, IllegalAccessException, XMLDBException {
        Class<?> cl = Class.forName(DB_DRIVER);
        Database database = (Database)cl.newInstance();
        DatabaseManager.registerDatabase((Database)database);
        Collection rootCollection = DatabaseManager.getCollection((String)"xmldb:exist://localhost:8081/exist/xmlrpc/db", (String)"admin", null);
        Collection childCollection = rootCollection.getChildCollection(COLLECTION_NAME);
        if (childCollection != null) {
            throw new Exception("Cannot run test because the collection /db/unit-testing-collection-Citt\u00e0 already exists. If it is a left-over of a previous test run, please remove it manually.");
        }
        CollectionManagementService cms = (CollectionManagementService)rootCollection.getService("CollectionManagementService", "1.0");
        this.setCollection((RemoteCollection)cms.createCollection(COLLECTION_NAME));
    }

    protected void removeCollection() throws XMLDBException, Exception {
        Collection rootCollection = DatabaseManager.getCollection((String)"xmldb:exist://localhost:8081/exist/xmlrpc/db", (String)"admin", null);
        CollectionManagementService cms = (CollectionManagementService)rootCollection.getService("CollectionManagementService", "1.0");
        cms.removeCollection(COLLECTION_NAME);
    }

    public RemoteCollection getCollection() {
        return this.collection;
    }

    public void setCollection(RemoteCollection collection) {
        this.collection = collection;
    }

    protected String getTestCollectionName() {
        return COLLECTION_NAME;
    }
}

