/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test;

import java.util.ArrayList;
import java.util.Iterator;
import junit.textui.TestRunner;
import org.exist.schema.RemoteSchemaService;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.RemoteCollectionManagementService;
import org.exist.xmldb.RemoteDatabaseInstanceManager;
import org.exist.xmldb.RemoteIndexQueryService;
import org.exist.xmldb.RemoteUserManagementService;
import org.exist.xmldb.RemoteXPathQueryService;
import org.exist.xmldb.RemoteXUpdateQueryService;
import org.exist.xmldb.test.RemoteDBTest;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;

public class RemoteCollectionTest
extends RemoteDBTest {
    private static final String XML_CONTENT = "<xml/>";
    private static final String BINARY_CONTENT = "TEXT";

    public RemoteCollectionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.setUpRemoteDatabase();
    }

    protected void tearDown() throws Exception {
        this.removeCollection();
    }

    public void testIndexQueryService() {
    }

    public void testGetServices() throws XMLDBException {
        Service[] services = this.getCollection().getServices();
        RemoteCollectionTest.assertEquals((int)7, (int)services.length);
        RemoteCollectionTest.assertEquals((Object)RemoteXPathQueryService.class, services[0].getClass());
        RemoteCollectionTest.assertEquals((Object)RemoteCollectionManagementService.class, services[1].getClass());
        RemoteCollectionTest.assertEquals((Object)RemoteUserManagementService.class, services[2].getClass());
        RemoteCollectionTest.assertEquals((Object)RemoteDatabaseInstanceManager.class, services[3].getClass());
        RemoteCollectionTest.assertEquals((Object)RemoteIndexQueryService.class, services[4].getClass());
        RemoteCollectionTest.assertEquals((Object)RemoteXUpdateQueryService.class, services[5].getClass());
        RemoteCollectionTest.assertEquals((Object)RemoteSchemaService.class, services[6].getClass());
    }

    public void testIsRemoteCollection() throws XMLDBException {
        RemoteCollectionTest.assertTrue((boolean)this.getCollection().isRemoteCollection());
    }

    public void testGetPath() throws XMLDBException {
        RemoteCollectionTest.assertEquals((String)("/db/" + this.getTestCollectionName()), (String)this.getCollection().getPath());
    }

    public void testCreateResource() throws XMLDBException {
        RemoteCollection collection = this.getCollection();
        Resource resource = collection.createResource("testresource", "XMLResource");
        RemoteCollectionTest.assertNotNull((Object)resource);
        RemoteCollectionTest.assertEquals((Object)collection, (Object)resource.getParentCollection());
        resource.setContent((Object)"<?xml version='1.0'?><xml/>");
        collection.storeResource(resource);
        resource = collection.createResource("testresource", "BinaryResource");
        RemoteCollectionTest.assertNotNull((Object)resource);
        RemoteCollectionTest.assertEquals((Object)collection, (Object)resource.getParentCollection());
        resource.setContent((Object)"some random binary data here :-)");
        collection.storeResource(resource);
    }

    public void testGetNonExistentResource() throws XMLDBException {
        System.out.println("Retrieving non-existing resource");
        RemoteCollection collection = this.getCollection();
        Resource resource = collection.getResource("unknown.xml");
        RemoteCollectionTest.assertNull((Object)resource);
    }

    public void testListResources() throws XMLDBException {
        ArrayList<String> xmlNames = new ArrayList<String>();
        xmlNames.add("xml1");
        xmlNames.add("xml2");
        xmlNames.add("xml3");
        this.createResources(xmlNames, "XMLResource");
        ArrayList<String> binaryNames = new ArrayList<String>();
        binaryNames.add("b1");
        binaryNames.add("b2");
        this.createResources(binaryNames, "BinaryResource");
        String[] actualContents = this.getCollection().listResources();
        System.out.println("Resources found: " + actualContents.length);
        for (int i = 0; i < actualContents.length; ++i) {
            xmlNames.remove(actualContents[i]);
            binaryNames.remove(actualContents[i]);
        }
        RemoteCollectionTest.assertEquals((int)0, (int)xmlNames.size());
        RemoteCollectionTest.assertEquals((int)0, (int)binaryNames.size());
    }

    private void createResources(ArrayList names, String type) throws XMLDBException {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            Resource res = this.getCollection().createResource((String)i.next(), type);
            if (type.equals("XMLResource")) {
                res.setContent((Object)XML_CONTENT);
            } else {
                res.setContent((Object)BINARY_CONTENT);
            }
            this.getCollection().storeResource(res);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Class)RemoteCollectionTest.class);
    }
}

