/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exist.dom.XMLUtil;
import org.exist.util.XMLFilenameFilter;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;

public class CreateCollectionsTest
extends TestCase {
    private static final String URI = "xmldb:exist:///db";
    private static final String DRIVER = "org.exist.xmldb.DatabaseImpl";
    public Collection root = null;

    public CreateCollectionsTest(String arg0) {
        super(arg0);
    }

    protected void setUp() {
        try {
            Class<?> cl = Class.forName(DRIVER);
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
            this.root = DatabaseManager.getCollection((String)URI);
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (XMLDBException e) {
            e.printStackTrace();
        }
    }

    public void testCreateCollection() {
        CreateCollectionsTest.assertNotNull((Object)this.root);
        try {
            System.out.println("Created Collection: " + this.root.getName() + "( " + this.root.getClass() + " )");
            Service[] services = this.root.getServices();
            System.out.println("services array: " + services);
            CreateCollectionsTest.assertTrue((String)"Collection must provide at least one Service", (services != null && services.length > 0 ? 1 : 0) != 0);
            System.out.println("  number of services: " + services.length);
            for (int i = 0; i < services.length; ++i) {
                System.out.println("  Service: " + services[i].getName() + "( " + services[i].getClass() + " )");
            }
            Collection parentCollection = this.root.getParentCollection();
            System.out.println("root parentCollection: " + parentCollection);
            CreateCollectionsTest.assertNull((String)"root collection has no parent", (Object)parentCollection);
            CollectionManagementService service = (CollectionManagementService)this.root.getService("CollectionManagementService", "1.0");
            CreateCollectionsTest.assertNotNull((Object)service);
            Collection testCollection = service.createCollection("test");
            CreateCollectionsTest.assertNotNull((Object)testCollection);
            int ccc = testCollection.getChildCollectionCount();
            CreateCollectionsTest.assertTrue((String)"Collection just created: ChildCollectionCount==0", (ccc == 0 ? 1 : 0) != 0);
            CreateCollectionsTest.assertTrue((String)"Collection state should be Open after creation", (boolean)testCollection.isOpen());
            String directory = "samples/shakespeare";
            System.out.println("---------------------------------------");
            System.out.println("storing all XML files in directory " + directory + "...");
            System.out.println("---------------------------------------");
            File f = new File(directory);
            File[] files = f.listFiles(new XMLFilenameFilter());
            for (int i = 0; i < files.length; ++i) {
                this.storeResourceFromFile(files[i], testCollection);
            }
            HashSet<String> fileNamesJustStored = new HashSet<String>();
            for (int i = 0; i < files.length; ++i) {
                String file = files[i].toString();
                int lastSeparator = file.lastIndexOf(File.separatorChar);
                fileNamesJustStored.add(file.substring(lastSeparator + 1));
            }
            System.out.println("fileNames stored: " + fileNamesJustStored.toString());
            String[] resourcesNames = testCollection.listResources();
            int resourceCount = testCollection.getResourceCount();
            System.out.println("testCollection.getResourceCount()=" + resourceCount);
            ArrayList<String> fileNamesPresentInDatabase = new ArrayList<String>();
            for (int i = 0; i < resourcesNames.length; ++i) {
                fileNamesPresentInDatabase.add(resourcesNames[i]);
            }
            CreateCollectionsTest.assertTrue((String)"resourcesNames must contain fileNames just stored", (boolean)fileNamesPresentInDatabase.containsAll(fileNamesJustStored));
            String fileToRemove = "macbeth.xml";
            Resource resMacbeth = testCollection.getResource(fileToRemove);
            CreateCollectionsTest.assertNotNull((String)("getResource(" + fileToRemove + "\")"), (Object)resMacbeth);
            testCollection.removeResource(resMacbeth);
            CreateCollectionsTest.assertTrue((String)"After removal resource count must decrease", (testCollection.getResourceCount() == resourceCount - 1 ? 1 : 0) != 0);
            this.storeResourceFromFile(new File(directory + File.separatorChar + fileToRemove), testCollection);
            byte[] data = this.storeBinaryResourceFromFile(new File("webapp/logo.jpg"), testCollection);
            Object content = testCollection.getResource("logo.jpg").getContent();
            byte[] dataStored = (byte[])content;
            CreateCollectionsTest.assertTrue((String)"After storing binary resource, data out==data in", (boolean)Arrays.equals(dataStored, data));
        }
        catch (XMLDBException e) {
            e.printStackTrace();
            CreateCollectionsTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            CreateCollectionsTest.fail((String)e.getMessage());
        }
    }

    private XMLResource storeResourceFromFile(File file, Collection testCollection) throws XMLDBException, IOException {
        System.out.println("storing " + file.getAbsolutePath());
        XMLResource res = (XMLResource)testCollection.createResource(file.getName(), "XMLResource");
        CreateCollectionsTest.assertNotNull((String)"storeResourceFromFile", (Object)res);
        String xml = XMLUtil.readFile(file, "UTF-8");
        res.setContent((Object)xml);
        testCollection.storeResource((Resource)res);
        System.out.println("stored " + file.getAbsolutePath());
        return res;
    }

    private byte[] storeBinaryResourceFromFile(File file, Collection testCollection) throws XMLDBException, IOException {
        System.out.println("storing " + file.getAbsolutePath());
        BinaryResource res = (BinaryResource)testCollection.createResource(file.getName(), "BinaryResource");
        CreateCollectionsTest.assertNotNull((String)"store binary Resource From File", (Object)res);
        FileInputStream istr = new FileInputStream(file);
        BufferedInputStream bstr = new BufferedInputStream(istr);
        int size = (int)file.length();
        byte[] data = new byte[size];
        bstr.read(data, 0, size);
        bstr.close();
        res.setContent((Object)data);
        testCollection.storeResource((Resource)res);
        System.out.println("stored " + file.getAbsolutePath());
        return data;
    }

    public void testMultipleCreates() {
        try {
            Collection rootColl = DatabaseManager.getCollection((String)URI);
            CollectionManagementService cms = (CollectionManagementService)rootColl.getService("CollectionManagementService", "1.0");
            CreateCollectionsTest.assertNotNull((Object)cms);
            cms.createCollection("dummy1");
            CreateCollectionsTest.printChildren(rootColl);
            Collection c1 = rootColl.getChildCollection("dummy1");
            CreateCollectionsTest.assertNotNull((Object)c1);
            cms.setCollection(c1);
            cms.createCollection("dummy2");
            Collection c2 = c1.getChildCollection("dummy2");
            CreateCollectionsTest.assertNotNull((Object)c2);
            cms.setCollection(c2);
            cms.createCollection("dummy3");
            Collection c3 = c2.getChildCollection("dummy3");
            CreateCollectionsTest.assertNotNull((Object)c3);
            cms.setCollection(rootColl);
            cms.removeCollection("dummy1");
            CreateCollectionsTest.printChildren(rootColl);
            CreateCollectionsTest.assertTrue((String)"number of child collections should be 2", (rootColl.getChildCollectionCount() == 2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            CreateCollectionsTest.fail((String)e.getMessage());
        }
    }

    private static void printChildren(Collection c) throws XMLDBException {
        System.out.print("Children of " + c.getName() + ":");
        String[] names = c.listChildCollections();
        for (int i = 0; i < names.length; ++i) {
            System.out.print(" " + names[i]);
        }
        System.out.println();
    }

    public static void main(String[] args) {
        TestRunner.run((Class)CreateCollectionsTest.class);
    }
}

