/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class CopyMoveTest
extends TestCase {
    private static final String URI = "xmldb:exist:///db";
    private static final String DRIVER = "org.exist.xmldb.DatabaseImpl";

    public static void main(String[] args) {
        TestRunner.run((Class)CopyMoveTest.class);
    }

    public CopyMoveTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyResourceChangeName() throws XMLDBException {
        Collection c = this.setupTestCollection();
        try {
            XMLResource original = (XMLResource)c.createResource("original", "XMLResource");
            original.setContent((Object)"<sample/>");
            c.storeResource((Resource)original);
            CollectionManagementServiceImpl cms = (CollectionManagementServiceImpl)c.getService("CollectionManagementService", "1.0");
            cms.copyResource("original", "", "duplicate");
            CopyMoveTest.assertEquals((int)2, (int)c.getResourceCount());
            XMLResource duplicate = (XMLResource)c.getResource("duplicate");
            CopyMoveTest.assertNotNull((Object)duplicate);
            System.out.println(duplicate.getContent());
        }
        finally {
            this.closeCollection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCopiedResource() throws XMLDBException {
        Collection c = this.setupTestCollection();
        try {
            XMLResource original = (XMLResource)c.createResource("original", "XMLResource");
            original.setContent((Object)"<sample/>");
            c.storeResource((Resource)original);
            CollectionManagementServiceImpl cms = (CollectionManagementServiceImpl)c.getService("CollectionManagementService", "1.0");
            cms.copyResource("original", "", "duplicate");
            XMLResource duplicate = (XMLResource)c.getResource("duplicate");
            CopyMoveTest.assertNotNull((Object)duplicate);
            XPathQueryService xq = (XPathQueryService)c.getService("XPathQueryService", "1.0");
            ResourceSet rs = xq.queryResource("duplicate", "/sample");
            CopyMoveTest.assertEquals((long)1L, (long)rs.getSize());
        }
        finally {
            this.closeCollection(c);
        }
    }

    private Collection setupTestCollection() throws XMLDBException {
        Collection root = DatabaseManager.getCollection((String)URI);
        CollectionManagementService rootcms = (CollectionManagementService)root.getService("CollectionManagementService", "1.0");
        Collection c = root.getChildCollection("test");
        if (c != null) {
            rootcms.removeCollection("test");
        }
        rootcms.createCollection("test");
        c = DatabaseManager.getCollection((String)"xmldb:exist:///db/test");
        CopyMoveTest.assertNotNull((Object)c);
        return c;
    }

    protected void setUp() {
        try {
            Database database = (Database)Class.forName(DRIVER).newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeCollection(Collection collection) throws XMLDBException {
        if (null != collection) {
            collection.close();
        }
    }
}

