/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.security.Permission;
import org.exist.security.User;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class RemoteUserManagementService
implements UserManagementService {
    private RemoteCollection parent;

    public RemoteUserManagementService(RemoteCollection collection) {
        this.parent = collection;
    }

    public void addUser(User user) throws XMLDBException {
        try {
            Vector<Object> params = new Vector<Object>();
            params.addElement(user.getName());
            params.addElement(user.getPassword());
            Vector<String> groups = new Vector<String>();
            Iterator i = user.getGroups();
            while (i.hasNext()) {
                groups.addElement((String)i.next());
            }
            params.addElement(groups);
            if (user.getHome() != null) {
                params.addElement(user.getHome());
            }
            this.parent.getClient().execute("setUser", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void setPermissions(Resource res, Permission perms) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + '/' + res.getId();
        try {
            Vector<Object> params = new Vector<Object>();
            params.addElement(path);
            params.addElement(perms.getOwner());
            params.addElement(perms.getOwnerGroup());
            params.addElement(new Integer(perms.getPermissions()));
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void setPermissions(Collection child, Permission perms) throws XMLDBException {
        String path = ((RemoteCollection)child).getPath();
        try {
            Vector<Object> params = new Vector<Object>();
            params.addElement(path);
            params.addElement(perms.getOwner());
            params.addElement(perms.getOwnerGroup());
            params.addElement(new Integer(perms.getPermissions()));
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chmod(Resource res, String mode) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + '/' + res.getId();
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(path);
            params.addElement(mode);
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chmod(Resource res, int mode) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + '/' + res.getId();
        try {
            Vector<Object> params = new Vector<Object>();
            params.addElement(path);
            params.addElement(new Integer(mode));
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chmod(String mode) throws XMLDBException {
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(this.parent.getPath());
            params.addElement(mode);
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chmod(int mode) throws XMLDBException {
        try {
            Vector<Object> params = new Vector<Object>();
            params.addElement(this.parent.getPath());
            params.addElement(new Integer(mode));
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void lockResource(Resource res, User u) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + '/' + res.getId();
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(path);
            params.addElement(u.getName());
            this.parent.getClient().execute("lockResource", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public String hasUserLock(Resource res) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + '/' + res.getId();
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(path);
            String userName = (String)this.parent.getClient().execute("hasUserLock", params);
            return userName != null && userName.length() > 0 ? userName : null;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void unlockResource(Resource res) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + '/' + res.getId();
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(path);
            this.parent.getClient().execute("unlockResource", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chown(User u, String group) throws XMLDBException {
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(this.parent.getPath());
            params.addElement(u.getName());
            params.addElement(group);
            params.addElement("");
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void chown(Resource res, User u, String group) throws XMLDBException {
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + '/' + res.getId();
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(path);
            params.addElement(u.getName());
            params.addElement(group);
            params.addElement("");
            this.parent.getClient().execute("setPermissions", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public String getName() {
        return "UserManagementService";
    }

    public Permission getPermissions(Collection coll) throws XMLDBException {
        if (coll == null) {
            throw new XMLDBException(301, "collection is null");
        }
        Permission perm = ((RemoteCollection)coll).getPermissions();
        if (perm != null) {
            return perm;
        }
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(((RemoteCollection)coll).getPath());
            Hashtable result = (Hashtable)this.parent.getClient().execute("getPermissions", params);
            perm = new Permission((String)result.get("owner"), (String)result.get("group"));
            perm.setPermissions((Integer)result.get("permissions"));
            return perm;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public Permission getPermissions(Resource res) throws XMLDBException {
        if (res == null) {
            throw new XMLDBException(301, "resource is null");
        }
        if (((EXistResource)res).getPermissions() != null) {
            return ((EXistResource)res).getPermissions();
        }
        String path = ((RemoteCollection)res.getParentCollection()).getPath() + '/' + res.getId();
        System.out.println("Retrieving permissions for " + path);
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(path);
            Hashtable result = (Hashtable)this.parent.getClient().execute("getPermissions", params);
            Permission perm = new Permission((String)result.get("owner"), (String)result.get("group"));
            perm.setPermissions((Integer)result.get("permissions"));
            return perm;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public Permission[] listResourcePermissions() throws XMLDBException {
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(this.parent.getPath());
            Hashtable result = (Hashtable)this.parent.getClient().execute("listDocumentPermissions", params);
            Permission[] perm = new Permission[result.size()];
            String[] resources = this.parent.listResources();
            for (int i = 0; i < resources.length; ++i) {
                Vector t = (Vector)result.get(resources[i]);
                perm[i] = new Permission();
                perm[i].setOwner((String)t.elementAt(0));
                perm[i].setGroup((String)t.elementAt(1));
                perm[i].setPermissions((Integer)t.elementAt(2));
            }
            return perm;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public Permission[] listCollectionPermissions() throws XMLDBException {
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(this.parent.getPath());
            Hashtable result = (Hashtable)this.parent.getClient().execute("listCollectionPermissions", params);
            Permission[] perm = new Permission[result.size()];
            String[] collections = this.parent.listChildCollections();
            for (int i = 0; i < collections.length; ++i) {
                Vector t = (Vector)result.get(collections[i]);
                perm[i] = new Permission();
                perm[i].setOwner((String)t.elementAt(0));
                perm[i].setGroup((String)t.elementAt(1));
                perm[i].setPermissions((Integer)t.elementAt(2));
            }
            return perm;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public String getProperty(String property) throws XMLDBException {
        return null;
    }

    public User getUser(String name) throws XMLDBException {
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(name);
            Hashtable tab = (Hashtable)this.parent.getClient().execute("getUser", params);
            User u = new User((String)tab.get("name"), null);
            Vector groups = (Vector)tab.get("groups");
            Iterator i = groups.iterator();
            while (i.hasNext()) {
                u.addGroup((String)i.next());
            }
            String home = (String)tab.get("home");
            u.setHome(home);
            return u;
        }
        catch (XmlRpcException e) {
            return null;
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public User[] getUsers() throws XMLDBException {
        try {
            Vector users = (Vector)this.parent.getClient().execute("getUsers", new Vector());
            User[] u = new User[users.size()];
            for (int i = 0; i < u.length; ++i) {
                Hashtable tab = (Hashtable)users.elementAt(i);
                u[i] = new User((String)tab.get("name"), null);
                Vector groups = (Vector)tab.get("groups");
                Iterator j = groups.iterator();
                while (j.hasNext()) {
                    u[i].addGroup((String)j.next());
                }
                u[i].setHome((String)tab.get("home"));
            }
            return u;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public String getVersion() {
        return "1.0";
    }

    public void removeUser(User u) throws XMLDBException {
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(u.getName());
            this.parent.getClient().execute("removeUser", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public void setCollection(Collection collection) throws XMLDBException {
        this.parent = (RemoteCollection)collection;
    }

    public void setProperty(String property, String value) throws XMLDBException {
    }

    public void updateUser(User user) throws XMLDBException {
        try {
            Vector<Object> params = new Vector<Object>();
            params.addElement(user.getName());
            params.addElement(user.getPassword());
            Vector<String> groups = new Vector<String>();
            Iterator i = user.getGroups();
            while (i.hasNext()) {
                groups.addElement((String)i.next());
            }
            params.addElement(groups);
            if (user.getHome() != null) {
                params.addElement(user.getHome());
            }
            this.parent.getClient().execute("setUser", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public String[] getGroups() throws XMLDBException {
        try {
            Vector v = (Vector)this.parent.getClient().execute("getGroups", new Vector());
            String[] groups = new String[v.size()];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = (String)v.elementAt(i);
            }
            return groups;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }
}

