/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.RemoteXMLResource;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public class RemoteResourceSet
implements ResourceSet {
    protected RemoteCollection collection;
    protected int handle = -1;
    protected Vector resources;
    protected Properties outputProperties;
    protected XmlRpcClient rpcClient;

    public RemoteResourceSet(RemoteCollection col, Properties properties, Vector resources, int handle) {
        this.handle = handle;
        this.resources = resources;
        this.collection = col;
        this.outputProperties = properties;
    }

    public void addResource(Resource resource) {
        this.resources.addElement(resource);
    }

    public void clear() throws XMLDBException {
        this.resources.clear();
    }

    public ResourceIterator getIterator() throws XMLDBException {
        return new NewResourceIterator();
    }

    public ResourceIterator getIterator(long start) throws XMLDBException {
        return new NewResourceIterator(start);
    }

    public Resource getMembersAsResource() throws XMLDBException {
        Vector<Serializable> params = new Vector<Serializable>();
        params.addElement(new Integer(this.handle));
        params.addElement(this.outputProperties);
        try {
            String content;
            byte[] data = (byte[])this.collection.getClient().execute("retrieveAll", params);
            try {
                content = new String(data, this.outputProperties.getProperty("encoding", "UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                content = new String(data);
            }
            RemoteXMLResource res = new RemoteXMLResource(this.collection, this.handle, 0, "", null);
            res.setContent(content);
            res.setProperties(this.outputProperties);
            return res;
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public Resource getResource(long pos) throws XMLDBException {
        if (pos >= (long)this.resources.size()) {
            return null;
        }
        if (this.resources.elementAt((int)pos) instanceof Vector) {
            Vector v = (Vector)this.resources.elementAt((int)pos);
            String doc = (String)v.elementAt(0);
            String s_id = (String)v.elementAt(1);
            String path = doc.substring(0, doc.lastIndexOf(47));
            RemoteCollection parent = new RemoteCollection(this.collection.getClient(), null, path);
            parent.properties = this.outputProperties;
            RemoteXMLResource res = new RemoteXMLResource(parent, this.handle, (int)pos, doc, s_id);
            res.setProperties(this.outputProperties);
            return res;
        }
        if (this.resources.elementAt((int)pos) instanceof Resource) {
            return (Resource)this.resources.elementAt((int)pos);
        }
        RemoteXMLResource res = new RemoteXMLResource(this.collection, this.handle, (int)pos, Long.toString(pos), null);
        res.setContent(this.resources.elementAt((int)pos));
        res.setProperties(this.outputProperties);
        return res;
    }

    public long getSize() throws XMLDBException {
        return this.resources == null ? 0L : (long)this.resources.size();
    }

    public void removeResource(long pos) throws XMLDBException {
        this.resources.removeElementAt((int)pos);
    }

    protected void finalize() throws Throwable {
        try {
            Vector<Integer> params = new Vector<Integer>(1);
            params.addElement(new Integer(this.handle));
            this.rpcClient.execute("releaseQueryResult", params);
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class NewResourceIterator
    implements ResourceIterator {
        long pos = 0L;

        public NewResourceIterator() {
        }

        public NewResourceIterator(long start) {
            this.pos = start;
        }

        public boolean hasMoreResources() throws XMLDBException {
            return RemoteResourceSet.this.resources == null ? false : this.pos < (long)RemoteResourceSet.this.resources.size();
        }

        public Resource nextResource() throws XMLDBException {
            return RemoteResourceSet.this.getResource(this.pos++);
        }
    }
}

