/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xmldb.RemoteCollection;
import org.w3c.dom.Document;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class RemoteCollectionManagementService
implements CollectionManagementServiceImpl {
    protected XmlRpcClient client;
    protected RemoteCollection parent = null;

    public RemoteCollectionManagementService(RemoteCollection parent, XmlRpcClient client) {
        this.client = client;
        this.parent = parent;
    }

    public Collection createCollection(String collName) throws XMLDBException {
        String name = collName;
        if (!collName.startsWith("/db") && this.parent != null) {
            name = this.parent.getPath() + "/" + collName;
        }
        Vector<String> params = new Vector<String>();
        params.addElement(name);
        try {
            this.client.execute("createCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
        RemoteCollection collection = new RemoteCollection(this.client, this.parent, name);
        this.parent.addChildCollection(collection);
        return collection;
    }

    public Collection createCollection(String path, Document configuration) throws XMLDBException {
        return this.createCollection(path);
    }

    public String getName() throws XMLDBException {
        return "CollectionManagementService";
    }

    public String getProperty(String property) {
        return null;
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void removeCollection(String collName) throws XMLDBException {
        String name = collName;
        if (!collName.startsWith("/")) {
            name = this.parent.getPath() + '/' + collName;
        }
        Vector<String> params = new Vector<String>();
        params.addElement(name);
        try {
            this.client.execute("removeCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
        this.parent.removeChildCollection(collName);
    }

    public void setCollection(Collection parent) throws XMLDBException {
        this.parent = (RemoteCollection)parent;
    }

    public void setProperty(String property, String value) {
    }

    public void move(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        if (!collectionPath.startsWith("/db")) {
            collectionPath = this.parent.getPath() + '/' + collectionPath;
        }
        if (!destinationPath.startsWith("/db")) {
            destinationPath = this.parent.getPath() + '/' + destinationPath;
        }
        if (newName == null) {
            int p = collectionPath.lastIndexOf(47);
            newName = collectionPath.substring(p + 1);
        }
        Vector<String> params = new Vector<String>();
        params.addElement(collectionPath);
        params.addElement(destinationPath);
        params.addElement(newName);
        try {
            this.client.execute("moveCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void moveResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        if (!resourcePath.startsWith("/db")) {
            resourcePath = this.parent.getPath() + '/' + resourcePath;
        }
        if (!destinationPath.startsWith("/db")) {
            destinationPath = this.parent.getPath() + '/' + destinationPath;
        }
        if (newName == null) {
            int p = resourcePath.lastIndexOf(47);
            newName = resourcePath.substring(p + 1);
        }
        Vector<String> params = new Vector<String>();
        params.addElement(resourcePath);
        params.addElement(destinationPath);
        params.addElement(newName);
        try {
            this.client.execute("moveResource", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void copy(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        if (!collectionPath.startsWith("/db")) {
            collectionPath = this.parent.getPath() + '/' + collectionPath;
        }
        if (!destinationPath.startsWith("/db")) {
            destinationPath = this.parent.getPath() + '/' + destinationPath;
        }
        if (newName == null) {
            int p = collectionPath.lastIndexOf(47);
            newName = collectionPath.substring(p + 1);
        }
        Vector<String> params = new Vector<String>();
        params.addElement(collectionPath);
        params.addElement(destinationPath);
        params.addElement(newName);
        try {
            this.client.execute("copyCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void copyResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        if (!resourcePath.startsWith("/db")) {
            resourcePath = this.parent.getPath() + '/' + resourcePath;
        }
        if (!destinationPath.startsWith("/db")) {
            destinationPath = this.parent.getPath() + '/' + destinationPath;
        }
        if (newName == null) {
            int p = resourcePath.lastIndexOf(47);
            newName = resourcePath.substring(p + 1);
        }
        Vector<String> params = new Vector<String>();
        params.addElement(resourcePath);
        params.addElement(destinationPath);
        params.addElement(newName);
        try {
            this.client.execute("copyResource", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }
}

