/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.EXistException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.XMLUtil;
import org.exist.security.Permission;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.LockException;
import org.exist.util.serializer.DOMSerializer;
import org.exist.util.serializer.DOMSerializerPool;
import org.exist.util.serializer.DOMStreamer;
import org.exist.util.serializer.DOMStreamerPool;
import org.exist.util.serializer.SAXSerializer;
import org.exist.xmldb.AbstractEXistResource;
import org.exist.xmldb.LocalCollection;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.NodeValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class LocalXMLResource
extends AbstractEXistResource
implements XMLResource {
    protected NodeProxy proxy = null;
    protected long id = -1L;
    protected Properties outputProperties = null;
    protected LexicalHandler lexicalHandler = null;
    protected String content = null;
    protected File file = null;
    protected Node root = null;
    protected AtomicValue value = null;

    public LocalXMLResource(User user, BrokerPool pool, LocalCollection parent, String did, long id) throws XMLDBException {
        super(user, pool, parent, did);
        this.id = id;
    }

    public LocalXMLResource(User user, BrokerPool pool, LocalCollection parent, NodeProxy p) throws XMLDBException {
        this(user, pool, parent, p.getDocument().getFileName(), p.gid);
        this.proxy = p;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getContent() throws XMLDBException {
        String string;
        if (this.content != null) {
            return this.content;
        }
        if (this.root != null && !(this.root instanceof NodeValue)) {
            DOMSerializer serializer = DOMSerializerPool.getInstance().borrowDOMSerializer();
            try {
                StringWriter writer = new StringWriter();
                serializer.setOutputProperties(this.getProperties());
                serializer.setWriter(writer);
                serializer.serialize(this.root);
                this.content = writer.toString();
                return this.content;
            }
            catch (TransformerException e) {
                throw new XMLDBException(301, e.getMessage(), (Throwable)e);
            }
            finally {
                DOMSerializerPool.getInstance().returnDOMSerializer(serializer);
            }
        }
        if (this.value != null) {
            try {
                return this.value.getStringValue();
            }
            catch (XPathException e) {
                throw new XMLDBException(301, e.getMessage(), (Throwable)e);
            }
        }
        if (this.file != null) {
            try {
                this.content = XMLUtil.readFile(this.file);
                return this.content;
            }
            catch (IOException e) {
                throw new XMLDBException(1, "error while reading resource contents", (Throwable)e);
            }
        }
        DocumentImpl document = null;
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            Serializer serializer = broker.getSerializer();
            serializer.setUser(this.user);
            serializer.setProperties(this.getProperties());
            if (this.root != null) {
                this.content = serializer.serialize((NodeValue)((Object)this.root));
            } else {
                document = this.openDocument(broker, 0);
                if (!document.getPermissions().validate(this.user, 4)) {
                    throw new XMLDBException(4, "permission denied to read resource");
                }
                if (this.id < 0L) {
                    this.content = serializer.serialize(document);
                } else {
                    if (this.proxy == null) {
                        this.proxy = new NodeProxy(document, this.id);
                    }
                    this.content = serializer.serialize(this.proxy);
                }
            }
            string = this.content;
        }
        catch (SAXException saxe) {
            try {
                saxe.printStackTrace();
                throw new XMLDBException(1, saxe.getMessage(), (Throwable)saxe);
                catch (EXistException e) {
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.closeDocument(document, 0);
                this.pool.release(broker);
                throw throwable;
            }
        }
        this.closeDocument(document, 0);
        this.pool.release(broker);
        return string;
    }

    public Node getContentAsDOM() throws XMLDBException {
        DBBroker broker;
        DocumentImpl document;
        block10: {
            block9: {
                if (this.root != null) {
                    return this.root;
                }
                if (this.value != null) {
                    throw new XMLDBException(1, "cannot return an atomic value as DOM node");
                }
                document = null;
                broker = null;
                broker = this.pool.get(this.user);
                document = this.getDocument(broker, true);
                if (!document.getPermissions().validate(this.user, 4)) {
                    throw new XMLDBException(4, "permission denied to read resource");
                }
                if (this.id >= 0L) break block9;
                Element element = document.getDocumentElement();
                Object var5_7 = null;
                this.parent.getCollection().releaseDocument(document);
                this.pool.release(broker);
                return element;
            }
            if (this.proxy == null) break block10;
            Node node = document.getNode(this.proxy);
            Object var5_8 = null;
            this.parent.getCollection().releaseDocument(document);
            this.pool.release(broker);
            return node;
        }
        try {
            Node node = document.getNode(this.id);
            Object var5_9 = null;
            this.parent.getCollection().releaseDocument(document);
            this.pool.release(broker);
            return node;
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.parent.getCollection().releaseDocument(document);
                this.pool.release(broker);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContentAsSAX(ContentHandler handler) throws XMLDBException {
        block24: {
            DBBroker broker = null;
            if (this.root != null && !(this.root instanceof NodeValue)) {
                try {
                    String option = this.parent.properties.getProperty("sax-document-events", "false");
                    DOMStreamer streamer = DOMStreamerPool.getInstance().borrowDOMStreamer();
                    streamer.setContentHandler(handler);
                    streamer.setLexicalHandler(this.lexicalHandler);
                    streamer.serialize(this.root, option.equalsIgnoreCase("true"));
                    DOMStreamerPool.getInstance().returnDOMStreamer(streamer);
                }
                catch (Exception e) {
                    throw new XMLDBException(301, e.getMessage(), (Throwable)e);
                }
            }
            if (this.value != null) {
                try {
                    broker = this.pool.get(this.user);
                    this.value.toSAX(broker, handler);
                }
                catch (EXistException e) {
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
                catch (SAXException e) {
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
                finally {
                    this.pool.release(broker);
                }
            }
            try {
                broker = this.pool.get(this.user);
                Serializer serializer = broker.getSerializer();
                serializer.setUser(this.user);
                serializer.setProperties(this.getProperties());
                serializer.setSAXHandlers(handler, this.lexicalHandler);
                if (this.root != null) {
                    serializer.toSAX((NodeValue)((Object)this.root));
                    break block24;
                }
                DocumentImpl document = null;
                try {
                    document = this.openDocument(broker, 0);
                    if (!document.getPermissions().validate(this.user, 4)) {
                        throw new XMLDBException(4, "permission denied to read resource");
                    }
                    if (this.id < 0L) {
                        serializer.toSAX(document);
                    } else {
                        if (this.proxy == null) {
                            this.proxy = new NodeProxy(document, this.id);
                        }
                        serializer.toSAX(this.proxy);
                    }
                }
                finally {
                    this.closeDocument(document, 0);
                }
            }
            catch (EXistException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            finally {
                this.pool.release(broker);
            }
        }
    }

    public String getDocumentId() throws XMLDBException {
        return this.docId;
    }

    public String getId() throws XMLDBException {
        return this.id < 2L ? this.docId : Long.toString(this.id);
    }

    public Collection getParentCollection() throws XMLDBException {
        if (this.parent == null) {
            throw new XMLDBException(1, "collection parent is null");
        }
        return this.parent;
    }

    public String getResourceType() throws XMLDBException {
        return "XMLResource";
    }

    public Date getCreationTime() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, false);
            if (!document.getPermissions().validate(this.user, 4)) {
                throw new XMLDBException(4, "permission denied to read resource");
            }
            Date date = new Date(document.getCreated());
            return date;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public Date getLastModificationTime() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, false);
            if (!document.getPermissions().validate(this.user, 4)) {
                throw new XMLDBException(4, "permission denied to read resource");
            }
            Date date = new Date(document.getLastModified());
            return date;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public int getContentLength() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, false);
            if (!document.getPermissions().validate(this.user, 4)) {
                throw new XMLDBException(4, "permission denied to read resource");
            }
            int n = document.getContentLength();
            return n;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public void setContent(Object obj) throws XMLDBException {
        this.content = null;
        if (obj instanceof File) {
            this.file = (File)obj;
        } else if (obj instanceof AtomicValue) {
            this.value = (AtomicValue)obj;
        } else {
            this.content = obj.toString();
        }
    }

    public void setContentAsDOM(Node root) throws XMLDBException {
        this.root = root;
    }

    public ContentHandler setContentAsSAX() throws XMLDBException {
        return new InternalXMLSerializer();
    }

    public boolean getSAXFeature(String arg0) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setSAXFeature(String arg0, boolean arg1) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Permission getPermissions() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, false);
            Permission permission = document != null ? document.getPermissions() : null;
            return permission;
        }
        catch (EXistException e) {
            throw new XMLDBException(301, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    protected void setProperties(Properties properties) {
        this.outputProperties = properties;
    }

    private Properties getProperties() {
        return this.outputProperties == null ? this.parent.properties : this.outputProperties;
    }

    protected DocumentImpl getDocument(DBBroker broker, boolean lock) throws XMLDBException {
        DocumentImpl document = null;
        if (lock) {
            try {
                document = this.parent.getCollection().getDocumentWithLock(broker, this.docId);
            }
            catch (LockException e) {
                throw new XMLDBException(4, "Failed to acquire lock on document " + this.docId);
            }
        } else {
            document = this.parent.getCollection().getDocument(broker, this.docId);
        }
        if (document == null) {
            throw new XMLDBException(301);
        }
        return document;
    }

    protected NodeProxy getNode() throws XMLDBException {
        if (this.proxy != null) {
            return this.proxy;
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, false);
            if (this.id < 0L) {
                NodeProxy nodeProxy = new NodeProxy(document, 1L);
                return nodeProxy;
            }
            NodeProxy nodeProxy = new NodeProxy(document, this.id);
            return nodeProxy;
        }
        catch (EXistException e) {
            throw new XMLDBException(301, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    private class InternalXMLSerializer
    extends SAXSerializer {
        public InternalXMLSerializer() {
            super(new StringWriter(), null);
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            LocalXMLResource.this.content = this.getWriter().toString();
        }
    }
}

