/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.util.Iterator;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.util.SyntaxException;
import org.exist.xmldb.AbstractEXistResource;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class LocalUserManagementService
implements UserManagementService {
    private LocalCollection collection;
    private BrokerPool pool;
    private User user;

    public LocalUserManagementService(User user, BrokerPool pool, LocalCollection collection) {
        this.pool = pool;
        this.collection = collection;
        this.user = user;
    }

    public void addUser(User u) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        if (!manager.hasAdminPrivileges(this.user)) {
            throw new XMLDBException(4, " you are not allowed to change this user");
        }
        if (manager.hasUser(u.getName())) {
            throw new XMLDBException(1, "user " + this.user.getName() + " exists");
        }
        manager.setUser(u);
    }

    public void setPermissions(Resource resource, Permission perm) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        DocumentImpl document = null;
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            document = ((AbstractEXistResource)resource).openDocument(broker, 1);
            if (!document.getPermissions().getOwner().equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                throw new XMLDBException(4, "you are not the owner of this resource; owner = " + document.getPermissions().getOwner());
            }
            document.setPermissions(perm);
            this.collection.saveCollection();
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                ((AbstractEXistResource)resource).closeDocument(document, 1);
                this.pool.release(broker);
                throw throwable;
            }
        }
        ((AbstractEXistResource)resource).closeDocument(document, 1);
        this.pool.release(broker);
    }

    public void setPermissions(org.xmldb.api.base.Collection child, Permission perm) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        Collection coll = null;
        DBBroker broker = null;
        try {
            try {
                broker = this.pool.get(this.user);
                coll = broker.openCollection(this.collection.getPath(), 1);
                if (coll == null) {
                    throw new XMLDBException(201, "Collection " + this.collection.getPath() + " not found");
                }
                if (!this.collection.checkOwner(coll, this.user) && !manager.hasAdminPrivileges(this.user)) {
                    throw new XMLDBException(4, "you are not the owner of this collection");
                }
                coll.setPermissions(perm);
                broker.saveCollection(coll);
                broker.flush();
            }
            catch (EXistException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                throw new XMLDBException(1, "Failed to acquire lock on collections.dbx", (Throwable)e);
            }
            Object var8_6 = null;
            if (coll != null) {
                coll.release();
            }
            this.pool.release(broker);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (coll != null) {
                coll.release();
            }
            this.pool.release(broker);
            throw throwable;
        }
    }

    public void chmod(String modeStr) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        Collection coll = null;
        DBBroker broker = null;
        try {
            try {
                broker = this.pool.get(this.user);
                coll = broker.openCollection(this.collection.getPath(), 1);
                if (coll == null) {
                    throw new XMLDBException(201, "Collection " + this.collection.getPath() + " not found");
                }
                if (!this.collection.checkOwner(coll, this.user) && !manager.hasAdminPrivileges(this.user)) {
                    throw new XMLDBException(4, "you are not the owner of this collection");
                }
                coll.setPermissions(modeStr);
                broker.saveCollection(coll);
                broker.flush();
            }
            catch (SyntaxException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                throw new XMLDBException(1, "Failed to acquire lock on collections.dbx", (Throwable)e);
            }
            catch (EXistException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            Object var7_5 = null;
            if (coll != null) {
                coll.release();
            }
            this.pool.release(broker);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (coll != null) {
                coll.release();
            }
            this.pool.release(broker);
            throw throwable;
        }
    }

    public void chmod(Resource resource, int mode) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        DocumentImpl document = null;
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            document = ((AbstractEXistResource)resource).openDocument(broker, 1);
            if (!document.getPermissions().getOwner().equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                throw new XMLDBException(4, "you are not the owner of this resource");
            }
            document.setPermissions(mode);
            this.collection.saveCollection();
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                ((AbstractEXistResource)resource).closeDocument(document, 1);
                this.pool.release(broker);
                throw throwable;
            }
        }
        ((AbstractEXistResource)resource).closeDocument(document, 1);
        this.pool.release(broker);
    }

    public void chmod(int mode) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        Collection coll = null;
        DBBroker broker = null;
        try {
            try {
                broker = this.pool.get(this.user);
                coll = broker.openCollection(this.collection.getPath(), 1);
                if (coll == null) {
                    throw new XMLDBException(201, "Collection " + this.collection.getPath() + " not found");
                }
                if (!this.collection.checkOwner(coll, this.user) && !manager.hasAdminPrivileges(this.user)) {
                    throw new XMLDBException(4, "you are not the owner of this collection");
                }
                coll.setPermissions(mode);
                broker.saveCollection(coll);
                broker.flush();
            }
            catch (EXistException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                throw new XMLDBException(1, "Failed to acquire lock on collections.dbx", (Throwable)e);
            }
            Object var7_5 = null;
            if (coll != null) {
                coll.release();
            }
            this.pool.release(broker);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (coll != null) {
                coll.release();
            }
            this.pool.release(broker);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void chmod(Resource resource, String modeStr) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        DocumentImpl document = null;
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            document = ((AbstractEXistResource)resource).openDocument(broker, 1);
            if (!document.getPermissions().getOwner().equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                throw new XMLDBException(4, "you are not the owner of this resource");
            }
            document.setPermissions(modeStr);
            this.collection.saveCollection();
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                catch (SyntaxException e2) {
                    throw new XMLDBException(1, e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                ((AbstractEXistResource)resource).closeDocument(document, 1);
                this.pool.release(broker);
                throw throwable;
            }
        }
        ((AbstractEXistResource)resource).closeDocument(document, 1);
        this.pool.release(broker);
    }

    public void chown(User u, String group) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        if (!manager.hasAdminPrivileges(this.user)) {
            throw new XMLDBException(4, "need admin privileges for chown");
        }
        Collection coll = null;
        DBBroker broker = null;
        try {
            try {
                broker = this.pool.get(this.user);
                coll = broker.openCollection(this.collection.getPath(), 1);
                coll.getPermissions().setOwner(u);
                coll.getPermissions().setGroup(group);
                broker.saveCollection(coll);
                broker.flush();
            }
            catch (EXistException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            Object var8_6 = null;
            if (coll != null) {
                coll.release();
            }
            this.pool.release(broker);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (coll != null) {
                coll.release();
            }
            this.pool.release(broker);
            throw throwable;
        }
    }

    public void chown(Resource res, User u, String group) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        if (!manager.hasAdminPrivileges(this.user)) {
            throw new XMLDBException(4, "need admin privileges for chown");
        }
        DocumentImpl document = null;
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            document = ((AbstractEXistResource)res).openDocument(broker, 1);
            Permission perm = document.getPermissions();
            perm.setOwner(u);
            perm.setGroup(group);
            this.collection.saveCollection();
            broker.flush();
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                ((AbstractEXistResource)res).closeDocument(document, 1);
                this.pool.release(broker);
                throw throwable;
            }
        }
        ((AbstractEXistResource)res).closeDocument(document, 1);
        this.pool.release(broker);
    }

    public String hasUserLock(Resource res) throws XMLDBException {
        String string;
        DocumentImpl doc = null;
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            doc = ((AbstractEXistResource)res).openDocument(broker, 0);
            User lockOwner = doc.getUserLock();
            string = lockOwner == null ? null : lockOwner.getName();
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                ((AbstractEXistResource)res).closeDocument(doc, 0);
                this.pool.release(broker);
                throw throwable;
            }
        }
        ((AbstractEXistResource)res).closeDocument(doc, 0);
        this.pool.release(broker);
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public void lockResource(Resource res, User u) throws XMLDBException {
        block8: {
            doc = null;
            broker = null;
            broker = this.pool.get(this.user);
            doc = ((AbstractEXistResource)res).openDocument(broker, 1);
            if (!doc.getPermissions().validate(this.user, 1)) {
                throw new XMLDBException(4, "User is not allowed to lock resource " + res.getId());
            }
            manager = this.pool.getSecurityManager();
            if (!this.user.equals(u) && !manager.hasAdminPrivileges(this.user)) {
                throw new XMLDBException(4, "User " + this.user.getName() + " is not allowed to lock resource for " + "user " + u.getName());
            }
            lockOwner = doc.getUserLock();
            if (lockOwner == null) ** GOTO lbl21
            if (!lockOwner.equals(u)) break block8;
            ((AbstractEXistResource)res).closeDocument(doc, 1);
            this.pool.release(broker);
            return;
        }
        try {
            if (!manager.hasAdminPrivileges(this.user)) {
                throw new XMLDBException(4, "Resource is already locked by user " + lockOwner.getName());
            }
lbl21:
            // 3 sources

            doc.setUserLock(u);
            this.collection.saveCollection();
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable var7_8) {
                ((AbstractEXistResource)res).closeDocument(doc, 1);
                this.pool.release(broker);
                throw var7_8;
            }
        }
        ((AbstractEXistResource)res).closeDocument(doc, 1);
        this.pool.release(broker);
    }

    public void unlockResource(Resource res) throws XMLDBException {
        DocumentImpl doc = null;
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            doc = ((AbstractEXistResource)res).openDocument(broker, 1);
            if (!doc.getPermissions().validate(this.user, 1)) {
                throw new XMLDBException(4, "User is not allowed to lock resource " + res.getId());
            }
            SecurityManager manager = this.pool.getSecurityManager();
            User lockOwner = doc.getUserLock();
            if (lockOwner != null && !lockOwner.equals(this.user) && !manager.hasAdminPrivileges(this.user)) {
                throw new XMLDBException(4, "Resource is already locked by user " + lockOwner.getName());
            }
            doc.setUserLock(null);
            this.collection.saveCollection();
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                ((AbstractEXistResource)res).closeDocument(doc, 1);
                this.pool.release(broker);
                throw throwable;
            }
        }
        ((AbstractEXistResource)res).closeDocument(doc, 1);
        this.pool.release(broker);
    }

    public String getName() {
        return "UserManagementService";
    }

    public Permission getPermissions(org.xmldb.api.base.Collection coll) throws XMLDBException {
        if (coll instanceof LocalCollection) {
            return ((LocalCollection)coll).getCollection().getPermissions();
        }
        return null;
    }

    public Permission getPermissions(Resource resource) throws XMLDBException {
        Permission permission;
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.pool.get(this.user);
            doc = ((AbstractEXistResource)resource).openDocument(broker, 0);
            permission = doc.getPermissions();
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                ((AbstractEXistResource)resource).closeDocument(doc, 0);
                this.pool.release(broker);
                throw throwable;
            }
        }
        ((AbstractEXistResource)resource).closeDocument(doc, 0);
        this.pool.release(broker);
        return permission;
    }

    public Permission[] listResourcePermissions() throws XMLDBException {
        Collection c;
        DBBroker broker;
        block9: {
            broker = null;
            c = null;
            broker = this.pool.get(this.user);
            c = broker.openCollection(this.collection.getPath(), 0);
            if (c.getPermissions().validate(this.user, 4)) break block9;
            Permission[] permissionArray = new Permission[]{};
            Object var8_6 = null;
            if (c != null) {
                c.release();
            }
            this.pool.release(broker);
            return permissionArray;
        }
        try {
            Permission[] perms = new Permission[c.getDocumentCount()];
            int j = 0;
            Iterator i = c.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                perms[j] = doc.getPermissions();
                ++j;
            }
            Permission[] permissionArray = perms;
            Object var8_7 = null;
            if (c != null) {
                c.release();
            }
            this.pool.release(broker);
            return permissionArray;
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (c != null) {
                    c.release();
                }
                this.pool.release(broker);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission[] listCollectionPermissions() throws XMLDBException {
        Collection c;
        DBBroker broker;
        block13: {
            broker = null;
            c = null;
            broker = this.pool.get(this.user);
            c = broker.openCollection(this.collection.getPath(), 0);
            if (c.getPermissions().validate(this.user, 4)) break block13;
            Permission[] permissionArray = new Permission[]{};
            Object var10_6 = null;
            if (c != null) {
                c.release();
            }
            this.pool.release(broker);
            return permissionArray;
        }
        try {
            Permission[] perms = new Permission[c.getChildCollectionCount()];
            int j = 0;
            Iterator i = c.collectionIterator();
            while (i.hasNext()) {
                String child = (String)i.next();
                Collection childColl = broker.openCollection(this.collection.getPath() + '/' + child, 0);
                if (childColl != null) {
                    try {
                        perms[j] = childColl.getPermissions();
                    }
                    finally {
                        childColl.release();
                    }
                }
                ++j;
            }
            Permission[] permissionArray = perms;
            Object var10_7 = null;
            if (c != null) {
                c.release();
            }
            this.pool.release(broker);
            return permissionArray;
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (c != null) {
                    c.release();
                }
                this.pool.release(broker);
                throw throwable;
            }
        }
    }

    public String getProperty(String property) throws XMLDBException {
        return null;
    }

    public User getUser(String name) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        return manager.getUser(name);
    }

    public User[] getUsers() throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        return manager.getUsers();
    }

    public String[] getGroups() throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        return manager.getGroups();
    }

    public String getVersion() {
        return "1.0";
    }

    public void removeUser(User u) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        if (!manager.hasAdminPrivileges(this.user)) {
            throw new XMLDBException(4, "you are not allowed to remove users");
        }
        try {
            manager.deleteUser(u);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, "unable to remove user " + u.getName(), (Throwable)e);
        }
    }

    public void setCollection(org.xmldb.api.base.Collection collection) throws XMLDBException {
        this.collection = (LocalCollection)collection;
    }

    public void setProperty(String property, String value) throws XMLDBException {
    }

    public void updateUser(User u) throws XMLDBException {
        SecurityManager manager = this.pool.getSecurityManager();
        if (!u.getName().equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
            throw new XMLDBException(4, " you are not allowed to change this user");
        }
        if (u.getName().equals("guest")) {
            throw new XMLDBException(4, "guest user cannot be modified");
        }
        User old = manager.getUser(u.getName());
        if (old == null) {
            throw new XMLDBException(4, "user " + u.getName() + " does not exist");
        }
        Iterator i = u.getGroups();
        while (i.hasNext()) {
            String g = (String)i.next();
            if (old.hasGroup(g) || manager.hasAdminPrivileges(this.user)) continue;
            throw new XMLDBException(4, "not allowed to change group memberships");
        }
        u.setUID(old.getUID());
        manager.setUser(u);
    }
}

