/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.exist.EXistException;
import org.exist.dom.NodeProxy;
import org.exist.dom.SortedNodeSet;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SAXSerializerPool;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.LocalXMLResource;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public class LocalResourceSet
implements ResourceSet {
    protected BrokerPool brokerPool;
    protected LocalCollection collection;
    protected Vector resources = new Vector();
    protected Properties outputProperties;
    private User user;

    public LocalResourceSet(User user, BrokerPool pool, LocalCollection col, Properties properties, Sequence val, String sortExpr) throws XMLDBException {
        this.user = user;
        this.brokerPool = pool;
        this.outputProperties = properties;
        this.collection = col;
        if (val.getLength() == 0) {
            return;
        }
        if (Type.subTypeOf(val.getItemType(), -1) && sortExpr != null) {
            SortedNodeSet sorted = new SortedNodeSet(this.brokerPool, user, sortExpr);
            try {
                sorted.addAll(val);
            }
            catch (XPathException e) {
                throw new XMLDBException(301, e.getMessage(), (Throwable)e);
            }
            val = sorted;
        }
        SequenceIterator i = val.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            this.resources.add(item);
        }
    }

    public void addResource(Resource resource) throws XMLDBException {
        this.resources.add(resource);
    }

    public void clear() throws XMLDBException {
        this.resources.clear();
    }

    public ResourceIterator getIterator() throws XMLDBException {
        return new NewResourceIterator();
    }

    public ResourceIterator getIterator(long start) throws XMLDBException {
        return new NewResourceIterator(start);
    }

    public Resource getMembersAsResource() throws XMLDBException {
        SAXSerializer handler = SAXSerializerPool.getInstance().borrowSAXSerializer();
        handler.setOutputProperties(this.outputProperties);
        StringWriter writer = new StringWriter();
        handler.setWriter(writer);
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(this.user);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            this.collection.properties.setProperty("sax-document-events", "false");
            serializer.setProperties(this.outputProperties);
            serializer.setUser(this.user);
            serializer.setSAXHandlers(handler, handler);
            handler.startDocument();
            handler.startPrefixMapping("exist", "http://exist.sourceforge.net/NS/exist");
            AttributesImpl attribs = new AttributesImpl();
            attribs.addAttribute("", "hitCount", "hitCount", "CDATA", Integer.toString(this.resources.size()));
            handler.startElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result", attribs);
            Iterator i = this.resources.iterator();
            while (i.hasNext()) {
                Item current = (Item)i.next();
                if (Type.subTypeOf(current.getType(), -1)) {
                    ((NodeValue)current).toSAX(broker, handler);
                    continue;
                }
                char[] value = current.toString().toCharArray();
                handler.characters(value, 0, value.length);
            }
            handler.endElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result");
            handler.endPrefixMapping("exist");
            handler.endDocument();
        }
        catch (EXistException e) {
            throw new XMLDBException(0, "serialization error", (Throwable)e);
        }
        catch (SAXException e) {
            throw new XMLDBException(0, "serialization error", (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
        LocalXMLResource res = new LocalXMLResource(this.user, this.brokerPool, this.collection, "", -1L);
        res.setContent(writer.toString());
        return res;
    }

    public Resource getResource(long pos) throws XMLDBException {
        if (pos < 0L || pos >= (long)this.resources.size()) {
            return null;
        }
        Object r = this.resources.get((int)pos);
        LocalXMLResource res = null;
        if (r instanceof NodeProxy) {
            NodeProxy p = (NodeProxy)r;
            LocalCollection coll = this.collection;
            if (coll == null || p.getDocument().getCollection() == null || coll.getCollection().getId() != p.getDocument().getCollection().getId()) {
                coll = new LocalCollection(this.user, this.brokerPool, null, p.getDocument().getCollection().getName());
                coll.properties = this.outputProperties;
            }
            res = new LocalXMLResource(this.user, this.brokerPool, coll, p);
        } else if (r instanceof Node) {
            res = new LocalXMLResource(this.user, this.brokerPool, this.collection, "", -1L);
            res.setContentAsDOM((Node)r);
        } else if (r instanceof AtomicValue) {
            res = new LocalXMLResource(this.user, this.brokerPool, this.collection, "", -1L);
            res.setContent(r);
        } else if (r instanceof Resource) {
            return (Resource)r;
        }
        res.setProperties(this.outputProperties);
        return res;
    }

    public long getSize() throws XMLDBException {
        return this.resources.size();
    }

    public void removeResource(long pos) throws XMLDBException {
        this.resources.removeElementAt((int)pos);
    }

    class NewResourceIterator
    implements ResourceIterator {
        long pos = 0L;

        public NewResourceIterator() {
        }

        public NewResourceIterator(long start) {
            this.pos = start;
        }

        public boolean hasMoreResources() throws XMLDBException {
            return this.pos < LocalResourceSet.this.getSize();
        }

        public Resource nextResource() throws XMLDBException {
            return LocalResourceSet.this.getResource(this.pos++);
        }
    }
}

