/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import org.exist.EXistException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.Occurrences;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.LocalCollection;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class LocalIndexQueryService
implements IndexQueryService {
    private LocalCollection parent = null;
    private BrokerPool pool = null;
    private User user;

    public LocalIndexQueryService(User user, BrokerPool pool, LocalCollection parent) {
        this.user = user;
        this.pool = pool;
        this.parent = parent;
    }

    public void reindexCollection() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            broker.reindex(this.parent.getCollection().getName());
            broker.sync(1);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (EXistException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public void reindexCollection(String collectionPath) throws XMLDBException {
        String path = collectionPath.startsWith("/db") ? collectionPath : this.parent.getPath() + '/' + collectionPath;
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            broker.reindex(path);
            broker.sync(1);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (EXistException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public Occurrences[] getIndexedElements(boolean inclusive) throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            Occurrences[] occurrencesArray = broker.getElementIndex().scanIndexedElements(this.parent.getCollection(), inclusive);
            return occurrencesArray;
        }
        catch (EXistException e) {
            throw new XMLDBException(1, "database access error", (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, "permission denied", (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public String getName() throws XMLDBException {
        return "IndexQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void setCollection(Collection col) throws XMLDBException {
        if (!(col instanceof LocalCollection)) {
            throw new XMLDBException(201, "incompatible collection type: " + col.getClass().getName());
        }
        this.parent = (LocalCollection)col;
    }

    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    public void setProperty(String name, String value) throws XMLDBException {
    }

    public Occurrences[] scanIndexTerms(String start, String end, boolean inclusive) throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            Occurrences[] occurrencesArray = broker.getTextEngine().scanIndexTerms(this.user, this.parent.getCollection(), start, end, inclusive);
            return occurrencesArray;
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, "permission denied", (Throwable)e);
        }
        catch (EXistException e) {
            throw new XMLDBException(1, "database access error", (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }
}

