/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xmldb.LocalCollection;
import org.w3c.dom.Document;
import org.xmldb.api.base.XMLDBException;

public class LocalCollectionManagementService
implements CollectionManagementServiceImpl {
    protected BrokerPool brokerPool;
    protected LocalCollection parent = null;
    protected User user;
    private static Logger LOG = Logger.getLogger((Class)LocalCollectionManagementService.class);

    public LocalCollectionManagementService(User user, BrokerPool pool, LocalCollection parent) {
        if (user == null) {
            throw new RuntimeException();
        }
        this.parent = parent;
        this.brokerPool = pool;
        this.user = user;
    }

    public org.xmldb.api.base.Collection createCollection(String collName) throws XMLDBException {
        collName = this.parent.getPath() + '/' + collName;
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(this.user);
            Collection coll = broker.getOrCreateCollection(collName);
            broker.saveCollection(coll);
        }
        catch (EXistException e) {
            throw new XMLDBException(1, "failed to create collection " + collName, (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, "not allowed to create collection", (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
        return new LocalCollection(this.user, this.brokerPool, this.parent, collName);
    }

    public org.xmldb.api.base.Collection createCollection(String path, Document configuration) throws XMLDBException {
        return this.createCollection(path);
    }

    public String getName() throws XMLDBException {
        return "CollectionManagementService";
    }

    public String getProperty(String property) {
        return null;
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void removeCollection(String collName) throws XMLDBException {
        String path = collName.startsWith("/db") ? collName : this.parent.getPath() + '/' + collName;
        DBBroker broker = null;
        Collection collection = null;
        try {
            try {
                broker = this.brokerPool.get(this.user);
                collection = broker.openCollection(path, 1);
                if (collection == null) {
                    throw new XMLDBException(201, "Collection " + path + " not found");
                }
                LOG.debug((Object)("removing collection " + path));
                broker.removeCollection(collection);
            }
            catch (EXistException e) {
                e.printStackTrace();
                throw new XMLDBException(1, "failed to remove collection " + collName, (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            Object var7_5 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    public void move(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        if (!collectionPath.startsWith("/db")) {
            collectionPath = this.parent.getPath() + '/' + collectionPath;
        }
        if (!destinationPath.startsWith("/db")) {
            destinationPath = this.parent.getPath() + '/' + destinationPath;
        }
        DBBroker broker = null;
        Collection collection = null;
        Collection destination = null;
        try {
            try {
                broker = this.brokerPool.get(this.user);
                collection = broker.openCollection(collectionPath, 1);
                if (collection == null) {
                    throw new XMLDBException(200, "Collection " + collectionPath + " not found");
                }
                destination = broker.openCollection(destinationPath, 1);
                if (destination == null) {
                    throw new XMLDBException(200, "Collection " + destinationPath + " not found");
                }
                broker.moveCollection(collection, destination, newName);
            }
            catch (EXistException e) {
                e.printStackTrace();
                throw new XMLDBException(1, "failed to move collection " + collectionPath, (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            Object var9_7 = null;
            if (destination != null) {
                destination.release();
            }
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (destination != null) {
                destination.release();
            }
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    public void moveResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        if (!resourcePath.startsWith("/db")) {
            resourcePath = this.parent.getPath() + '/' + resourcePath;
        }
        if (!destinationPath.startsWith("/db")) {
            destinationPath = this.parent.getPath() + '/' + destinationPath;
        }
        DBBroker broker = null;
        Collection destination = null;
        Collection source = null;
        try {
            try {
                broker = this.brokerPool.get(this.user);
                int pos = resourcePath.lastIndexOf(47);
                String collName = resourcePath.substring(0, pos);
                String docName = resourcePath.substring(pos + 1);
                source = broker.openCollection(collName, 1);
                if (source == null) {
                    throw new XMLDBException(201, "Collection " + collName + " not found");
                }
                DocumentImpl doc = source.getDocument(broker, docName);
                if (doc == null) {
                    throw new XMLDBException(300, "Resource " + resourcePath + " not found");
                }
                destination = broker.openCollection(destinationPath, 1);
                if (destination == null) {
                    throw new XMLDBException(200, "Collection " + destinationPath + " not found");
                }
                broker.moveResource(doc, destination, newName);
            }
            catch (EXistException e) {
                e.printStackTrace();
                throw new XMLDBException(1, "failed to move resource " + resourcePath, (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            Object var12_14 = null;
            if (source != null) {
                source.release();
            }
            if (destination != null) {
                destination.release();
            }
            this.brokerPool.release(broker);
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (source != null) {
                source.release();
            }
            if (destination != null) {
                destination.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    public void copyResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        if (!resourcePath.startsWith("/db")) {
            resourcePath = this.parent.getPath() + '/' + resourcePath;
        }
        if (!destinationPath.startsWith("/db")) {
            destinationPath = this.parent.getPath() + '/' + destinationPath;
        }
        DBBroker broker = null;
        Collection destination = null;
        Collection source = null;
        try {
            try {
                broker = this.brokerPool.get(this.user);
                int pos = resourcePath.lastIndexOf(47);
                String collName = resourcePath.substring(0, pos);
                String docName = resourcePath.substring(pos + 1);
                source = broker.openCollection(collName, 1);
                if (source == null) {
                    throw new XMLDBException(201, "Collection " + collName + " not found");
                }
                DocumentImpl doc = source.getDocument(broker, docName);
                if (doc == null) {
                    throw new XMLDBException(300, "Resource " + resourcePath + " not found");
                }
                destination = broker.openCollection(destinationPath, 1);
                if (destination == null) {
                    throw new XMLDBException(200, "Collection " + destinationPath + " not found");
                }
                broker.copyResource(doc, destination, newName);
            }
            catch (EXistException e) {
                e.printStackTrace();
                throw new XMLDBException(1, "failed to move resource " + resourcePath, (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            Object var12_14 = null;
            if (source != null) {
                source.release();
            }
            if (destination != null) {
                destination.release();
            }
            this.brokerPool.release(broker);
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (source != null) {
                source.release();
            }
            if (destination != null) {
                destination.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    public void copy(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        if (!collectionPath.startsWith("/db")) {
            collectionPath = this.parent.getPath() + '/' + collectionPath;
        }
        if (!destinationPath.startsWith("/db")) {
            destinationPath = this.parent.getPath() + '/' + destinationPath;
        }
        System.out.println("Copying " + collectionPath + " to " + destinationPath + " as " + newName);
        DBBroker broker = null;
        Collection collection = null;
        Collection destination = null;
        try {
            try {
                broker = this.brokerPool.get(this.user);
                collection = broker.openCollection(collectionPath, 0);
                if (collection == null) {
                    throw new XMLDBException(200, "Collection " + collectionPath + " not found");
                }
                destination = broker.openCollection(destinationPath, 1);
                if (destination == null) {
                    throw new XMLDBException(200, "Collection " + destinationPath + " not found");
                }
                broker.copyCollection(collection, destination, newName);
            }
            catch (EXistException e) {
                e.printStackTrace();
                throw new XMLDBException(1, "failed to move collection " + collectionPath, (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            catch (LockException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            Object var9_7 = null;
            if (collection != null) {
                collection.release();
            }
            if (destination != null) {
                destination.release();
            }
            this.brokerPool.release(broker);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (collection != null) {
                collection.release();
            }
            if (destination != null) {
                destination.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    public void setCollection(org.xmldb.api.base.Collection parent) throws XMLDBException {
        this.parent = (LocalCollection)parent;
    }

    public void setProperty(String property, String value) {
    }
}

