/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import org.exist.EXistException;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.security.Permission;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.xmldb.AbstractEXistResource;
import org.exist.xmldb.LocalCollection;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;

public class LocalBinaryResource
extends AbstractEXistResource
implements BinaryResource {
    protected byte[] rawData = null;

    public LocalBinaryResource(User user, BrokerPool pool, LocalCollection collection, String docId) {
        super(user, pool, collection, docId);
    }

    public Collection getParentCollection() throws XMLDBException {
        return this.parent;
    }

    public String getId() throws XMLDBException {
        return this.docId;
    }

    public String getResourceType() throws XMLDBException {
        return "BinaryResource";
    }

    public Object getContent() throws XMLDBException {
        if (this.rawData == null) {
            DBBroker broker = null;
            BinaryDocument blob = null;
            try {
                try {
                    broker = this.pool.get(this.user);
                    blob = (BinaryDocument)this.getDocument(broker, true);
                    if (!blob.getPermissions().validate(this.user, 4)) {
                        throw new XMLDBException(4, "Permission denied to read resource");
                    }
                    this.rawData = broker.getBinaryResourceData(blob);
                }
                catch (EXistException e) {
                    throw new XMLDBException(1, "error while loading binary resource " + this.getId(), (Throwable)e);
                }
                Object var5_3 = null;
                this.parent.getCollection().releaseDocument(blob);
                this.pool.release(broker);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.parent.getCollection().releaseDocument(blob);
                this.pool.release(broker);
                throw throwable;
            }
        }
        return this.rawData;
    }

    public void setContent(Object value) throws XMLDBException {
        if (value instanceof File) {
            this.readFile((File)value);
        } else if (value instanceof byte[]) {
            this.rawData = (byte[])value;
        } else if (value instanceof String) {
            this.rawData = ((String)value).getBytes();
        } else {
            throw new XMLDBException(1, "don't know how to handle value of type " + value.getClass().getName());
        }
    }

    private void readFile(File file) throws XMLDBException {
        try {
            FileInputStream is = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
            byte[] temp = new byte[1024];
            int count = 0;
            while ((count = is.read(temp)) > -1) {
                bos.write(temp, 0, count);
            }
            this.rawData = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            throw new XMLDBException(1, "file " + file.getAbsolutePath() + " could not be found", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, "IO exception while reading file " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public Date getCreationTime() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            BinaryDocument blob = (BinaryDocument)this.getDocument(broker, false);
            if (!blob.getPermissions().validate(this.user, 4)) {
                throw new XMLDBException(4, "permission denied to read resource");
            }
            Date date = new Date(blob.getCreated());
            return date;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public Date getLastModificationTime() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            BinaryDocument blob = (BinaryDocument)this.getDocument(broker, false);
            if (!blob.getPermissions().validate(this.user, 4)) {
                throw new XMLDBException(4, "permission denied to read resource");
            }
            Date date = new Date(blob.getLastModified());
            return date;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public Permission getPermissions() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, false);
            Permission permission = document != null ? document.getPermissions() : null;
            return permission;
        }
        catch (EXistException e) {
            throw new XMLDBException(301, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public int getContentLength() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, false);
            if (!document.getPermissions().validate(this.user, 4)) {
                throw new XMLDBException(4, "permission denied to read resource");
            }
            int n = document.getContentLength();
            return n;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    protected DocumentImpl getDocument(DBBroker broker, boolean lock) throws XMLDBException {
        DocumentImpl document = null;
        if (lock) {
            try {
                document = this.parent.getCollection().getDocumentWithLock(broker, this.docId);
            }
            catch (LockException e) {
                throw new XMLDBException(4, "Failed to acquire lock on document " + this.docId);
            }
        } else {
            document = this.parent.getCollection().getDocument(broker, this.docId);
        }
        if (document == null) {
            throw new XMLDBException(301);
        }
        if (document.getResourceType() != 1) {
            throw new XMLDBException(3, "Document " + this.docId + " is not a binary resource");
        }
        return document;
    }

    protected DocumentImpl openDocument(DBBroker broker, int lockMode) throws XMLDBException {
        DocumentImpl document = super.openDocument(broker, lockMode);
        if (document.getResourceType() != 1) {
            this.closeDocument(document, lockMode);
            throw new XMLDBException(3, "Document " + this.docId + " is not a binary resource");
        }
        return document;
    }
}

