/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.exist.EXistException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.ShutdownListener;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class DatabaseImpl
implements Database {
    protected static final String DEFAULT_HOST = "localhost:8081";
    protected static final String DEFAULT_NAME = "exist";
    protected static final int LOCAL = 0;
    protected static final int REMOTE = 1;
    protected boolean autoCreate = false;
    protected String configuration = null;
    protected String dbName = "exist";
    protected String selector = this.dbName + ':';
    private HashMap rpcClients = new HashMap();
    protected ShutdownListener shutdown = null;
    protected int mode = 0;

    public DatabaseImpl() {
        try {
            XmlRpc.setEncoding((String)"UTF-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        String initdb = System.getProperty("exist.initdb");
        if (initdb != null) {
            this.autoCreate = initdb.equalsIgnoreCase("true");
        }
    }

    public static Collection readCollection(String c, XmlRpcClient rpcClient, String address) throws XMLDBException {
        RemoteCollection current;
        StringTokenizer tok = new StringTokenizer(c, "/");
        String temp = tok.nextToken();
        if (temp.equals("db")) {
            temp = '/' + temp;
        }
        for (current = new RemoteCollection(rpcClient, null, temp); current != null && tok.hasMoreTokens(); current = current.getChildCollection(current.getPath() + '/' + temp)) {
            temp = tok.nextToken();
        }
        return current;
    }

    public boolean acceptsURI(String uri) throws XMLDBException {
        return uri.startsWith(this.selector);
    }

    private void configure() throws XMLDBException {
        String home;
        String file = "conf.xml";
        if (this.configuration == null) {
            home = System.getProperty("exist.home");
            if (home == null) {
                home = System.getProperty("user.dir");
            }
        } else {
            File f = new File(this.configuration);
            home = f.getParentFile().getAbsolutePath();
            file = f.getName();
        }
        System.out.println("configuring " + this.dbName + " using " + home + '/' + file);
        try {
            Configuration config = new Configuration(file, home);
            BrokerPool.configure(this.dbName, 1, 5, config);
            if (this.shutdown != null) {
                BrokerPool.getInstance(this.dbName).registerShutdownListener(this.shutdown);
            }
        }
        catch (Exception e) {
            throw new XMLDBException(1, "configuration error", (Throwable)e);
        }
    }

    public Collection getCollection(String collection, String user, String password) throws XMLDBException {
        if (!collection.startsWith(this.selector)) {
            throw new XMLDBException(401, "collection " + collection + " does not start with '" + this.selector + "'");
        }
        String c = collection.substring(this.selector.length());
        if (c.endsWith("/") && c.length() > 1) {
            c = c.substring(0, c.length() - 1);
        }
        Object current = null;
        if (c.startsWith("///")) {
            return this.getLocalCollection(user, password, c);
        }
        if (c.startsWith("//")) {
            return this.getRemoteCollection(user, password, c);
        }
        throw new XMLDBException(401, "malformed url: " + c);
    }

    private Collection getRemoteCollection(String user, String password, String c) throws XMLDBException {
        this.mode = 1;
        String address = DEFAULT_HOST;
        if (user == null) {
            user = "guest";
            password = "guest";
        } else if (password == null) {
            password = "";
        }
        int p = 0;
        p = c.indexOf("/db", 2);
        if (p > -1) {
            address = "http://" + c.substring(2, p);
            if (address.charAt(address.length() - 1) == '/') {
                address = address.substring(0, address.length() - 1);
            }
        } else {
            throw new XMLDBException(401, "malformed url: " + address);
        }
        c = c.substring(p);
        XmlRpcClient rpcClient = this.getRpcClient(user, password, address);
        return DatabaseImpl.readCollection(c, rpcClient, address);
    }

    private Collection getLocalCollection(String user, String password, String c) throws XMLDBException {
        BrokerPool pool;
        this.mode = 0;
        if (!BrokerPool.isConfigured(this.dbName)) {
            if (this.autoCreate) {
                this.configure();
            } else {
                throw new XMLDBException(202, "local database server not running");
            }
        }
        try {
            pool = BrokerPool.getInstance(this.dbName);
        }
        catch (EXistException e) {
            throw new XMLDBException(1, "db not correctly initialized", (Throwable)e);
        }
        User u = this.getUser(user, password, pool);
        try {
            LocalCollection current = new LocalCollection(u, pool, c.substring(2));
            return current != null ? current : null;
        }
        catch (XMLDBException e) {
            switch (e.errorCode) {
                case 200: 
                case 201: 
                case 300: 
                case 301: {
                    return null;
                }
            }
            throw e;
        }
    }

    private User getUser(String user, String password, BrokerPool pool) throws XMLDBException {
        User u = null;
        if (user == null) {
            user = "guest";
            password = "guest";
        }
        if (user != null) {
            u = pool.getSecurityManager().getUser(user);
            if (u == null) {
                throw new XMLDBException(4, "user " + user + " does not exist");
            }
            if (!u.validate(password)) {
                throw new XMLDBException(4, "invalid password for user " + user);
            }
        }
        return u;
    }

    private XmlRpcClient getRpcClient(String user, String password, String address) throws XMLDBException {
        String key = user + "@" + address;
        XmlRpcClient client = (XmlRpcClient)this.rpcClients.get(key);
        if (client == null) {
            try {
                client = new XmlRpcClient(address);
            }
            catch (MalformedURLException e) {
                throw new XMLDBException(401, "malformed url: " + address, (Throwable)e);
            }
            if (client != null) {
                this.rpcClients.put(key, client);
            }
        }
        if (client != null) {
            client.setBasicAuthentication(user, password);
        }
        return client;
    }

    public String getConformanceLevel() throws XMLDBException {
        return "0";
    }

    public String getName() throws XMLDBException {
        return this.dbName;
    }

    public String[] getNames() throws XMLDBException {
        return new String[]{this.dbName};
    }

    public void setDatabaseShutdownListener(ShutdownListener listener) throws XMLDBException {
        this.shutdown = listener;
    }

    public String getProperty(String property) throws XMLDBException {
        if (property.equals("create-database")) {
            return Boolean.valueOf(this.autoCreate).toString();
        }
        if (property.equals("database-id")) {
            return this.dbName;
        }
        if (property.equals("configuration")) {
            return this.configuration;
        }
        return null;
    }

    public void setProperty(String property, String value) throws XMLDBException {
        if (property.equals("create-database")) {
            this.autoCreate = value.equals("true");
        }
        if (property.equals("database-id")) {
            this.dbName = value;
            this.selector = this.dbName + ':';
        }
        if (property.equals("configuration")) {
            this.configuration = value;
        }
    }
}

