/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.dom.QName;
import org.exist.util.XMLString;
import org.exist.util.serializer.encodings.CharacterSet;

public class XMLWriter {
    protected static final Properties defaultProperties = new Properties();
    protected Writer writer = null;
    protected CharacterSet charSet = null;
    protected boolean tagIsOpen = false;
    protected boolean tagIsEmpty = true;
    protected boolean declarationWritten = false;
    protected Properties outputProperties;
    private char[] charref = new char[10];
    private static boolean[] textSpecialChars;
    private static boolean[] attrSpecialChars;

    public XMLWriter() {
    }

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    public void setOutputProperties(Properties properties) {
        this.outputProperties = properties == null ? defaultProperties : properties;
        String encoding = this.outputProperties.getProperty("encoding", "UTF-8");
        this.charSet = CharacterSet.getCharacterSet(encoding);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
        this.tagIsOpen = false;
        this.tagIsEmpty = true;
        this.declarationWritten = false;
    }

    public void startDocument() throws TransformerException {
        this.tagIsOpen = false;
        this.tagIsEmpty = true;
        this.declarationWritten = false;
    }

    public void endDocument() throws TransformerException {
    }

    public void startElement(String qname) throws TransformerException {
        if (!this.declarationWritten) {
            this.writeDeclaration();
        }
        try {
            if (this.tagIsOpen) {
                this.closeStartTag(false);
            }
            this.writer.write(60);
            this.writer.write(qname);
            this.tagIsOpen = true;
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public void startElement(QName qname) throws TransformerException {
        if (!this.declarationWritten) {
            this.writeDeclaration();
        }
        try {
            if (this.tagIsOpen) {
                this.closeStartTag(false);
            }
            this.writer.write(60);
            if (qname.getPrefix() != null && qname.getPrefix().length() > 0) {
                this.writer.write(qname.getPrefix());
                this.writer.write(58);
            }
            this.writer.write(qname.getLocalName());
            this.tagIsOpen = true;
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public void endElement(String qname) throws TransformerException {
        try {
            if (this.tagIsOpen) {
                this.closeStartTag(true);
            } else {
                this.writer.write("</");
                this.writer.write(qname);
                this.writer.write(62);
            }
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public void endElement(QName qname) throws TransformerException {
        try {
            if (this.tagIsOpen) {
                this.closeStartTag(true);
            } else {
                this.writer.write("</");
                if (qname.getPrefix() != null && qname.getPrefix().length() > 0) {
                    this.writer.write(qname.getPrefix());
                    this.writer.write(58);
                }
                this.writer.write(qname.getLocalName());
                this.writer.write(62);
            }
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public void namespace(String prefix, String nsURI) throws TransformerException {
        if (!(nsURI != null && nsURI.length() != 0 || prefix != null && prefix.length() != 0)) {
            return;
        }
        try {
            if (!this.tagIsOpen) {
                throw new TransformerException("Found a namespace declaration outside an element");
            }
            this.writer.write(32);
            this.writer.write("xmlns");
            if (prefix != null && prefix.length() > 0) {
                this.writer.write(58);
                this.writer.write(prefix);
            }
            this.writer.write("=\"");
            this.writeChars(nsURI, true);
            this.writer.write(34);
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public void attribute(String qname, String value) throws TransformerException {
        try {
            if (!this.tagIsOpen) {
                this.characters(value);
                return;
            }
            this.writer.write(32);
            this.writer.write(qname);
            this.writer.write("=\"");
            this.writeChars(value, true);
            this.writer.write(34);
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public void attribute(QName qname, String value) throws TransformerException {
        try {
            if (!this.tagIsOpen) {
                this.characters(value);
                return;
            }
            this.writer.write(32);
            if (qname.getPrefix() != null && qname.getPrefix().length() > 0) {
                this.writer.write(qname.getPrefix());
                this.writer.write(58);
            }
            this.writer.write(qname.getLocalName());
            this.writer.write("=\"");
            this.writeChars(value, true);
            this.writer.write(34);
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public void characters(CharSequence chars) throws TransformerException {
        if (!this.declarationWritten) {
            this.writeDeclaration();
        }
        try {
            if (this.tagIsOpen) {
                this.closeStartTag(false);
            }
            this.writeChars(chars, false);
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public void characters(char[] ch, int start, int len) throws TransformerException {
        if (!this.declarationWritten) {
            this.writeDeclaration();
        }
        XMLString s = new XMLString(ch, start, len);
        this.characters(s);
        s.release();
    }

    public void processingInstruction(String target, String data) throws TransformerException {
        if (!this.declarationWritten) {
            this.writeDeclaration();
        }
        try {
            if (this.tagIsOpen) {
                this.closeStartTag(false);
            }
            this.writer.write("<?");
            this.writer.write(target);
            if (data != null && data.length() > 0) {
                this.writer.write(32);
                this.writeChars(data, false);
            }
            this.writer.write("?>");
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public void comment(CharSequence data) throws TransformerException {
        if (!this.declarationWritten) {
            this.writeDeclaration();
        }
        try {
            if (this.tagIsOpen) {
                this.closeStartTag(false);
            }
            this.writer.write("<!--");
            this.writeChars(data, false);
            this.writer.write("-->");
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    protected void closeStartTag(boolean isEmpty) throws TransformerException {
        try {
            if (this.tagIsOpen) {
                if (isEmpty) {
                    this.writer.write("/>");
                } else {
                    this.writer.write(62);
                }
                this.tagIsOpen = false;
            }
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    protected void writeDeclaration() throws TransformerException {
        if (this.declarationWritten) {
            return;
        }
        if (this.outputProperties == null) {
            this.outputProperties = defaultProperties;
        }
        this.declarationWritten = true;
        String omitXmlDecl = this.outputProperties.getProperty("omit-xml-declaration", "yes");
        String version = this.outputProperties.getProperty("version", "1.0");
        String standalone = this.outputProperties.getProperty("standalone");
        String encoding = this.outputProperties.getProperty("encoding", "UTF-8");
        if (omitXmlDecl.equals("no")) {
            try {
                this.writer.write("<?xml version=\"");
                this.writer.write(version);
                this.writer.write("\" encoding=\"");
                this.writer.write(encoding);
                this.writer.write(34);
                if (standalone != null) {
                    this.writer.write(" standalone=\"");
                    this.writer.write(standalone);
                    this.writer.write(34);
                }
                this.writer.write("?>\n");
            }
            catch (IOException e) {
                throw new TransformerException(e.getMessage(), e);
            }
        }
    }

    private final void writeChars(CharSequence s, boolean inAttribute) throws IOException {
        boolean[] specialChars = inAttribute ? attrSpecialChars : textSpecialChars;
        char ch = '\u0000';
        int len = s.length();
        int pos = 0;
        while (pos < len) {
            int i = pos;
            while (i < len) {
                ch = s.charAt(i);
                if (ch < '\u0080') {
                    if (specialChars[ch]) break;
                    ++i;
                    continue;
                }
                if (!this.charSet.inCharacterSet(ch)) break;
                ++i;
            }
            this.writeCharSeq(s, pos, i);
            if (i >= len) {
                return;
            }
            switch (ch) {
                case '<': {
                    this.writer.write("&lt;");
                    break;
                }
                case '>': {
                    this.writer.write("&gt;");
                    break;
                }
                case '&': {
                    this.writer.write("&amp;");
                    break;
                }
                case '\r': {
                    this.writer.write("&#xD;");
                    break;
                }
                case '\n': {
                    this.writer.write("&#xA;");
                    break;
                }
                case '\t': {
                    this.writer.write("&#x9;");
                    break;
                }
                case '\"': {
                    this.writer.write("&#34;");
                    break;
                }
                default: {
                    this.writeCharacterReference(ch);
                }
            }
            pos = ++i;
        }
    }

    private void writeCharSeq(CharSequence ch, int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            this.writer.write(ch.charAt(i));
        }
    }

    protected void writeCharacterReference(char charval) throws IOException {
        int o = 0;
        this.charref[o++] = 38;
        this.charref[o++] = 35;
        this.charref[o++] = 120;
        String code = Integer.toHexString(charval);
        int len = code.length();
        for (int k = 0; k < len; ++k) {
            this.charref[o++] = code.charAt(k);
        }
        this.charref[o++] = 59;
        this.writer.write(this.charref, 0, o);
    }

    static {
        defaultProperties.setProperty("omit-xml-declaration", "no");
        textSpecialChars = new boolean[128];
        Arrays.fill(textSpecialChars, false);
        XMLWriter.textSpecialChars[60] = true;
        XMLWriter.textSpecialChars[62] = true;
        XMLWriter.textSpecialChars[13] = true;
        XMLWriter.textSpecialChars[38] = true;
        attrSpecialChars = new boolean[128];
        Arrays.fill(attrSpecialChars, false);
        XMLWriter.attrSpecialChars[60] = true;
        XMLWriter.attrSpecialChars[62] = true;
        XMLWriter.attrSpecialChars[13] = true;
        XMLWriter.attrSpecialChars[10] = true;
        XMLWriter.attrSpecialChars[9] = true;
        XMLWriter.attrSpecialChars[38] = true;
        XMLWriter.attrSpecialChars[34] = true;
    }
}

