/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable.test;

import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.util.hashtable.SequencedLongHashMap;

public class HashtableTest
extends TestCase {
    private int tabSize = 100000;
    private Object[] values = new Object[this.tabSize];

    public static void main(String[] args) {
        TestRunner.run((Class)HashtableTest.class);
    }

    public HashtableTest(String testname) {
        super(testname);
    }

    public void testPut() {
        int i;
        int i2;
        int[] keys = new int[this.tabSize];
        Int2ObjectHashMap table = new Int2ObjectHashMap(this.tabSize);
        Random rand = new Random(System.currentTimeMillis());
        System.out.println("Generating " + this.tabSize + " random keys...");
        for (i2 = 0; i2 < this.tabSize; ++i2) {
            do {
                keys[i2] = rand.nextInt(Integer.MAX_VALUE);
            } while (table.get(keys[i2]) != null);
            this.values[i2] = new String("a" + keys[i2]);
            table.put(keys[i2], this.values[i2]);
        }
        System.out.println("Testing get(key) ...");
        for (i2 = 0; i2 < this.tabSize; ++i2) {
            Object v = table.get(keys[i2]);
            HashtableTest.assertEquals((Object)this.values[i2], (Object)v);
        }
        System.out.println("Testing remove(key) ...");
        for (i = 0; i < this.tabSize / 10; ++i) {
            int r;
            while (this.values[r = rand.nextInt(this.tabSize - 1)] == null) {
            }
            table.remove(keys[r]);
            this.values[r] = null;
        }
        for (i = 0; i < this.tabSize; ++i) {
            while (this.values[i] == null) {
                ++i;
            }
            String v = (String)table.get(keys[i]);
            HashtableTest.assertNotNull((String)"Key not found", (Object)v);
            HashtableTest.assertEquals((Object)this.values[i], (Object)v);
        }
        int c = 0;
        Iterator i3 = table.iterator();
        while (i3.hasNext()) {
            Integer v = (Integer)i3.next();
            ++c;
        }
        System.out.println(table.size() + " = " + c);
        System.out.println("maxRehash: " + table.getMaxRehash());
        HashtableTest.assertEquals((int)table.size(), (int)c);
    }

    public void testSequencedMap() {
        int i;
        Object v;
        int i2;
        long[] keys = new long[this.tabSize];
        SequencedLongHashMap table = new SequencedLongHashMap(this.tabSize);
        Random rand = new Random(System.currentTimeMillis());
        System.out.println("Generating " + this.tabSize + " random keys...");
        for (i2 = 0; i2 < this.tabSize; ++i2) {
            do {
                keys[i2] = rand.nextInt(Integer.MAX_VALUE);
            } while (table.get(keys[i2]) != null);
            this.values[i2] = new String("a" + keys[i2]);
            table.put(keys[i2], this.values[i2]);
        }
        for (i2 = 0; i2 < this.tabSize; ++i2) {
            Object v2 = table.get(keys[i2]);
            HashtableTest.assertEquals((Object)this.values[i2], (Object)v2);
        }
        int c = 0;
        Iterator i3 = table.iterator();
        while (i3.hasNext()) {
            Long v3 = (Long)i3.next();
            HashtableTest.assertEquals((long)keys[c], (long)v3);
            ++c;
        }
        HashtableTest.assertEquals((int)c, (int)table.size());
        for (int i4 = 0; i4 < 1000; ++i4) {
            int k;
            while (this.values[k = rand.nextInt(this.tabSize - 1)] == null) {
            }
            table.remove(keys[k]);
            this.values[k] = null;
            HashtableTest.assertNull((Object)table.get(keys[k]));
        }
        System.out.println("Hashtable size: " + table.size());
        int k = 0;
        c = 0;
        Iterator i5 = table.iterator();
        while (i5.hasNext()) {
            while (this.values[k] == null) {
                ++k;
            }
            v = (Long)i5.next();
            HashtableTest.assertTrue((String)"Value has been removed and should be null", (this.values[k] != null ? 1 : 0) != 0);
            HashtableTest.assertEquals((String)"Keys don't match", (long)keys[k], (long)((Long)v));
            ++k;
            ++c;
        }
        HashtableTest.assertEquals((String)"Hashtable size is incorrect", (int)table.size(), (int)(this.values.length - 1000));
        HashtableTest.assertEquals((String)"Hashtable size is incorrect", (int)table.size(), (int)c);
        System.gc();
        for (i = 0; i < this.values.length; ++i) {
            if (this.values[i] != null) continue;
            do {
                keys[i] = rand.nextInt(Integer.MAX_VALUE);
            } while (table.get(keys[i]) != null);
            this.values[i] = new String("a" + keys[i]);
            table.put(keys[i], this.values[i]);
        }
        for (i = 0; i < this.tabSize; ++i) {
            v = table.get(keys[i]);
            HashtableTest.assertEquals((Object)this.values[i], (Object)v);
        }
        c = 0;
        Iterator i6 = table.iterator();
        while (i6.hasNext()) {
            v = (Long)i6.next();
            ++c;
        }
        HashtableTest.assertEquals((int)c, (int)table.size());
        System.gc();
        for (int i7 = 0; i7 < this.values.length; ++i7) {
            table.removeFirst();
        }
        System.gc();
        Iterator iter = table.iterator();
        HashtableTest.assertFalse((String)"Hashtable should be empty", (boolean)iter.hasNext());
        HashtableTest.assertTrue((table.size() == 0 ? 1 : 0) != 0);
        System.out.println("Hashtable size: " + table.size());
        System.out.println("maxRehash: " + table.getMaxRehash());
    }
}

