/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import org.exist.util.hashtable.AbstractHashtable;

public class SequencedLongHashMap
extends AbstractHashtable {
    private static final Entry REMOVED_ENTRY = new Entry(0L, null);
    protected long[] keys = new long[this.tabSize];
    protected Entry[] values = new Entry[this.tabSize];
    private Entry first = null;
    private Entry last = null;

    public SequencedLongHashMap() {
    }

    public SequencedLongHashMap(int iSize) {
        super(iSize);
    }

    public void put(long key, Object value) {
        Entry entry = null;
        try {
            entry = this.insert(key, value);
        }
        catch (AbstractHashtable.HashtableOverflowException e) {
            Entry[] copyValues = this.values;
            this.tabSize = (int)SequencedLongHashMap.nextPrime(this.tabSize + this.tabSize / 2);
            this.keys = new long[this.tabSize];
            this.values = new Entry[this.tabSize];
            this.items = 0;
            try {
                for (int k = 0; k < copyValues.length; ++k) {
                    if (copyValues[k] == null || copyValues[k] == REMOVED_ENTRY) continue;
                    this.insert(copyValues[k].key, copyValues[k].value);
                }
                entry = this.insert(key, value);
            }
            catch (AbstractHashtable.HashtableOverflowException e1) {
                // empty catch block
            }
        }
        if (this.first == null) {
            this.last = this.first = entry;
        } else {
            this.last.next = entry;
            entry.prev = this.last;
            this.last = entry;
        }
    }

    protected Entry insert(long key, Object value) throws AbstractHashtable.HashtableOverflowException {
        if (value == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = SequencedLongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.values[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = new Entry(key, value);
            ++this.items;
            return this.values[idx];
        }
        if (this.values[idx] == REMOVED_ENTRY) {
            bucket = idx;
        } else if (this.keys[idx] == key) {
            Entry dup = this.values[idx];
            dup.value = value;
            this.removeEntry(dup);
            return dup;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == REMOVED_ENTRY) {
                if (bucket == -1) {
                    bucket = idx;
                }
            } else {
                if (this.values[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    this.values[idx] = new Entry(key, value);
                    ++this.items;
                    return this.values[idx];
                }
                if (this.keys[idx] == key) {
                    Entry dup = this.values[idx];
                    dup.value = value;
                    this.removeEntry(dup);
                    return dup;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            this.values[bucket] = new Entry(key, value);
            ++this.items;
            return this.values[bucket];
        }
        throw new AbstractHashtable.HashtableOverflowException();
    }

    public Object get(long key) {
        int idx = SequencedLongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        if (this.keys[idx] == key) {
            if (this.values[idx] == REMOVED) {
                return null;
            }
            return this.values[idx].value;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (this.keys[idx] != key) continue;
            if (this.values[idx] == REMOVED) {
                return null;
            }
            return this.values[idx].value;
        }
        return null;
    }

    public Entry getFirstEntry() {
        return this.first;
    }

    public Object remove(long key) {
        Entry entry = this.removeFromHashtable(key);
        if (entry != null) {
            this.removeEntry(entry);
            return entry.value;
        }
        return null;
    }

    private Entry removeFromHashtable(long key) {
        int idx = SequencedLongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        if (this.keys[idx] == key) {
            if (this.values[idx] == REMOVED_ENTRY) {
                return null;
            }
            Entry o = this.values[idx];
            this.values[idx] = REMOVED_ENTRY;
            --this.items;
            return o;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (this.keys[idx] != key) continue;
            if (this.values[idx] == REMOVED_ENTRY) {
                return null;
            }
            Entry o = this.values[idx];
            this.values[idx] = REMOVED_ENTRY;
            --this.items;
            return o;
        }
        return null;
    }

    public Object removeFirst() {
        if (this.first == null) {
            return null;
        }
        Entry head = this.first;
        this.removeFromHashtable(this.first.key);
        this.removeEntry(this.first);
        return head;
    }

    public void removeEntry(Entry entry) {
        if (entry.prev == null) {
            if (entry.next == null) {
                this.first = null;
                this.last = null;
            } else {
                entry.next.prev = null;
                this.first = entry.next;
            }
        } else {
            entry.prev.next = entry.next;
            if (entry.next == null) {
                this.last = entry.prev;
            } else {
                entry.next.prev = entry.prev;
            }
        }
        entry.prev = null;
        entry.next = null;
    }

    protected int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    protected static final int hash(long l) {
        return (int)(l ^ l >>> 32);
    }

    public Iterator iterator() {
        return new SequencedLongIterator(0);
    }

    public Iterator valueIterator() {
        return new SequencedLongIterator(1);
    }

    protected class SequencedLongIterator
    extends AbstractHashtable.HashtableIterator {
        private Entry current;

        public SequencedLongIterator(int type) {
            super(type);
            this.current = SequencedLongHashMap.this.first;
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() {
            if (this.current == null) {
                return null;
            }
            Entry next = this.current;
            this.current = this.current.next;
            if (this.returnType == 1) {
                return next.value;
            }
            return new Long(next.key);
        }
    }

    public static final class Entry {
        long key;
        Object value;
        Entry next = null;
        Entry prev = null;

        public Entry(long key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Entry getNext() {
            return this.next;
        }

        public long getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

