/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import org.exist.util.hashtable.AbstractHashtable;

public class Long2ObjectHashMap
extends AbstractHashtable {
    protected long[] keys;
    protected Object[] values;

    public Long2ObjectHashMap() {
        this.keys = new long[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public Long2ObjectHashMap(int iSize) {
        super(iSize);
        this.keys = new long[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public void put(long key, Object value) {
        try {
            this.insert(key, value);
        }
        catch (AbstractHashtable.HashtableOverflowException e) {
            long[] copyKeys = this.keys;
            Object[] copyValues = this.values;
            this.tabSize = (int)Long2ObjectHashMap.nextPrime(this.tabSize + this.tabSize / 2);
            this.keys = new long[this.tabSize];
            this.values = new Object[this.tabSize];
            this.items = 0;
            for (int k = 0; k < copyValues.length; ++k) {
                if (copyValues[k] == null || copyValues[k] == REMOVED) continue;
                this.put(copyKeys[k], copyValues[k]);
            }
            this.put(key, value);
        }
    }

    public Object get(long key) {
        int idx = Long2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        if (this.keys[idx] == key) {
            if (this.values[idx] == REMOVED) {
                return null;
            }
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (this.keys[idx] != key) continue;
            if (this.values[idx] == REMOVED) {
                return null;
            }
            return this.values[idx];
        }
        return null;
    }

    public Object remove(long key) {
        int idx = Long2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        if (this.keys[idx] == key) {
            if (this.values[idx] == REMOVED) {
                return null;
            }
            Object o = this.values[idx];
            this.values[idx] = REMOVED;
            --this.items;
            return o;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (this.keys[idx] != key) continue;
            if (this.values[idx] == REMOVED) {
                return null;
            }
            Object o = this.values[idx];
            this.values[idx] = REMOVED;
            --this.items;
            return o;
        }
        return null;
    }

    public Iterator iterator() {
        return new Long2ObjectIterator(0);
    }

    public Iterator valueIterator() {
        return new Long2ObjectIterator(1);
    }

    protected Object insert(long key, Object value) throws AbstractHashtable.HashtableOverflowException {
        if (value == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = Long2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.values[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = value;
            ++this.items;
            return null;
        }
        if (this.values[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx] == key) {
            Object dup = this.values[idx];
            this.values[idx] = value;
            return dup;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                if (bucket == -1) {
                    bucket = idx;
                }
            } else {
                if (this.values[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    this.values[idx] = value;
                    ++this.items;
                    return null;
                }
                if (this.keys[idx] == key) {
                    Object dup = this.values[idx];
                    this.values[idx] = value;
                    return dup;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            this.values[bucket] = value;
            ++this.items;
            return null;
        }
        throw new AbstractHashtable.HashtableOverflowException();
    }

    protected int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    protected static final int hash(long l) {
        return (int)(l ^ l >>> 32);
    }

    protected class Long2ObjectIterator
    extends AbstractHashtable.HashtableIterator {
        int idx;

        public Long2ObjectIterator(int type) {
            super(type);
            this.idx = 0;
        }

        public boolean hasNext() {
            if (this.idx == Long2ObjectHashMap.this.tabSize) {
                return false;
            }
            while (Long2ObjectHashMap.this.values[this.idx] == null || Long2ObjectHashMap.this.values[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Long2ObjectHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.idx == Long2ObjectHashMap.this.tabSize) {
                return null;
            }
            while (Long2ObjectHashMap.this.values[this.idx] == null || Long2ObjectHashMap.this.values[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Long2ObjectHashMap.this.tabSize) continue;
                return null;
            }
            if (this.returnType == 1) {
                return Long2ObjectHashMap.this.values[this.idx++];
            }
            return new Long(Long2ObjectHashMap.this.keys[this.idx++]);
        }
    }
}

