/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import org.exist.util.hashtable.AbstractHashtable;

public class Int2ObjectHashMap
extends AbstractHashtable {
    protected int[] keys;
    protected Object[] values;

    public Int2ObjectHashMap() {
        this.keys = new int[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public Int2ObjectHashMap(int iSize) {
        super(iSize);
        this.keys = new int[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public void clear() {
        this.items = 0;
        this.keys = new int[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public void put(int key, Object value) {
        try {
            this.insert(key, value);
        }
        catch (AbstractHashtable.HashtableOverflowException e) {
            int[] copyKeys = this.keys;
            Object[] copyValues = this.values;
            this.tabSize = (int)Int2ObjectHashMap.nextPrime(this.tabSize + this.tabSize / 2);
            this.keys = new int[this.tabSize];
            this.values = new Object[this.tabSize];
            this.items = 0;
            for (int k = 0; k < copyValues.length; ++k) {
                if (copyValues[k] == null || copyValues[k] == REMOVED) continue;
                this.put(copyKeys[k], copyValues[k]);
            }
            this.put(key, value);
        }
    }

    public Object get(int key) {
        int idx = Int2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        if (this.keys[idx] == key) {
            if (this.values[idx] == REMOVED) {
                return null;
            }
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (this.keys[idx] != key) continue;
            if (this.values[idx] == REMOVED) {
                return null;
            }
            return this.values[idx];
        }
        return null;
    }

    public boolean containsKey(int key) {
        int idx = Int2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return false;
        }
        if (this.keys[idx] == key) {
            return this.values[idx] != REMOVED;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return false;
            }
            if (this.keys[idx] != key) continue;
            return this.values[idx] != REMOVED;
        }
        return false;
    }

    public Object remove(int key) {
        int idx = Int2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            System.out.println(key + " not found for remove");
            return null;
        }
        if (this.keys[idx] == key) {
            if (this.values[idx] == REMOVED) {
                return null;
            }
            Object o = this.values[idx];
            this.values[idx] = REMOVED;
            --this.items;
            return o;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                System.out.println(key + " not found for remove");
                return null;
            }
            if (this.keys[idx] != key) continue;
            if (this.values[idx] == REMOVED) {
                return null;
            }
            Object o = this.values[idx];
            this.values[idx] = REMOVED;
            --this.items;
            return o;
        }
        return null;
    }

    public Iterator iterator() {
        return new Int2ObjectIterator(0);
    }

    public Iterator valueIterator() {
        return new Int2ObjectIterator(1);
    }

    protected void insert(int key, Object value) throws AbstractHashtable.HashtableOverflowException {
        if (value == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = Int2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.values[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = value;
            ++this.items;
            return;
        }
        if (this.values[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx] == key) {
            this.values[idx] = value;
            return;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.values[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    this.values[idx] = value;
                    ++this.items;
                    return;
                }
                if (this.keys[idx] == key) {
                    this.values[idx] = value;
                    return;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            this.values[bucket] = value;
            ++this.items;
            return;
        }
        throw new AbstractHashtable.HashtableOverflowException();
    }

    protected boolean hasEqualKeys(Int2ObjectHashMap other) {
        for (int idx = 0; idx < this.tabSize; ++idx) {
            if (this.values[idx] == null || this.values[idx] == REMOVED || other.containsKey(this.keys[idx])) continue;
            return false;
        }
        return true;
    }

    protected int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    protected static int hash(int i) {
        return i;
    }

    protected class Int2ObjectIterator
    extends AbstractHashtable.HashtableIterator {
        int idx;

        public Int2ObjectIterator(int type) {
            super(type);
            this.idx = 0;
        }

        public boolean hasNext() {
            if (this.idx == Int2ObjectHashMap.this.tabSize) {
                return false;
            }
            while (Int2ObjectHashMap.this.values[this.idx] == null || Int2ObjectHashMap.this.values[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Int2ObjectHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.idx == Int2ObjectHashMap.this.tabSize) {
                return null;
            }
            while (Int2ObjectHashMap.this.values[this.idx] == null || Int2ObjectHashMap.this.values[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Int2ObjectHashMap.this.tabSize) continue;
                return null;
            }
            if (this.returnType == 1) {
                return Int2ObjectHashMap.this.values[this.idx++];
            }
            return new Integer(Int2ObjectHashMap.this.keys[this.idx++]);
        }

        public void remove() {
            if (this.idx == 0) {
                throw new IllegalStateException("remove called before next");
            }
            Int2ObjectHashMap.this.values[this.idx - 1] = AbstractHashtable.REMOVED;
            --Int2ObjectHashMap.this.items;
        }
    }
}

