/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import org.exist.util.XMLString;

public class UTF8 {
    private static final char b10000000 = '\u0080';
    private static final char b11000000 = '\u00c0';
    private static final char b11100000 = '\u00e0';
    private static final char b11110000 = '\u00f0';
    private static final char b11111000 = '\u00f8';
    private static final char b11111100 = '\u00fc';
    private static final char b11111110 = '\u00fe';
    private static final char b01111111 = '\u007f';
    private static final char b00111111 = '?';
    private static final char b00011111 = '\u001f';
    private static final char b00001111 = '\u000f';
    private static final char b00000111 = '\u0007';
    private static final char b00000011 = '\u0003';
    private static final char b00000001 = '\u0001';

    public static final XMLString decode(byte[] code) {
        if (null == code) {
            return null;
        }
        return UTF8.decode(code, 0, code.length);
    }

    public static final XMLString decode(byte[] code, int off, int many) {
        if (null == code || 0 >= code.length) {
            return null;
        }
        XMLString xs = new XMLString(many);
        int end = off + many;
        for (int c = off; c < end; ++c) {
            byte cc = code[c];
            if (0 <= cc) {
                xs.append((char)cc);
                continue;
            }
            if (0 == cc) {
                return xs;
            }
            char ch = '\u0000';
            if (192 == (cc & 0xE0)) {
                ch = (char)(ch | code[c + 1] & 0x3F);
                ch = (char)(ch | (cc & 0x1F) << 6);
                ++c;
            } else if (224 == (cc & 0xF0)) {
                ch = (char)(ch | code[c + 2] & 0x3F);
                ch = (char)(ch | (code[c + 1] & 0x3F) << 6);
                ch = (char)(ch | (cc & 0xF) << 12);
                c += 2;
            } else if (240 == (cc & 0xF8)) {
                ch = (char)(ch | code[c + 3] & 0x3F);
                ch = (char)(ch | (code[c + 2] & 0x3F) << 6);
                ch = (char)(ch | (code[c + 1] & 0x3F) << 12);
                c += 3;
            } else if (248 == (cc & 0xFC)) {
                ch = (char)(ch | code[c + 4] & 0x3F);
                ch = (char)(ch | (code[c + 3] & 0x3F) << 6);
                ch = (char)(ch | (code[c + 2] & 0x3F) << 12);
                c += 4;
            } else if (252 == (cc & 0xFE)) {
                ch = (char)(ch | code[c + 5] & 0x3F);
                ch = (char)(ch | (code[c + 4] & 0x3F) << 6);
                ch = (char)(ch | (code[c + 3] & 0x3F) << 12);
                c += 5;
            } else {
                ch = (char)(cc & 0x7F);
            }
            xs.append(ch);
        }
        return xs;
    }

    public static final byte[] encode(char[] str) {
        if (null == str || 0 >= str.length) {
            return null;
        }
        return UTF8.encode(str, 0, str.length, null, 0);
    }

    public static final byte[] encode(char[] str, int start, int length, byte[] bytbuf, int offset) {
        if (null == str || 0 >= length) {
            return bytbuf;
        }
        if (bytbuf == null) {
            bytbuf = new byte[UTF8.encoded(str, start, length)];
        }
        int end = start + length;
        for (int c = start; c < end; ++c) {
            char sch;
            char ch = str[c];
            if ('\u007f' >= ch) {
                bytbuf[offset++] = (byte)ch;
                continue;
            }
            if ('\u07ff' >= ch) {
                sch = (char)(ch >>> 6);
                bytbuf[offset++] = '\u0000' < sch ? (int)(0xC0 | sch & 0x1F) : -64;
                bytbuf[offset++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            sch = (char)(ch >>> 12);
            bytbuf[offset++] = '\u0000' < sch ? (int)(0xE0 | sch & 0xF) : -32;
            bytbuf[offset++] = (byte)(0x80 | ch >>> 6 & 0x3F);
            bytbuf[offset++] = (byte)(0x80 | ch & 0x3F);
        }
        return bytbuf;
    }

    public static final byte[] encode(String str, byte[] bytbuf, int offset) {
        return UTF8.encode(str, 0, str.length(), bytbuf, offset);
    }

    public static final byte[] encode(String str, int start, int length, byte[] bytbuf, int offset) {
        if (null == str || 0 >= length) {
            return bytbuf;
        }
        int end = start + length;
        for (int c = start; c < end; ++c) {
            char sch;
            char ch = str.charAt(c);
            if ('\u007f' >= ch) {
                bytbuf[offset++] = (byte)ch;
                continue;
            }
            if ('\u07ff' >= ch) {
                sch = (char)(ch >>> 6);
                bytbuf[offset++] = '\u0000' < sch ? (int)(0xC0 | sch & 0x1F) : -64;
                bytbuf[offset++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            sch = (char)(ch >>> 12);
            bytbuf[offset++] = '\u0000' < sch ? (int)(0xE0 | sch & 0xF) : -32;
            bytbuf[offset++] = (byte)(0x80 | ch >>> 6 & 0x3F);
            bytbuf[offset++] = (byte)(0x80 | ch & 0x3F);
        }
        return bytbuf;
    }

    public static final byte[] encode(String s) {
        if (null == s) {
            return null;
        }
        return UTF8.encode(s.toCharArray(), 0, s.length(), null, 0);
    }

    public static final int encoded(String str) {
        if (null == str) {
            return 0;
        }
        int bytlen = 0;
        for (int c = 0; c < str.length(); ++c) {
            char ch = str.charAt(c);
            if ('\u007f' >= ch) {
                ++bytlen;
                continue;
            }
            if ('\u07ff' >= ch) {
                bytlen += 2;
                continue;
            }
            bytlen += 3;
        }
        return bytlen;
    }

    public static final int encoded(char[] str, int start, int len) {
        if (null == str || 0 >= len) {
            return 0;
        }
        int bytlen = 0;
        int end = start + len;
        for (int c = start; c < end; ++c) {
            char ch = str[c];
            if ('\u007f' >= ch) {
                ++bytlen;
                continue;
            }
            if ('\u07ff' >= ch) {
                bytlen += 2;
                continue;
            }
            bytlen += 3;
        }
        return bytlen;
    }
}

