/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import org.exist.util.Lock;
import org.exist.util.LockException;

public class ReentrantReadWriteLock
implements Lock {
    protected String id_ = null;
    protected Thread owner_ = null;
    protected long holds_ = 0L;
    protected int mode_ = 0;
    private long timeOut_ = 240000L;

    public ReentrantReadWriteLock(String id) {
        this.id_ = id;
    }

    public boolean acquire() throws LockException {
        return this.acquire(0);
    }

    public boolean acquire(int mode) throws LockException {
        if (Thread.interrupted()) {
            throw new LockException();
        }
        Thread caller = Thread.currentThread();
        ReentrantReadWriteLock reentrantReadWriteLock = this;
        synchronized (reentrantReadWriteLock) {
            if (caller == this.owner_) {
                ++this.holds_;
                this.mode_ = mode;
                return true;
            }
            if (this.owner_ == null) {
                this.owner_ = caller;
                this.holds_ = 1L;
                this.mode_ = mode;
                return true;
            }
            long waitTime = this.timeOut_;
            long start = System.currentTimeMillis();
            try {
                do {
                    this.wait(waitTime);
                    if (caller == this.owner_) {
                        ++this.holds_;
                        this.mode_ = mode;
                        return true;
                    }
                    if (this.owner_ != null) continue;
                    this.owner_ = caller;
                    this.holds_ = 1L;
                    this.mode_ = mode;
                    return true;
                } while ((waitTime = this.timeOut_ - (System.currentTimeMillis() - start)) > 0L);
                if (this.mode_ == 0) {
                    System.out.println("releasing blocking thread " + this.owner_.getName());
                    this.owner_ = caller;
                    this.holds_ = 1L;
                    this.mode_ = mode;
                    return true;
                }
                throw new LockException("time out while acquiring a lock");
            }
            catch (InterruptedException ex) {
                this.notify();
                throw new LockException("interrupted while waiting for lock");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attempt(int mode) {
        Thread caller = Thread.currentThread();
        ReentrantReadWriteLock reentrantReadWriteLock = this;
        synchronized (reentrantReadWriteLock) {
            if (caller == this.owner_) {
                ++this.holds_;
                this.mode_ = mode;
                return true;
            }
            if (this.owner_ == null) {
                this.owner_ = caller;
                this.holds_ = 1L;
                this.mode_ = mode;
                return true;
            }
            return false;
        }
    }

    public boolean isLockedForWrite() {
        return this.holds_ > 0L && this.mode_ == 1;
    }

    public void release(int mode) {
        this.release();
    }

    public synchronized void release() {
        if (Thread.currentThread() != this.owner_) {
            throw new Error("Illegal lock usage. Thread " + Thread.currentThread() + " tried to release lock on " + this.id_);
        }
        if (--this.holds_ == 0L) {
            this.owner_ = null;
            this.mode_ = 0;
            this.notify();
        }
    }

    public synchronized void release(long n) {
        if (Thread.currentThread() != this.owner_ || n > this.holds_) {
            throw new Error("Illegal Lock usage");
        }
        this.holds_ -= n;
        if (this.holds_ == 0L) {
            this.owner_ = null;
            this.notify();
        }
    }

    public synchronized long holds() {
        if (Thread.currentThread() != this.owner_) {
            return 0L;
        }
        return this.holds_;
    }
}

