/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

public class MutableStringTokenizer {
    private CharSequence buf_;
    private int pos_ = 0;
    private int last_ = 0;
    private String tokens_;

    public MutableStringTokenizer(CharSequence buf, String tokens) {
        this.buf_ = buf;
        this.tokens_ = tokens;
    }

    public MutableStringTokenizer() {
    }

    public void set(CharSequence buf) {
        this.buf_ = buf;
        this.pos_ = 0;
        this.last_ = 0;
    }

    public void set(CharSequence buf, String tokens) {
        this.set(buf);
        this.tokens_ = tokens;
    }

    public CharSequence nextToken() {
        if (this.buf_ == null) {
            return null;
        }
        SharedCharSequence next = null;
        while (this.pos_ < this.buf_.length()) {
            char ch = this.buf_.charAt(this.pos_);
            if (this.tokens_.indexOf(ch) > -1) {
                if (this.pos_ > 0) {
                    next = new SharedCharSequence(this.buf_, this.last_, this.pos_);
                    this.last_ = ++this.pos_;
                    return next;
                }
                ++this.last_;
            }
            ++this.pos_;
        }
        if (this.pos_ > this.last_) {
            next = new SharedCharSequence(this.buf_, this.last_, this.pos_);
            this.last_ = this.pos_;
        }
        return next;
    }

    public static void main(String[] args) {
        CharSequence s;
        MutableStringTokenizer t = new MutableStringTokenizer("/PLAY/SCENE/SPEECH/", "/");
        while ((s = t.nextToken()) != null) {
            System.out.println(s);
        }
    }

    private static final class SharedCharSequence
    implements CharSequence {
        CharSequence buf_ = null;
        int start_;
        int end_;

        public SharedCharSequence() {
        }

        public SharedCharSequence(CharSequence buf, int start, int end) {
            this.buf_ = buf;
            this.start_ = start;
            this.end_ = end;
        }

        public void set(CharSequence buf, int start, int end) {
            this.buf_ = buf;
            this.start_ = start;
            this.end_ = end;
        }

        public char charAt(int index) {
            if (index < 0 || this.start_ + index > this.end_) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return this.buf_.charAt(this.start_ + index);
        }

        public boolean equals(Object obj) {
            CharSequence s = obj instanceof CharSequence ? (CharSequence)obj : String.valueOf(obj);
            if (s.length() != this.length()) {
                return false;
            }
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == this.buf_.charAt(this.start_ + i)) continue;
                return false;
            }
            return true;
        }

        public int length() {
            return this.end_ - this.start_;
        }

        public CharSequence subSequence(int start, int end) {
            return new SharedCharSequence(this.buf_, this.start_ + start, this.start_ + end);
        }

        public String toString() {
            StringBuffer b = new StringBuffer(this.length());
            for (int i = this.start_; i < this.end_; ++i) {
                b.append(this.buf_.charAt(i));
            }
            return b.toString();
        }
    }
}

