/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.exist.dom.NodeProxy;

public final class FastQSort {
    private static final void QuickSort(Comparable[] a, int l, int r) {
        int M = 4;
        if (r - l > M) {
            int i = (r + l) / 2;
            if (a[l].compareTo(a[i]) > 0) {
                FastQSort.swap(a, l, i);
            }
            if (a[l].compareTo(a[r]) > 0) {
                FastQSort.swap(a, l, r);
            }
            if (a[i].compareTo(a[r]) > 0) {
                FastQSort.swap(a, i, r);
            }
            int j = r - 1;
            FastQSort.swap(a, i, j);
            i = l;
            Comparable v = a[j];
            while (true) {
                if (a[++i].compareTo(v) < 0) {
                    continue;
                }
                while (a[--j].compareTo(v) > 0) {
                }
                if (j < i) break;
                FastQSort.swap(a, i, j);
            }
            FastQSort.swap(a, i, r - 1);
            FastQSort.QuickSort(a, l, j);
            FastQSort.QuickSort(a, i + 1, r);
        }
    }

    private static final void QuickSort(Object[] a, Comparator comp, int l, int r) {
        int M = 4;
        if (r - l > M) {
            int i = (r + l) / 2;
            if (comp.compare(a[l], a[i]) > 0) {
                FastQSort.swap(a, l, i);
            }
            if (comp.compare(a[l], a[r]) > 0) {
                FastQSort.swap(a, l, r);
            }
            if (comp.compare(a[i], a[r]) > 0) {
                FastQSort.swap(a, i, r);
            }
            int j = r - 1;
            FastQSort.swap(a, i, j);
            i = l;
            Object v = a[j];
            while (true) {
                if (comp.compare(a[++i], v) < 0) {
                    continue;
                }
                while (comp.compare(a[--j], v) > 0) {
                }
                if (j < i) break;
                FastQSort.swap(a, i, j);
            }
            FastQSort.swap(a, i, r - 1);
            FastQSort.QuickSort(a, comp, l, j);
            FastQSort.QuickSort(a, comp, i + 1, r);
        }
    }

    private static final void QuickSort(NodeProxy[] a, int l, int r) {
        int M = 4;
        if (r - l > M) {
            int i = (r + l) / 2;
            if (a[l].compareTo(a[i]) > 0) {
                FastQSort.swap(a, l, i);
            }
            if (a[l].compareTo(a[r]) > 0) {
                FastQSort.swap(a, l, r);
            }
            if (a[i].compareTo(a[r]) > 0) {
                FastQSort.swap(a, i, r);
            }
            int j = r - 1;
            FastQSort.swap(a, i, j);
            i = l;
            NodeProxy v = a[j];
            while (true) {
                if (a[++i].compareTo(v) < 0) {
                    continue;
                }
                while (a[--j].compareTo(v) > 0) {
                }
                if (j < i) break;
                FastQSort.swap(a, i, j);
            }
            FastQSort.swap(a, i, r - 1);
            FastQSort.QuickSort(a, l, j);
            FastQSort.QuickSort(a, i + 1, r);
        }
    }

    private static final void QuickSort(List a, int l, int r) {
        int M = 4;
        if (r - l > M) {
            int i = (r + l) / 2;
            if (((Comparable)a.get(l)).compareTo(a.get(i)) > 0) {
                FastQSort.swap(a, l, i);
            }
            if (((Comparable)a.get(l)).compareTo(a.get(r)) > 0) {
                FastQSort.swap(a, l, r);
            }
            if (((Comparable)a.get(i)).compareTo(a.get(r)) > 0) {
                FastQSort.swap(a, i, r);
            }
            int j = r - 1;
            FastQSort.swap(a, i, j);
            i = l;
            Object v = a.get(j);
            while (true) {
                if (((Comparable)a.get(++i)).compareTo(v) < 0) {
                    continue;
                }
                while (((Comparable)a.get(--j)).compareTo(v) > 0) {
                }
                if (j < i) break;
                FastQSort.swap(a, i, j);
            }
            FastQSort.swap(a, i, r - 1);
            FastQSort.QuickSort(a, l, j);
            FastQSort.QuickSort(a, i + 1, r);
        }
    }

    private static final void QuickSort(long[] a, int l, int r, Object[] b) {
        int M = 4;
        if (r - l > M) {
            int i = (r + l) / 2;
            if (a[l] > a[i]) {
                FastQSort.swap(a, l, i);
                FastQSort.swap(b, l, i);
            }
            if (a[l] > a[r]) {
                FastQSort.swap(a, l, r);
                FastQSort.swap(b, l, r);
            }
            if (a[i] > a[r]) {
                FastQSort.swap(a, i, r);
                FastQSort.swap(b, i, r);
            }
            int j = r - 1;
            FastQSort.swap(a, i, j);
            FastQSort.swap(b, i, j);
            i = l;
            long v = a[j];
            while (true) {
                if (a[++i] < v) {
                    continue;
                }
                while (a[--j] > v) {
                }
                if (j < i) break;
                FastQSort.swap(a, i, j);
                FastQSort.swap(b, i, j);
            }
            FastQSort.swap(a, i, r - 1);
            FastQSort.swap(b, i, r - 1);
            FastQSort.QuickSort(a, l, j, b);
            FastQSort.QuickSort(a, i + 1, r, b);
        }
    }

    private static final void QuickSortByNodeId(NodeProxy[] a, int l, int r) {
        int M = 4;
        if (r - l > M) {
            int i = (r + l) / 2;
            if (a[l].gid > a[i].gid) {
                FastQSort.swap(a, l, i);
            }
            if (a[l].gid > a[r].gid) {
                FastQSort.swap(a, l, r);
            }
            if (a[i].gid > a[r].gid) {
                FastQSort.swap(a, i, r);
            }
            int j = r - 1;
            FastQSort.swap(a, i, j);
            i = l;
            NodeProxy v = a[j];
            while (true) {
                if (a[++i].gid < v.gid) {
                    continue;
                }
                while (a[--j].gid > v.gid) {
                }
                if (j < i) break;
                FastQSort.swap(a, i, j);
            }
            FastQSort.swap(a, i, r - 1);
            FastQSort.QuickSortByNodeId(a, l, j);
            FastQSort.QuickSortByNodeId(a, i + 1, r);
        }
    }

    private static final void swap(long[] a, int i, int j) {
        long T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    private static final void swap(Object[] a, int i, int j) {
        if (a == null) {
            return;
        }
        Object T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    private static final void swap(List a, int i, int j) {
        Object T = a.get(i);
        a.set(i, a.get(j));
        a.set(j, T);
    }

    private static final void swap(Comparable[] a, int i, int j) {
        Comparable T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    private static final void InsertionSortByNodeId(NodeProxy[] a, int lo0, int hi0) {
        NodeProxy temp = null;
        for (int i = lo0 + 1; i <= hi0; ++i) {
            temp = a[i];
            for (int j = i; j > lo0 && a[j - 1].gid > temp.gid; --j) {
                a[j] = a[j - 1];
            }
            a[j] = temp;
        }
    }

    private static final void InsertionSort(Comparable[] a, int lo0, int hi0) {
        Comparable temp = null;
        for (int i = lo0 + 1; i <= hi0; ++i) {
            temp = a[i];
            for (int j = i; j > lo0 && a[j - 1].compareTo(temp) > 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = temp;
        }
    }

    private static final void InsertionSort(Object[] a, Comparator comp, int lo0, int hi0) {
        Object temp = null;
        for (int i = lo0 + 1; i <= hi0; ++i) {
            temp = a[i];
            for (int j = i; j > lo0 && comp.compare(a[j - 1], temp) > 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = temp;
        }
    }

    private static final void InsertionSort(List a, int lo0, int hi0) {
        Object temp = null;
        for (int i = lo0 + 1; i <= hi0; ++i) {
            int j;
            temp = a.get(i);
            for (j = i; j > lo0 && ((Comparable)a.get(j - 1)).compareTo(temp) > 0; --j) {
                a.set(j, a.get(j - 1));
            }
            a.set(j, temp);
        }
    }

    private static final void InsertionSort(long[] a, int lo0, int hi0, Object[] b) {
        Object tempb = null;
        for (int i = lo0 + 1; i <= hi0; ++i) {
            long tempa = a[i];
            if (b != null) {
                tempb = b[i];
            }
            for (int j = i; j > lo0 && a[j - 1] > tempa; --j) {
                a[j] = a[j - 1];
                if (b == null) continue;
                b[j] = b[j - 1];
            }
            a[j] = tempa;
            if (b == null) continue;
            b[j] = tempb;
        }
    }

    public static void sort(Comparable[] a, int lo, int hi) {
        FastQSort.QuickSort(a, lo, hi);
        FastQSort.InsertionSort(a, lo, hi);
    }

    public static void sort(Object[] a, Comparator c, int lo, int hi) {
        FastQSort.QuickSort(a, c, lo, hi);
        FastQSort.InsertionSort(a, c, lo, hi);
    }

    public static void sort(List a, int lo, int hi) {
        FastQSort.QuickSort(a, lo, hi);
        FastQSort.InsertionSort(a, lo, hi);
    }

    public static void sort(NodeProxy[] a, int lo, int hi) {
        FastQSort.QuickSort(a, lo, hi);
        FastQSort.InsertionSort(a, lo, hi);
    }

    public static void sortByNodeId(NodeProxy[] a, int lo, int hi) {
        FastQSort.QuickSortByNodeId(a, lo, hi);
        FastQSort.InsertionSortByNodeId(a, lo, hi);
    }

    public static void sort(long[] a, int lo, int hi, Object[] b) {
        FastQSort.QuickSort(a, lo, hi, b);
        FastQSort.InsertionSort(a, lo, hi, b);
    }

    public static void main(String[] args) throws Exception {
        int i;
        String[] a = new String[]{"Rudi", "Herbert", "Anton", "Berta", "Olga", "Willi", "Heinz"};
        ArrayList<String> l = new ArrayList<String>(a.length);
        for (i = 0; i < a.length; ++i) {
            l.add(a[i]);
        }
        FastQSort.sort(l, 0, l.size() - 1);
        for (i = 0; i < l.size(); ++i) {
            System.out.println(l.get(i));
        }
    }
}

