/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.File;
import java.util.ArrayList;
import org.exist.util.SelectorUtils;

public class DirectoryScanner {
    private static final String extractBaseDir(String pattern) {
        int p = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == File.separatorChar || ch == ':') {
                p = i;
                continue;
            }
            if (ch != '*' && ch != '?' || p <= 0) continue;
            return pattern.substring(0, p + 1);
        }
        return null;
    }

    public static final File[] scanDir(String pattern) {
        String baseDir = DirectoryScanner.extractBaseDir(pattern = pattern.replace('/', File.separatorChar).replace('\\', File.separatorChar));
        if (baseDir == null) {
            baseDir = System.getProperty("user.dir");
            pattern = baseDir + File.separator + pattern;
        }
        File base = new File(baseDir);
        return DirectoryScanner.scanDir(base, pattern.substring(baseDir.length()));
    }

    public static final File[] scanDir(File baseDir, String pattern) {
        pattern = pattern.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        ArrayList list = new ArrayList();
        DirectoryScanner.scanDir(list, baseDir, "", pattern);
        File[] files = new File[list.size()];
        return list.toArray(files);
    }

    private static final void scanDir(ArrayList list, File dir, String vpath, String pattern) {
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            String name = vpath + files[i];
            if (file.isDirectory() && DirectoryScanner.matchStart(pattern, name)) {
                DirectoryScanner.scanDir(list, file, name + File.separator, pattern);
                continue;
            }
            if (!DirectoryScanner.match(pattern, name)) continue;
            list.add(file);
        }
    }

    public static final boolean match(String pattern, String name) {
        return SelectorUtils.matchPath(pattern, name);
    }

    public static final boolean matchStart(String pattern, String name) {
        return SelectorUtils.matchPatternStart(pattern, name);
    }

    public static void main(String[] args) {
        File[] files = DirectoryScanner.scanDir("/home/*/xml/**/*.xml");
        for (int i = 0; i < files.length; ++i) {
            System.out.println(files[i].getAbsolutePath());
        }
    }
}

