/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.store;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dbxml.core.filer.BTreeException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeProxy;
import org.exist.storage.store.DOMFile;
import org.exist.storage.store.ItemId;
import org.exist.storage.store.StorageAddress;
import org.exist.util.ByteConversion;
import org.exist.util.Lock;
import org.exist.util.LockException;

public final class NodeIterator
implements Iterator {
    private static final Logger LOG = Logger.getLogger((Class)NodeIterator.class);
    private DOMFile db = null;
    private NodeProxy node = null;
    private DocumentImpl doc = null;
    private int offset;
    private short lastTID = (short)-1;
    private DOMFile.DOMPage p = null;
    private long page;
    private long startAddress = -1L;
    private Object lockKey;
    private boolean useNodePool = false;

    public NodeIterator(Object lock, DOMFile db, NodeProxy node, boolean poolable) throws BTreeException, IOException {
        this.db = db;
        this.doc = node.getDocument();
        this.useNodePool = poolable;
        if (-1L < node.getInternalAddress()) {
            this.startAddress = node.getInternalAddress();
        } else {
            this.node = node;
        }
        this.lockKey = lock == null ? this : lock;
    }

    public NodeIterator(Object lock, DOMFile db, DocumentImpl doc, long address) {
        this.db = db;
        this.doc = doc;
        this.startAddress = address;
        this.lockKey = lock == null ? this : lock;
    }

    public long currentAddress() {
        return StorageAddress.createPointer((int)this.page, ItemId.getId(this.lastTID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        Lock lock = this.db.getLock();
        try {
            try {
                lock.acquire();
            }
            catch (LockException e) {
                boolean bl = false;
                lock.release();
                return bl;
            }
            this.db.setOwnerObject(this.lockKey);
            if (this.gotoNextPosition()) {
                this.db.getPageBuffer().add(this.p);
                DOMFile.DOMFilePageHeader ph = this.p.getPageHeader();
                if (this.offset < ph.getDataLength()) {
                    boolean bl = true;
                    return bl;
                }
                if (ph.getNextDataPage() < 0L) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (BTreeException e) {
            LOG.warn((Object)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
        finally {
            lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        Lock lock = this.db.getLock();
        NodeImpl nextNode = null;
        try {
            try {
                lock.acquire(0);
            }
            catch (LockException e) {
                Object var4_8 = null;
                lock.release();
                return var4_8;
            }
            this.db.setOwnerObject(this.lockKey);
            if (this.gotoNextPosition()) {
                long backLink = 0L;
                boolean skipped = false;
                do {
                    DOMFile.DOMFilePageHeader ph;
                    if (this.offset >= (ph = this.p.getPageHeader()).getDataLength()) {
                        long nextPage = ph.getNextDataPage();
                        if (nextPage < 0L) {
                            LOG.debug((Object)("bad link to next " + this.p.page.getPageInfo() + "; previous: " + ph.getPrevDataPage() + "; offset = " + this.offset + "; lastTID = " + this.lastTID));
                            Object var9_17 = null;
                            return var9_17;
                        }
                        this.page = nextPage;
                        this.p = this.db.getCurrentPage(nextPage);
                        this.db.addToBuffer(this.p);
                        this.offset = 0;
                    }
                    this.lastTID = ByteConversion.byteToShort(this.p.data, this.offset);
                    this.offset += 2;
                    if (ItemId.isLink(this.lastTID)) {
                        long link = ByteConversion.byteToLong(this.p.data, this.offset);
                        this.offset += 8;
                        skipped = true;
                        continue;
                    }
                    int l = ByteConversion.byteToShort(this.p.data, this.offset);
                    this.offset += 2;
                    if (ItemId.isRelocated(this.lastTID)) {
                        backLink = ByteConversion.byteToLong(this.p.data, this.offset);
                        this.offset += 8;
                    }
                    if (l == 0) {
                        l = 8;
                        long overflow = ByteConversion.byteToLong(this.p.data, this.offset);
                        this.offset += 8;
                        try {
                            byte[] odata = this.db.getOverflowValue(overflow);
                            nextNode = NodeImpl.deserialize(odata, 0, odata.length, this.doc, this.useNodePool);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Exception while loading overflow value: " + e.getMessage() + "; originating page: " + this.p.page.getPageInfo()));
                        }
                    } else {
                        nextNode = NodeImpl.deserialize(this.p.data, this.offset, l, this.doc, this.useNodePool);
                        this.offset += l;
                    }
                    if (nextNode == null) {
                        LOG.warn((Object)("illegal node on page " + this.p.getPageNum() + "; tid = " + ItemId.getId(this.lastTID) + "; next = " + this.p.getPageHeader().getNextDataPage() + "; prev = " + this.p.getPageHeader().getPrevDataPage() + "; offset = " + (this.offset - l) + "; len = " + this.p.getPageHeader().getDataLength()));
                        LOG.debug((Object)this.db.debugPageContents(this.p));
                        LOG.debug((Object)this.p.dumpPage());
                        Thread.dumpStack();
                        Object var8_14 = null;
                        return var8_14;
                    }
                    if (ItemId.isRelocated(this.lastTID)) {
                        nextNode.setInternalAddress(backLink);
                    } else {
                        nextNode.setInternalAddress(StorageAddress.createPointer((int)this.page, ItemId.getId(this.lastTID)));
                    }
                    nextNode.setOwnerDocument(this.doc);
                } while (nextNode == null);
            }
            NodeImpl backLink = nextNode;
            return backLink;
        }
        catch (BTreeException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release();
        }
        return null;
    }

    private boolean gotoNextPosition() throws BTreeException, IOException {
        if (this.node != null) {
            long addr = this.db.findValue(this.lockKey, this.node);
            if (addr == -1L) {
                return false;
            }
            DOMFile.RecordPos rec = this.db.findRecord(addr);
            this.page = rec.page.getPageNum();
            this.p = rec.page;
            this.offset = rec.offset - 2;
            this.node = null;
        } else if (-1L < this.startAddress) {
            DOMFile.RecordPos rec = this.db.findRecord(this.startAddress);
            if (rec == null) {
                throw new IOException("Node not found at specified address.");
            }
            this.page = rec.page.getPageNum();
            this.offset = rec.offset - 2;
            this.p = rec.page;
            this.startAddress = -1L;
        } else if (this.page > -1L) {
            this.p = this.db.getCurrentPage(this.page);
            this.db.addToBuffer(this.p);
        } else {
            return false;
        }
        return true;
    }

    public void remove() {
        throw new RuntimeException("remove() method not implemented");
    }

    public void setTo(NodeProxy node) {
        if (-1L < node.getInternalAddress()) {
            this.startAddress = node.getInternalAddress();
        } else {
            this.node = node;
        }
    }

    public void setTo(long address) {
        this.startAddress = address;
    }
}

