/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.store;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import org.exist.storage.store.FreeSpace;

public class FreeList {
    private static final Logger LOG = Logger.getLogger((Class)FreeList.class);
    public static final int MAX_FREE_LIST_LEN = 128;
    protected FreeSpace header = null;
    protected FreeSpace last = null;
    protected int size = 0;

    public void add(FreeSpace free) {
        if (this.header == null) {
            this.header = free;
            this.last = free;
        } else {
            this.last.next = free;
            free.previous = this.last;
            this.last = free;
        }
        ++this.size;
    }

    public void remove(FreeSpace node) {
        --this.size;
        if (node.previous == null) {
            if (node.next != null) {
                node.next.previous = null;
                this.header = node.next;
            } else {
                this.header = null;
            }
        } else {
            node.previous.next = node.next;
            if (node.next != null) {
                node.next.previous = node.previous;
            } else {
                this.last = node.previous;
            }
        }
    }

    public FreeSpace retrieve(long pageNum) {
        FreeSpace next = this.header;
        while (next != null) {
            if (next.page == pageNum) {
                return next;
            }
            next = next.next;
        }
        return null;
    }

    public FreeSpace find(int requiredSize) {
        FreeSpace next = this.header;
        FreeSpace found = null;
        while (next != null) {
            if (next.free >= requiredSize && (found == null || next.free < found.free)) {
                found = next;
            }
            next = next.next;
        }
        return found;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        FreeSpace next = this.header;
        while (next != null) {
            buf.append("[").append(next.page).append(", ");
            buf.append(next.free).append("] ");
            next = next.next;
        }
        return buf.toString();
    }

    public void read(RandomAccessFile raf) throws IOException {
        int fsize = raf.readInt();
        for (int i = 0; i < fsize; ++i) {
            long page = raf.readLong();
            int space = raf.readInt();
            this.add(new FreeSpace(page, space));
        }
    }

    public void write(RandomAccessFile raf) throws IOException {
        int skip = 0;
        if (this.size > 128) {
            LOG.warn((Object)("removing " + (this.size - 128) + " free pages."));
            skip = this.size - 128;
        }
        raf.writeInt(this.size - skip);
        FreeSpace next = this.header;
        while (next != null) {
            if (skip == 0) {
                raf.writeLong(next.page);
                raf.writeInt(next.free);
            } else {
                --skip;
            }
            next = next.next;
        }
    }
}

