/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.store;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTreeException;
import org.exist.dom.NodeProxy;
import org.exist.storage.store.DOMFile;
import org.exist.storage.store.ItemId;
import org.exist.storage.store.StorageAddress;
import org.exist.util.ByteConversion;
import org.exist.util.Lock;
import org.exist.util.LockException;

public final class DOMFileIterator
implements Iterator {
    private static final Logger LOG = Logger.getLogger((Class)DOMFileIterator.class);
    DOMFile db = null;
    NodeProxy node = null;
    int offset;
    int lastOffset = 0;
    short lastTID = (short)-1;
    DOMFile.DOMPage p = null;
    long page;
    long startAddress = -1L;
    Object lockKey;

    public DOMFileIterator(Object lock, DOMFile db, NodeProxy node) throws BTreeException, IOException {
        this.db = db;
        if (-1L < node.getInternalAddress()) {
            this.startAddress = node.getInternalAddress();
        } else {
            this.node = node;
        }
        this.lockKey = lock == null ? this : lock;
    }

    public DOMFileIterator(Object lock, DOMFile db, long address) throws BTreeException, IOException {
        this.db = db;
        this.startAddress = address;
        this.lockKey = lock == null ? this : lock;
    }

    public long currentAddress() {
        return StorageAddress.createPointer((int)this.page, this.lastTID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        Lock lock = this.db.getLock();
        try {
            try {
                lock.acquire();
            }
            catch (LockException e) {
                boolean bl = false;
                lock.release();
                return bl;
            }
            if (this.gotoNextPosition()) {
                this.db.getPageBuffer().add(this.p);
                DOMFile.DOMFilePageHeader ph = this.p.getPageHeader();
                if (this.offset < ph.getDataLength()) {
                    boolean bl = true;
                    return bl;
                }
                if (ph.getNextDataPage() < 0L) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean ph = false;
            return ph;
        }
        catch (BTreeException e) {
            LOG.warn((Object)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
        finally {
            lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        Lock lock = this.db.getLock();
        try {
            try {
                lock.acquire();
            }
            catch (LockException e) {
                Object var3_6 = null;
                lock.release();
                return var3_6;
            }
            Value nextVal = null;
            if (this.gotoNextPosition()) {
                do {
                    DOMFile.DOMFilePageHeader ph;
                    if (this.offset >= (ph = this.p.getPageHeader()).getDataLength()) {
                        long nextPage = ph.getNextDataPage();
                        if (nextPage < 0L) {
                            LOG.debug((Object)("bad link to next " + this.p.page.getPageInfo()));
                            Object var6_12 = null;
                            return var6_12;
                        }
                        this.page = nextPage;
                        this.p = this.db.getCurrentPage(nextPage);
                        this.offset = 0;
                        this.db.addToBuffer(this.p);
                    }
                    this.lastOffset = this.offset;
                    this.lastTID = ByteConversion.byteToShort(this.p.data, this.offset);
                    this.offset += 2;
                    if (ItemId.isLink(this.lastTID)) {
                        this.offset += 8;
                        continue;
                    }
                    short l = ByteConversion.byteToShort(this.p.data, this.offset);
                    this.offset += 2;
                    if (ItemId.isRelocated(this.lastTID)) {
                        this.offset += 8;
                    }
                    if (l == 0) {
                        long op = ByteConversion.byteToLong(this.p.data, this.offset);
                        this.offset += 8;
                        byte[] data = this.db.getOverflowValue(op);
                        nextVal = new Value(data);
                    } else {
                        nextVal = new Value(this.p.data, this.offset, l);
                        this.offset += l;
                    }
                    nextVal.setAddress(StorageAddress.createPointer((int)this.page, ItemId.getId(this.lastTID)));
                } while (nextVal == null);
            }
            Value value = nextVal;
            return value;
        }
        catch (BTreeException e) {
            LOG.warn((Object)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
        finally {
            lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        Lock lock = this.db.getLock();
        try {
            lock.acquire(1);
            DOMFile.DOMPage p = this.db.getCurrentPage(this.page);
            short itemId = ByteConversion.byteToShort(p.data, this.lastOffset);
            this.lastOffset += 2;
            short l = ByteConversion.byteToShort(p.data, this.lastOffset);
            this.lastOffset += 2;
            if (ItemId.isRelocated(itemId)) {
                long backLink = ByteConversion.byteToLong(p.data, this.lastOffset);
                this.lastOffset += 8;
                DOMFile.RecordPos origRec = this.db.findRecord(backLink, false);
                DOMFile.DOMFilePageHeader ph = origRec.page.getPageHeader();
                ph.decRecordCount();
                origRec.page.setDirty(true);
                if (ph.getRecordCount() == 0) {
                    this.db.removePage(origRec.page);
                }
            }
            if (l == 0) {
                long op = ByteConversion.byteToLong(p.data, this.lastOffset);
                this.lastOffset += 8;
                this.db.removeOverflowValue(op);
            }
            DOMFile.DOMFilePageHeader ph = p.getPageHeader();
            ph.decRecordCount();
            p.setDirty(true);
            if (ph.getRecordCount() == 0) {
                long np = ph.getNextDataPage();
                this.db.removePage(p);
                this.page = np;
                this.offset = 0;
            } else {
                this.db.getPageBuffer().add(p);
            }
        }
        catch (LockException e) {
            LOG.warn((Object)e);
        }
        finally {
            lock.release();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean gotoNextPosition() throws BTreeException, IOException {
        if (this.node != null) {
            this.db.setOwnerObject(this.lockKey);
            long addr = this.db.findValue(this.lockKey, this.node);
            if (addr == -1L) {
                return false;
            }
            DOMFile.RecordPos rec = this.db.findRecord(addr);
            if (rec == null) return false;
            this.page = rec.page.getPageNum();
            this.p = rec.page;
            this.offset = rec.offset - 2;
            this.node = null;
        } else {
            if (-1L < this.startAddress) {
                DOMFile.RecordPos rec = this.db.findRecord(this.startAddress);
                if (rec == null) return false;
                this.page = rec.page.getPageNum();
                this.offset = rec.offset - 2;
                this.p = rec.page;
                this.startAddress = -1L;
                return true;
            }
            if (this.page == -1L) {
                return false;
            }
        }
        this.p = this.db.getCurrentPage(this.page);
        this.db.addToBuffer(this.p);
        return true;
    }

    public void setTo(NodeProxy node) {
        if (-1L < node.getInternalAddress()) {
            this.startAddress = node.getInternalAddress();
        } else {
            this.node = node;
        }
    }

    public void setTo(long address) {
        this.startAddress = address;
    }
}

