/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.serializers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.XMLUtil;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.value.Sequence;
import org.xml.sax.SAXException;

public class XIncludeFilter
implements Receiver {
    private static final Logger LOG = Logger.getLogger((Class)XIncludeFilter.class);
    public static final String XINCLUDE_NS = "http://www.w3.org/2001/XInclude";
    private static final QName HREF_ATTRIB = new QName("href", "");
    private Receiver receiver;
    private Serializer serializer;
    private DocumentImpl document = null;
    private HashMap namespaces = new HashMap(10);

    public XIncludeFilter(Serializer serializer, Receiver receiver) {
        this.receiver = receiver;
        this.serializer = serializer;
    }

    public XIncludeFilter(Serializer serializer) {
        this(serializer, null);
    }

    public void setReceiver(Receiver handler) {
        this.receiver = handler;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setDocument(DocumentImpl doc) {
        this.document = doc;
    }

    public void characters(CharSequence seq) throws SAXException {
        this.receiver.characters(seq);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.receiver.comment(ch, start, length);
    }

    public void endDocument() throws SAXException {
        this.receiver.endDocument();
    }

    public void endElement(QName qname) throws SAXException {
        if (!qname.getNamespaceURI().equals(XINCLUDE_NS)) {
            this.receiver.endElement(qname);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
        this.receiver.endPrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.receiver.processingInstruction(target, data);
    }

    public void startDocument() throws SAXException {
        this.receiver.startDocument();
    }

    public void attribute(QName qname, String value) throws SAXException {
        this.receiver.attribute(qname, value);
    }

    public void startElement(QName qname, AttrList attribs) throws SAXException {
        if (qname.getNamespaceURI() != null && qname.getNamespaceURI().equals(XINCLUDE_NS)) {
            if (qname.getLocalName().equals("include")) {
                LOG.debug((Object)"processing include ...");
                this.processXInclude(attribs.getValue(HREF_ATTRIB));
            }
        } else {
            this.receiver.startElement(qname, attribs);
        }
    }

    protected void processXInclude(String href) throws SAXException {
        if (href == null) {
            throw new SAXException("No href attribute found in XInclude include element");
        }
        DocumentImpl prevDoc = this.document;
        boolean createContainerElements = this.serializer.createContainerElements;
        this.serializer.createContainerElements = false;
        if (href != null) {
            LOG.debug((Object)("found href=\"" + href + "\""));
            String xpointer = null;
            String docName = href;
            int p = href.indexOf(35);
            if (-1 < p) {
                docName = href.substring(0, p);
                xpointer = XMLUtil.decodeAttrMarkup(href.substring(p + 1));
                LOG.debug((Object)("found xpointer: " + xpointer));
            }
            if ((p = docName.lastIndexOf(47)) < 0 && this.document != null) {
                docName = this.document.getCollection().getName() + '/' + docName;
            }
            LOG.debug((Object)("loading " + docName));
            DocumentImpl doc = null;
            try {
                doc = (DocumentImpl)this.serializer.broker.getDocument(docName);
                if (doc != null && !doc.getPermissions().validate(this.serializer.broker.getUser(), 4)) {
                    throw new PermissionDeniedException("Permission denied to read xincluded resource");
                }
            }
            catch (PermissionDeniedException e) {
                LOG.warn((Object)"permission denied", (Throwable)e);
                throw new SAXException(e);
            }
            if (doc == null && xpointer == null) {
                throw new SAXException("document " + docName + " not found");
            }
            if (xpointer == null) {
                this.serializer.serializeToReceiver(doc, false);
            } else {
                try {
                    XQueryContext context = new XQueryContext(this.serializer.broker);
                    if (doc != null) {
                        context.setStaticallyKnownDocuments(new String[]{doc.getName()});
                    } else {
                        context.setStaticallyKnownDocuments(new String[]{docName});
                    }
                    xpointer = this.checkNamespaces(context, xpointer);
                    context.declareNamespaces(this.namespaces);
                    XQueryLexer lexer = new XQueryLexer(context, new StringReader(xpointer));
                    XQueryParser parser = new XQueryParser(lexer);
                    XQueryTreeParser treeParser = new XQueryTreeParser(context);
                    parser.xpointer();
                    if (parser.foundErrors()) {
                        throw new SAXException(parser.getErrorMessage());
                    }
                    AST ast = parser.getAST();
                    PathExpr expr = new PathExpr(context);
                    treeParser.xpointer(ast, expr);
                    if (treeParser.foundErrors()) {
                        throw new SAXException(treeParser.getErrorMessage());
                    }
                    LOG.info((Object)("xpointer query: " + expr.pprint()));
                    long start = System.currentTimeMillis();
                    Sequence seq = expr.eval(null, null);
                    switch (seq.getItemType()) {
                        case -1: {
                            NodeSet set = (NodeSet)seq;
                            LOG.info((Object)("xpointer found: " + set.getLength()));
                            Iterator i = set.iterator();
                            while (i.hasNext()) {
                                NodeProxy proxy = (NodeProxy)i.next();
                                this.serializer.serializeToReceiver(proxy, false);
                            }
                            break;
                        }
                        default: {
                            for (int i = 0; i < seq.getLength(); ++i) {
                                String val = seq.itemAt(i).getStringValue();
                                this.characters(val);
                            }
                        }
                    }
                }
                catch (RecognitionException e) {
                    LOG.warn((Object)"xpointer error", (Throwable)e);
                    throw new SAXException((Exception)((Object)e));
                }
                catch (TokenStreamException e) {
                    LOG.warn((Object)"xpointer error", (Throwable)e);
                    throw new SAXException((Exception)((Object)e));
                }
                catch (XPathException e) {
                    throw new SAXException(e);
                }
            }
        }
        this.document = prevDoc;
        this.serializer.createContainerElements = createContainerElements;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.put(prefix, uri);
        this.receiver.startPrefixMapping(prefix, uri);
    }

    private String checkNamespaces(XQueryContext context, String xpointer) throws XPathException {
        int p0 = -1;
        while ((p0 = xpointer.indexOf("xmlns(")) > -1) {
            if (p0 < 0) {
                return xpointer;
            }
            int p1 = xpointer.indexOf(41, p0 + 6);
            if (p1 < 0) {
                throw new XPathException("expected ) for xmlns()");
            }
            String mapping = xpointer.substring(p0 + 6, p1);
            xpointer = xpointer.substring(0, p0) + xpointer.substring(p1 + 1);
            StringTokenizer tok = new StringTokenizer(mapping, "= \t\n");
            if (tok.countTokens() < 2) {
                throw new XPathException("expected prefix=namespace mapping in " + mapping);
            }
            String prefix = tok.nextToken();
            String namespaceURI = tok.nextToken();
            this.namespaces.put(prefix, namespaceURI);
        }
        return xpointer;
    }
}

