/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.serializers;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.oro.text.perl.Perl5Util;
import org.exist.dom.AttrImpl;
import org.exist.dom.CommentImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.Match;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.ProcessingInstructionImpl;
import org.exist.dom.QName;
import org.exist.dom.TextImpl;
import org.exist.dom.XMLUtil;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.Configuration;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.xquery.value.Type;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class NativeSerializer
extends Serializer {
    public static final int EXIST_ID_NONE = 0;
    public static final int EXIST_ID_ELEMENT = 1;
    public static final int EXIST_ID_ALL = 2;
    private static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    private static final QName MATCH_ELEMENT = new QName("match", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName TEXT_ELEMENT = new QName("text", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName ATTRIB_ELEMENT = new QName("attribute", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName SOURCE_ATTRIB = new QName("source", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName ID_ATTRIB = new QName("id", "http://exist.sourceforge.net/NS/exist", "exist");
    private int showId = 1;
    private Perl5Util reutil = new Perl5Util();

    public NativeSerializer(DBBroker broker, Configuration config) {
        super(broker, config);
        String showIdParam = (String)config.getProperty("serialization.add-exist-id");
        if (showIdParam != null) {
            this.showId = showIdParam.equals("element") ? 1 : (showIdParam.equals("all") ? 2 : 0);
        }
    }

    protected void serializeToReceiver(NodeProxy p, boolean generateDocEvent) throws SAXException {
        if (Type.subTypeOf(p.getType(), 6) || p.gid < 0L) {
            this.serializeToReceiver(p.getDocument(), generateDocEvent);
            return;
        }
        this.setDocument(p.getDocument());
        if (generateDocEvent) {
            this.receiver.startDocument();
        }
        Iterator domIter = this.broker.getNodeIterator(p);
        this.serializeToReceiver(null, domIter, p.getDocument(), p.gid, true, p.getMatches(), new TreeSet());
        if (generateDocEvent) {
            this.receiver.endDocument();
        }
    }

    protected void serializeToReceiver(DocumentImpl doc, boolean generateDocEvent) throws SAXException {
        long start = System.currentTimeMillis();
        this.setDocument(doc);
        NodeList children = doc.getChildNodes();
        if (generateDocEvent) {
            this.receiver.startDocument();
        }
        for (int i = 0; i < children.getLength(); ++i) {
            NodeImpl n = (NodeImpl)children.item(i);
            NodeProxy p = new NodeProxy((DocumentImpl)n.getOwnerDocument(), n.getGID(), n.getInternalAddress());
            Iterator domIter = this.broker.getNodeIterator(p);
            domIter.next();
            this.serializeToReceiver(n, domIter, (DocumentImpl)n.getOwnerDocument(), n.getGID(), true, p.getMatches(), new TreeSet());
        }
        LOG.debug((Object)("serializing document " + doc.getDocId() + "to SAX took " + (System.currentTimeMillis() - start)));
        if (generateDocEvent) {
            this.receiver.endDocument();
        }
    }

    protected void serializeToReceiver(NodeImpl node, Iterator iter, DocumentImpl doc, long gid, boolean first, Match match, Set namespaces) throws SAXException {
        if (node == null) {
            node = (NodeImpl)iter.next();
        }
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                String ns;
                String defaultNS = null;
                if (((ElementImpl)node).declaresNamespacePrefixes()) {
                    Iterator i = ((ElementImpl)node).getPrefixes();
                    while (i.hasNext()) {
                        String prefix = (String)i.next();
                        if (prefix.length() == 0) {
                            defaultNS = ((ElementImpl)node).getNamespaceForPrefix(prefix);
                            this.receiver.startPrefixMapping("", defaultNS);
                            namespaces.add(defaultNS);
                            continue;
                        }
                        String uri = ((ElementImpl)node).getNamespaceForPrefix(prefix);
                        if (uri.equals("http://exist.sourceforge.net/NS/exist")) continue;
                        this.receiver.startPrefixMapping(prefix, uri);
                        namespaces.add(uri);
                    }
                }
                String string = ns = defaultNS == null ? node.getNamespaceURI() : defaultNS;
                if (ns.length() > 0 && !namespaces.contains(ns)) {
                    this.receiver.startPrefixMapping(node.getPrefix(), ns);
                }
                AttrList attribs = new AttrList();
                if (first && this.showId == 1 || this.showId == 2) {
                    attribs.addAttribute(ID_ATTRIB, Long.toString(gid));
                }
                if (first && this.showId > 0) {
                    String src = doc.getCollection().getName() + '/' + doc.getFileName();
                    attribs.addAttribute(SOURCE_ATTRIB, doc.getFileName());
                }
                int children = node.getChildCount();
                int count = 0;
                NodeImpl child = null;
                if (children > 0) {
                    gid = XMLUtil.getFirstChildId(doc, gid);
                }
                while (count < children && (child = (NodeImpl)iter.next()).getNodeType() == 2) {
                    String cdata = (this.getHighlightingMode() & 2) > 0 ? this.processAttribute(((AttrImpl)child).getValue(), gid, match) : ((AttrImpl)child).getValue();
                    attribs.addAttribute(child.getQName(), cdata);
                    ++count;
                    ++gid;
                    child.release();
                }
                this.receiver.startElement(node.getQName(), attribs);
                while (count < children) {
                    this.serializeToReceiver(child, iter, doc, gid++, false, match, namespaces);
                    if (++count >= children) break;
                    child = (NodeImpl)iter.next();
                }
                this.receiver.endElement(node.getQName());
                if (((ElementImpl)node).declaresNamespacePrefixes()) {
                    Iterator i = ((ElementImpl)node).getPrefixes();
                    while (i.hasNext()) {
                        String prefix = (String)i.next();
                        this.receiver.endPrefixMapping(prefix);
                    }
                }
                if (ns.length() > 0 && !namespaces.contains(ns)) {
                    this.receiver.endPrefixMapping(node.getPrefix());
                }
                node.release();
                break;
            }
            case 3: {
                String cdata;
                if (first && this.createContainerElements) {
                    AttrList tattribs = new AttrList();
                    if (this.showId > 0) {
                        tattribs.addAttribute(ID_ATTRIB, Long.toString(gid));
                        tattribs.addAttribute(SOURCE_ATTRIB, doc.getFileName());
                    }
                    this.receiver.startElement(TEXT_ELEMENT, tattribs);
                }
                if ((this.getHighlightingMode() & 1) == 1 && (cdata = this.processText((TextImpl)node, gid, match)) != null) {
                    this.textToReceiver(cdata, this.receiver);
                } else {
                    this.receiver.characters(((TextImpl)node).getXMLString());
                }
                if (first && this.createContainerElements) {
                    this.receiver.endElement(TEXT_ELEMENT);
                }
                node.release();
                break;
            }
            case 2: {
                String cdata = (this.getHighlightingMode() & 2) == 2 ? this.processAttribute(((AttrImpl)node).getValue(), gid, match) : ((AttrImpl)node).getValue();
                if (first && this.createContainerElements) {
                    AttrList tattribs = new AttrList();
                    if (this.showId > 0) {
                        tattribs.addAttribute(ID_ATTRIB, Long.toString(gid));
                        tattribs.addAttribute(SOURCE_ATTRIB, doc.getFileName());
                    }
                    tattribs.addAttribute(((AttrImpl)node).getQName(), cdata);
                    this.receiver.startElement(ATTRIB_ELEMENT, tattribs);
                    this.receiver.endElement(ATTRIB_ELEMENT);
                } else {
                    this.receiver.attribute(node.getQName(), cdata);
                }
                node.release();
                break;
            }
            case 7: {
                this.receiver.processingInstruction(((ProcessingInstructionImpl)node).getTarget(), ((ProcessingInstructionImpl)node).getData());
                node.release();
                break;
            }
            case 8: {
                String comment = ((CommentImpl)node).getData();
                char[] data = new char[comment.length()];
                comment.getChars(0, data.length, data, 0);
                this.receiver.comment(data, 0, data.length);
                node.release();
            }
        }
    }

    private final String processAttribute(String data, long gid, Match match) {
        if (match == null) {
            return data;
        }
        StringBuffer expr = null;
        for (Match next = match; next != null; next = next.getNextMatch()) {
            if (next.getNodeId() != gid) continue;
            if (expr == null) {
                expr = new StringBuffer();
                expr.append("s/\\b(");
            }
            if (expr.length() > 5) {
                expr.append('|');
            }
            expr.append(next.getMatchingTerm());
        }
        if (expr != null) {
            expr.append(")\\b/||$1||/gi");
            data = this.reutil.substitute(expr.toString(), data);
        }
        return data;
    }

    private final String processText(TextImpl text, long gid, Match match) {
        if (match == null) {
            return null;
        }
        StringBuffer expr = null;
        for (Match next = match; next != null; next = next.getNextMatch()) {
            if (next.getNodeId() != gid) continue;
            if (expr == null) {
                expr = new StringBuffer();
                expr.append("s/\\b(");
            }
            if (expr.length() > 5) {
                expr.append('|');
            }
            expr.append(next.getMatchingTerm());
        }
        if (expr != null) {
            expr.append(")\\b/||$1||/gi");
            return this.reutil.substitute(expr.toString(), text.getData());
        }
        return null;
    }

    private final void textToReceiver(String data, Receiver receiver) throws SAXException {
        int p0 = 0;
        boolean inTerm = false;
        while (p0 < data.length()) {
            int p1 = data.indexOf("||", p0);
            if (p1 < 0) {
                receiver.characters(data.substring(p0));
                break;
            }
            if (inTerm) {
                receiver.startElement(MATCH_ELEMENT, null);
                receiver.characters(data.substring(p0, p1));
                receiver.endElement(MATCH_ELEMENT);
                inTerm = false;
            } else {
                inTerm = true;
                receiver.characters(data.substring(p0, p1));
            }
            p0 = p1 + 2;
        }
    }
}

