/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.io.test;

import java.io.EOFException;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteOutputStream;

public class VariableByteStreamTest
extends TestCase {
    private static final int SIZE = 1000;
    private long[] values = new long[3000];

    public VariableByteStreamTest(String arg0) {
        super(arg0);
    }

    protected void setUp() {
        System.out.println("generating 3000 numbers ...");
        Random rand = new Random(System.currentTimeMillis());
        for (int i = 0; i < 3000; ++i) {
            this.values[i++] = rand.nextInt();
            this.values[i++] = rand.nextInt() & 0xFFFFFF;
            this.values[i] = rand.nextInt() & 0xFF;
        }
    }

    public void testInOutLong() {
        VariableByteOutputStream os = new VariableByteOutputStream();
        for (int i = 0; i < 3000; ++i) {
            os.writeLong(this.values[i++]);
            os.writeInt((int)this.values[i++]);
            os.writeShort((short)this.values[i]);
        }
        byte[] data = os.toByteArray();
        System.out.println("long data length: " + data.length + "; original: " + 14000);
        VariableByteArrayInput is = new VariableByteArrayInput(data);
        try {
            for (int j = 0; j < 3000; ++j) {
                long l = is.readLong();
                VariableByteStreamTest.assertEquals((long)l, (long)this.values[j++]);
                int i = is.readInt();
                VariableByteStreamTest.assertEquals((long)i, (long)this.values[j++]);
                short s = is.readShort();
                VariableByteStreamTest.assertEquals((long)s, (long)this.values[j]);
            }
        }
        catch (EOFException e) {
            VariableByteStreamTest.fail((String)("Exception: " + e));
        }
        catch (IOException e) {
            VariableByteStreamTest.fail((String)("Exception: " + e));
        }
    }

    public void testCopyTo() throws IOException {
        Random rand = new Random(System.currentTimeMillis());
        int valuesWritten = 0;
        int dataLen = 0;
        VariableByteOutputStream os = new VariableByteOutputStream();
        for (int i = 0; i < 1000; ++i) {
            int count = rand.nextInt(4095);
            os.writeShort((short)count);
            dataLen += 2;
            for (int j = 0; j < count; ++j) {
                int next = rand.nextInt(255);
                os.writeShort((short)next);
                ++valuesWritten;
                dataLen += 2;
            }
        }
        byte[] data = os.toByteArray();
        System.out.println(valuesWritten + " values written");
        System.out.println("compressed data length: " + data.length + "; original: " + dataLen);
        int valuesCopied = 0;
        dataLen = 0;
        VariableByteArrayInput is = new VariableByteArrayInput(data);
        os = new VariableByteOutputStream();
        while (is.available() > 0) {
            short count = is.readShort();
            boolean skip = rand.nextBoolean();
            if (skip) {
                is.skip(count);
                continue;
            }
            os.writeShort(count);
            is.copyTo(os, count);
            valuesCopied += count;
            dataLen += 2 * count + 2;
        }
        data = os.toByteArray();
        System.out.println("copied " + valuesCopied + " values; skipped " + (valuesWritten - valuesCopied));
        System.out.println("compressed data length: " + data.length + "; original: " + dataLen);
        int valuesRead = 0;
        is = new VariableByteArrayInput(data);
        while (is.available() > 0) {
            int count = is.readShort();
            for (int i = 0; i < count; ++i) {
                is.readShort();
                ++valuesRead;
            }
        }
        VariableByteStreamTest.assertEquals((int)valuesRead, (int)valuesCopied);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)VariableByteStreamTest.class);
    }
}

