/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.exist.util.ByteArray;
import org.exist.util.FastByteBuffer;

public class VariableByteOutputStream
extends OutputStream {
    protected ByteArray buf;

    public VariableByteOutputStream() {
        this.buf = new FastByteBuffer(9);
    }

    public VariableByteOutputStream(int size) {
        this.buf = new FastByteBuffer(size);
    }

    public void clear() {
        this.buf.setLength(0);
    }

    public void close() throws IOException {
        this.buf = null;
    }

    public void flush() throws IOException {
    }

    public byte[] toByteArray() {
        byte[] b = new byte[this.buf.size()];
        this.buf.copyTo(b, 0);
        return b;
    }

    public ByteArray data() {
        return this.buf;
    }

    public void write(int b) throws IOException {
        this.buf.append((byte)b);
    }

    public void write(byte[] b) {
        this.buf.append(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.buf.append(b, off, len);
    }

    public void write(ByteArray b) {
        b.copyTo(this.buf);
    }

    public void writeByte(byte b) {
        this.buf.append(b);
    }

    public void writeShort(int s) {
        while ((s & 0xFFFFFF80) != 0) {
            this.buf.append((byte)(s & 0x7F | 0x80));
            s >>>= 7;
        }
        this.buf.append((byte)s);
    }

    public void writeInt(int i) {
        while ((i & 0xFFFFFF80) != 0) {
            this.buf.append((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.buf.append((byte)i);
    }

    public void writeLong(long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.buf.append((byte)(l & 0x7FL | 0x80L));
            l >>>= 7;
        }
        this.buf.append((byte)l);
    }

    public void writeFixedLong(long l) {
        this.buf.append((byte)(l >>> 56 & 0xFFL));
        this.buf.append((byte)(l >>> 48 & 0xFFL));
        this.buf.append((byte)(l >>> 40 & 0xFFL));
        this.buf.append((byte)(l >>> 32 & 0xFFL));
        this.buf.append((byte)(l >>> 24 & 0xFFL));
        this.buf.append((byte)(l >>> 16 & 0xFFL));
        this.buf.append((byte)(l >>> 8 & 0xFFL));
        this.buf.append((byte)(l >>> 0 & 0xFFL));
    }

    public void writeUTF(String s) throws IOException {
        byte[] data = null;
        try {
            data = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            data = s.getBytes();
        }
        this.writeInt(data.length);
        this.write(data, 0, data.length);
    }
}

