/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.cache;

import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.util.hashtable.Long2ObjectHashMap;

public class GClockCache
implements Cache {
    protected Cacheable[] items;
    protected int count = 0;
    protected int size;
    protected Long2ObjectHashMap map;
    protected int used = 0;
    protected int hits = 0;
    protected int fails = 0;

    public GClockCache(int size) {
        this.size = size;
        this.items = new Cacheable[size];
        this.map = new Long2ObjectHashMap(size);
    }

    public void add(Cacheable item) {
        this.add(item, 1);
    }

    public void add(Cacheable item, int initialRefCount) {
        Cacheable old = (Cacheable)this.map.get(item.getKey());
        if (old != null) {
            old.incReferenceCount();
            return;
        }
        item.setReferenceCount(initialRefCount);
        if (this.count < this.size) {
            this.items[this.count++] = item;
            this.map.put(item.getKey(), item);
            ++this.used;
        } else {
            this.removeOne(item);
        }
    }

    public Cacheable get(Cacheable item) {
        return this.get(item.getKey());
    }

    public Cacheable get(long key) {
        Cacheable item = (Cacheable)this.map.get(key);
        if (item == null) {
            ++this.fails;
        } else {
            ++this.hits;
        }
        return item;
    }

    public void remove(Cacheable item) {
        long key = item.getKey();
        Cacheable cacheable = (Cacheable)this.map.remove(key);
        if (cacheable == null) {
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || this.items[i].getKey() != key) continue;
            this.items[i] = null;
            --this.used;
            return;
        }
        LOG.error((Object)"item not found in list");
    }

    public void flush() {
        int written = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || !this.items[i].sync()) continue;
            ++written;
        }
    }

    public boolean hasDirtyItems() {
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || !this.items[i].isDirty()) continue;
            return true;
        }
        return false;
    }

    protected Cacheable removeOne(Cacheable item) {
        Cacheable old = null;
        boolean removed = false;
        do {
            int bucket = -1;
            for (int i = 0; i < this.count; ++i) {
                old = this.items[i];
                if (old == null) {
                    bucket = i;
                    continue;
                }
                if (old.decReferenceCount() >= 1 || bucket >= 0) continue;
                bucket = i;
            }
            if (bucket <= -1) continue;
            old = this.items[bucket];
            if (old != null) {
                this.map.remove(old.getKey());
                old.sync();
            } else {
                ++this.used;
            }
            this.items[bucket] = item;
            this.map.put(item.getKey(), item);
            removed = true;
        } while (!removed);
        return old;
    }

    public int getBuffers() {
        return this.size;
    }

    public int getUsedBuffers() {
        return this.used;
    }

    public int getHits() {
        return this.hits;
    }

    public int getFails() {
        return this.fails;
    }

    public void setFileName(String fileName) {
    }
}

