/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.cache;

import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.util.hashtable.Long2ObjectHashMap;

public class ClockCache
implements Cache {
    protected Long2ObjectHashMap map;
    protected Cacheable[] items;
    protected int size;
    protected int count = 0;
    protected int hits = 0;
    protected int fails = 0;

    public ClockCache(int size) {
        this.size = size;
        this.items = new Cacheable[size];
        this.map = new Long2ObjectHashMap(size);
    }

    public void add(Cacheable item, int initialRefCount) {
        this.add(item);
    }

    public void add(Cacheable item) {
        Cacheable old = (Cacheable)this.map.get(item.getKey());
        if (old != null) {
            old.setReferenceCount(1);
        } else {
            item.setReferenceCount(1);
            if (this.count < this.size) {
                this.items[this.count++] = item;
                this.map.put(item.getKey(), item);
            } else {
                this.removeOne(item);
            }
        }
    }

    protected Cacheable removeOne(Cacheable item) {
        Cacheable old;
        int bucket = -1;
        do {
            for (int i = 0; i < this.count; ++i) {
                old = this.items[i];
                if (old == null) {
                    bucket = i;
                    continue;
                }
                if (old.getReferenceCount() == 0 && old.allowUnload()) {
                    if (bucket >= 0) continue;
                    bucket = i;
                    continue;
                }
                old.setReferenceCount(0);
            }
        } while (bucket < 0);
        old = this.items[bucket];
        if (old != null) {
            this.map.remove(old.getKey());
            old.sync();
        }
        this.items[bucket] = item;
        this.map.put(item.getKey(), item);
        return old;
    }

    public Cacheable get(long key) {
        Cacheable item = (Cacheable)this.map.get(key);
        if (item == null) {
            ++this.fails;
        } else {
            ++this.hits;
        }
        return item;
    }

    public Cacheable get(Cacheable item) {
        return this.get(item.getKey());
    }

    public void remove(Cacheable item) {
        long key = item.getKey();
        Cacheable cacheable = (Cacheable)this.map.remove(key);
        if (cacheable == null) {
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || this.items[i].getKey() != key) continue;
            System.arraycopy(this.items, i + 1, this.items, i, --this.count - i);
            return;
        }
        LOG.error((Object)"item not found in list");
    }

    public void flush() {
        int written = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || !this.items[i].sync()) continue;
            ++written;
        }
    }

    public boolean hasDirtyItems() {
        for (int i = 0; i < this.count; ++i) {
            if (this.items[i] == null || !this.items[i].isDirty()) continue;
            return true;
        }
        return false;
    }

    public int getBuffers() {
        return this.size;
    }

    public int getUsedBuffers() {
        return this.count;
    }

    public int getHits() {
        return this.hits;
    }

    public int getFails() {
        return this.fails;
    }

    public void setFileName(String fileName) {
    }
}

