/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.Iterator;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.exist.source.Source;
import org.exist.util.hashtable.Object2ObjectHashMap;
import org.exist.xquery.CompiledXQuery;

public class XQueryPool
extends Object2ObjectHashMap {
    private static final int MAX_STACK_SIZE = 5;
    private static final long TIMEOUT = 120000L;
    private static final long TIMEOUT_CHECK_INTERVAL = 30000L;
    private static final Logger LOG = Logger.getLogger((Class)XQueryPool.class);
    private long lastTimeOutCheck = System.currentTimeMillis();

    protected XQueryPool() {
        super(27);
    }

    public synchronized void returnCompiledXQuery(Source source, CompiledXQuery xquery) {
        Stack<CompiledXQuery> stack = (Stack<CompiledXQuery>)this.get(source);
        if (stack == null) {
            stack = new Stack<CompiledXQuery>();
            source.setCacheTimestamp(System.currentTimeMillis());
            this.put(source, stack);
        }
        if (stack.size() < 5) {
            stack.push(xquery);
        }
        this.timeoutCheck();
    }

    public synchronized CompiledXQuery borrowCompiledXQuery(Source source) {
        int idx = this.getIndex(source);
        if (idx < 0) {
            return null;
        }
        Source key = (Source)this.keys[idx];
        int validity = key.isValid();
        if (validity == 0) {
            validity = key.isValid(source);
        }
        if (validity == -1 || validity == 0) {
            this.keys[idx] = REMOVED;
            this.values[idx] = null;
            LOG.debug((Object)(source.getKey() + " is invalid"));
            return null;
        }
        Stack stack = (Stack)this.values[idx];
        if (stack != null && !stack.isEmpty()) {
            CompiledXQuery query = (CompiledXQuery)stack.pop();
            if (!query.isValid()) {
                this.remove(key);
                return null;
            }
            return query;
        }
        return null;
    }

    private void timeoutCheck() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeOutCheck < 30000L) {
            return;
        }
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Source next = (Source)i.next();
            if (currentTime - next.getCacheTimestamp() <= 120000L) continue;
            this.remove(next);
        }
    }
}

