/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.StringTokenizer;
import org.exist.util.FastStringBuffer;

public class NodePath {
    public static final String WILDCARD = "*";
    private String[] components = new String[5];
    private int pos = 0;

    public NodePath() {
    }

    public NodePath(String path) {
        this.init(path);
    }

    public void addComponent(String component) {
        if (this.pos == this.components.length) {
            String[] t = new String[this.pos + 1];
            System.arraycopy(this.components, 0, t, 0, this.pos);
            this.components = t;
        }
        this.components[this.pos++] = component;
    }

    public void removeLastComponent() {
        this.components[--this.pos] = null;
    }

    public final boolean match(NodePath other) {
        boolean skip = false;
        int i = 0;
        for (int j = 0; j < other.pos; ++j) {
            if (i == this.pos) {
                return true;
            }
            if (this.components[i].equals(WILDCARD)) {
                ++i;
                skip = true;
            }
            if (other.components[j].equals(this.components[i])) {
                ++i;
                skip = false;
                continue;
            }
            if (skip) continue;
            return false;
        }
        return i == this.pos;
    }

    public void reset() {
        for (int i = 0; i < this.pos; ++i) {
            this.components[i] = null;
        }
        this.pos = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.pos; ++i) {
            buf.append('/');
            buf.append(this.components[i]);
        }
        return buf.toString();
    }

    private void init(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        FastStringBuffer token = new FastStringBuffer();
        int pos = 0;
        char ch = '\u0000';
        int pathLen = path.length();
        block3: while (pos < pathLen) {
            ch = path.charAt(pos);
            switch (ch) {
                case '/': {
                    String next = token.toString();
                    token.reset();
                    if (next.length() > 0) {
                        this.addComponent(next);
                    }
                    if (path.charAt(++pos) != '/') continue block3;
                    this.addComponent(WILDCARD);
                    continue block3;
                }
            }
            token.append(ch);
            ++pos;
        }
        if (token.length() > 0) {
            this.addComponent(token.toString());
        }
    }
}

