/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTreeCallback;
import org.dbxml.core.filer.BTreeException;
import org.dbxml.core.indexer.IndexQuery;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.Match;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.TextImpl;
import org.exist.dom.XMLUtil;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexPaths;
import org.exist.storage.Signatures;
import org.exist.storage.TermMatcher;
import org.exist.storage.TextSearchEngine;
import org.exist.storage.analysis.TextToken;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.store.BFile;
import org.exist.util.ByteArray;
import org.exist.util.ByteConversion;
import org.exist.util.Configuration;
import org.exist.util.Lock;
import org.exist.util.LockException;
import org.exist.util.Occurrences;
import org.exist.util.ProgressIndicator;
import org.exist.util.ReadOnlyException;
import org.exist.util.UTF8;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.NodeList;

public class NativeTextEngine
extends TextSearchEngine {
    public static final byte ATTRIBUTE_SECTION = 1;
    public static final byte TEXT_SECTION = 0;
    public static final int MAX_WORD_LENGTH = 2048;
    protected BFile dbWords;
    protected InvertedIndex invIdx;
    protected boolean useCompression = false;
    protected PatternCompiler regexCompiler = new Perl5Compiler();
    protected PatternCompiler globCompiler = new GlobCompiler();
    protected PatternMatcher matcher = new Perl5Matcher();

    public NativeTextEngine(DBBroker broker, Configuration config, int buffers) {
        super(broker, config);
        int dataBuffers;
        int indexBuffers;
        boolean compress = false;
        String dataDir = (String)config.getProperty("db-connection.data-dir");
        if (dataDir == null) {
            dataDir = "data";
        }
        if ((indexBuffers = config.getInteger("db-connection.words.buffers")) < 0) {
            indexBuffers = buffers * 14;
            dataBuffers = buffers * 16;
        } else {
            dataBuffers = indexBuffers;
        }
        String temp = (String)config.getProperty("db-connection.compress");
        if (temp != null) {
            compress = temp.equals("true");
        }
        String pathSep = System.getProperty("file.separator", "/");
        try {
            this.dbWords = (BFile)config.getProperty("db-connection.words");
            if (this.dbWords == null) {
                this.dbWords = new BFile(new File(dataDir + pathSep + "words.dbx"), indexBuffers, dataBuffers);
                if (!this.dbWords.exists()) {
                    this.dbWords.create();
                } else {
                    this.dbWords.open();
                }
                config.setProperty("db-connection.words", this.dbWords);
            }
            this.invIdx = new InvertedIndex();
        }
        catch (BTreeException bte) {
            LOG.warn((Object)bte);
        }
        catch (DBException dbe) {
            LOG.warn((Object)dbe);
        }
    }

    public static final boolean containsWildcards(String str) {
        for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '*': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': {
                    return true;
                }
            }
        }
        return false;
    }

    public static final boolean startsWithWildcard(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        switch (str.charAt(0)) {
            case '*': 
            case '?': 
            case '[': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    public void close() {
        try {
            this.dbWords.close();
        }
        catch (DBException dbe) {
            LOG.debug((Object)dbe);
        }
    }

    public int getTrackMatches() {
        return this.trackMatches;
    }

    public void setTrackMatches(int flags) {
        this.trackMatches = flags;
    }

    protected void collect(Set words, Iterator domIterator) {
        byte[] data = ((Value)domIterator.next()).getData();
        short type = Signatures.getType(data[0]);
        switch (type) {
            case 1: {
                int children = ByteConversion.byteToInt(data, 1);
                for (int i = 0; i < children; ++i) {
                    this.collect(words, domIterator);
                }
                break;
            }
            case 3: {
                TextToken token;
                String s;
                try {
                    s = new String(data, 1, data.length - 1, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    s = new String(data, 1, data.length - 1);
                }
                this.tokenizer.setText(s);
                while (null != (token = this.tokenizer.nextToken())) {
                    String word = token.getText().toString();
                    if (this.stoplist.contains(word)) continue;
                    words.add(word.toLowerCase());
                }
                break;
            }
            case 2: {
                TextToken token;
                String val;
                byte idSizeType = (byte)(data[0] & 3);
                try {
                    val = new String(data, 1 + Signatures.getLength(idSizeType), data.length - 1 - Signatures.getLength(idSizeType), "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    val = new String(data, 1 + Signatures.getLength(idSizeType), data.length - 1 - Signatures.getLength(idSizeType));
                }
                this.tokenizer.setText(val);
                while (null != (token = this.tokenizer.nextToken())) {
                    String word = token.getText().toString();
                    if (this.stoplist.contains(word)) continue;
                    words.add(word.toLowerCase());
                }
                break;
            }
        }
    }

    public void flush() {
        this.invIdx.flush();
    }

    public void reindex(DocumentImpl oldDoc, NodeImpl node) {
        this.invIdx.reindex(oldDoc, node);
    }

    public void remove() {
        this.invIdx.remove();
    }

    public NodeSet getNodesContaining(XQueryContext context, DocumentSet docs, NodeSet contextSet, String expr, int type) throws TerminatedException {
        if (type == 0 && NativeTextEngine.containsWildcards(expr)) {
            type = 2;
        }
        switch (type) {
            case 0: {
                return this.getNodesExact(context, docs, contextSet, expr);
            }
        }
        return this.getNodesRegexp(context, docs, contextSet, expr, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeSet getNodesExact(XQueryContext context, DocumentSet docs, NodeSet contextSet, String expr) throws TerminatedException {
        if (expr == null) {
            return null;
        }
        if (this.stoplist.contains(expr)) {
            return null;
        }
        int sizeHint = -1;
        int freq = 1;
        VariableByteInput is = null;
        NodeProxy current = new NodeProxy();
        ExtArrayNodeSet result = new ExtArrayNodeSet(docs.getLength(), 250);
        String term = this.stem ? this.stemmer.stem(expr.toLowerCase()) : expr.toLowerCase();
        int count = 0;
        Iterator iter = docs.getCollectionIterator();
        while (iter.hasNext()) {
            Collection collection = (Collection)iter.next();
            short collectionId = collection.getId();
            WordRef ref = new WordRef(collectionId, term);
            Lock lock = this.dbWords.getLock();
            try {
                lock.acquire();
                is = this.dbWords.getAsStream(ref);
                if (is == null) continue;
                while (is.available() > 0) {
                    int docId = is.readInt();
                    byte section = is.readByte();
                    int len = is.readInt();
                    DocumentImpl doc = docs.getDoc(docId);
                    if (doc == null || contextSet != null && !contextSet.containsDoc(doc)) {
                        is.skip(this.termFreq ? len * 2 : len);
                        continue;
                    }
                    if (contextSet != null) {
                        sizeHint = contextSet.getSizeHint(doc);
                    }
                    long last = 0L;
                    for (int j = 0; j < len; ++j) {
                        block22: {
                            block21: {
                                long gid = last + is.readLong();
                                if (this.termFreq) {
                                    freq = is.readInt();
                                }
                                last = gid;
                                ++count;
                                NodeProxy nodeProxy = current = section == 0 ? new NodeProxy(doc, gid, 3) : new NodeProxy(doc, gid, 2);
                                if (contextSet == null) break block21;
                                NodeProxy parent = contextSet.parentWithChild(current, false, true, -1);
                                if (parent != null) {
                                    Match match = new Match(term, gid);
                                    match.setFrequency(freq);
                                    result.add(parent, sizeHint);
                                    if (this.trackMatches != 0) {
                                        parent.addMatch(match);
                                    }
                                }
                                break block22;
                            }
                            result.add(current, sizeHint);
                        }
                        context.proceed();
                    }
                }
            }
            catch (EOFException e) {
            }
            catch (LockException e) {
                LOG.warn((Object)"could not acquire lock on words db", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Object)"io error while reading words", (Throwable)e);
            }
            finally {
                lock.release();
            }
        }
        if (contextSet != null) {
            result.sort();
        }
        return result;
    }

    private NodeSet getNodesRegexp(XQueryContext context, DocumentSet docs, NodeSet contextSet, String expr, int type) throws TerminatedException {
        if (expr == null) {
            return null;
        }
        if (this.stoplist.contains(expr)) {
            return null;
        }
        expr = expr.toLowerCase();
        StringBuffer term = new StringBuffer();
        for (int j = 0; j < expr.length() && Character.isLetterOrDigit(expr.charAt(j)); ++j) {
            term.append(expr.charAt(j));
        }
        try {
            RegexMatcher comparator = new RegexMatcher(expr, type);
            return this.getNodes(context, docs, contextSet, comparator, term);
        }
        catch (EXistException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet getNodes(XQueryContext context, DocumentSet docs, NodeSet contextSet, TermMatcher matcher, CharSequence startTerm) throws TerminatedException {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        Lock lock = this.dbWords.getLock();
        SearchCallback cb = new SearchCallback(context, matcher, result, contextSet, docs);
        Iterator iter = docs.getCollectionIterator();
        while (iter.hasNext()) {
            Collection collection = (Collection)iter.next();
            short collectionId = collection.getId();
            WordRef ref = startTerm != null && startTerm.length() > 0 ? new WordRef(collectionId, ((Object)startTerm).toString().toLowerCase()) : new WordRef(collectionId);
            IndexQuery query = new IndexQuery(7, (Value)ref);
            try {
                lock.acquire();
                try {
                    this.dbWords.query(query, cb);
                }
                catch (IOException ioe) {
                    LOG.debug((Object)ioe);
                }
                catch (BTreeException bte) {
                    LOG.debug((Object)bte);
                }
            }
            catch (LockException e) {
                LOG.debug((Object)e);
            }
            finally {
                lock.release();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIndexTerms(DocumentSet docs, TermMatcher matcher) {
        long start = System.currentTimeMillis();
        Lock lock = this.dbWords.getLock();
        IndexCallback cb = new IndexCallback(null, matcher);
        Iterator iter = docs.getCollectionIterator();
        while (iter.hasNext()) {
            Collection collection = (Collection)iter.next();
            short collectionId = collection.getId();
            WordRef ref = new WordRef(collectionId);
            IndexQuery query = new IndexQuery(7, (Value)ref);
            try {
                lock.acquire();
                try {
                    this.dbWords.query(query, cb);
                }
                catch (IOException ioe) {
                    LOG.debug((Object)ioe);
                }
                catch (BTreeException bte) {
                    LOG.debug((Object)bte);
                }
                catch (TerminatedException e) {
                    LOG.debug((Object)e);
                }
            }
            catch (LockException e) {
                LOG.debug((Object)e);
            }
            finally {
                lock.release();
            }
        }
        return cb.getMatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Occurrences[] scanIndexTerms(User user, Collection collection, String start, String end, boolean inclusive) throws PermissionDeniedException {
        if (!collection.getPermissions().validate(user, 4)) {
            throw new PermissionDeniedException("permission denied");
        }
        ArrayList<Collection> collections = inclusive ? collection.getDescendants(this.broker, user) : new ArrayList<Collection>();
        collections.add(collection);
        Lock lock = this.dbWords.getLock();
        TreeMap<String, Occurrences> map = new TreeMap<String, Occurrences>();
        Iterator i = collections.iterator();
        while (i.hasNext()) {
            Collection current = (Collection)i.next();
            short collectionId = current.getId();
            IndexQuery query = new IndexQuery(4, new WordRef(collectionId, start), new WordRef(collectionId, end));
            try {
                lock.acquire();
                ArrayList values = this.dbWords.findEntries(query);
                Iterator j = values.iterator();
                while (j.hasNext()) {
                    Value[] val = (Value[])j.next();
                    String term = new String(val[0].getData(), 2, val[0].getLength() - 2, "UTF-8");
                    Occurrences oc = (Occurrences)map.get(term);
                    if (oc == null) {
                        oc = new Occurrences((Comparable)((Object)term));
                        map.put(term, oc);
                    }
                    VariableByteArrayInput is = new VariableByteArrayInput(val[1].getData());
                    try {
                        while (is.available() > 0) {
                            int docId = is.readInt();
                            byte section = is.readByte();
                            int len = is.readInt();
                            for (int k = 0; k < len; ++k) {
                                is.skip(1);
                                oc.addOccurrences(is.readInt());
                            }
                        }
                    }
                    catch (EOFException e) {
                    }
                }
            }
            catch (LockException e) {
                LOG.warn((Object)"cannot get lock on words", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Object)"error while reading words", (Throwable)e);
            }
            catch (BTreeException e) {
                LOG.warn((Object)"error while reading words", (Throwable)e);
            }
            catch (TerminatedException e) {
                LOG.warn((Object)"Method terminated", (Throwable)e);
            }
            finally {
                lock.release();
            }
        }
        Occurrences[] result = new Occurrences[map.size()];
        return map.values().toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(Collection collection) {
        Lock lock = this.dbWords.getLock();
        try {
            lock.acquire(1);
            LOG.debug((Object)"removing fulltext index ...");
            WordRef ref = new WordRef(collection.getId());
            IndexQuery query = new IndexQuery(7, (Value)ref);
            this.dbWords.flush();
            this.dbWords.removeAll(query);
        }
        catch (BTreeException bte) {
            LOG.debug((Object)bte);
        }
        catch (IOException ioe) {
            LOG.debug((Object)ioe);
        }
        catch (DBException dbe) {
            LOG.warn((Object)dbe);
        }
        catch (LockException e) {
            LOG.warn((Object)"Failed to acquire lock on collections.dbx", (Throwable)e);
        }
        finally {
            lock.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(DocumentImpl doc) {
        try {
            TreeSet words = new TreeSet();
            NodeList children = doc.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                NodeImpl node = (NodeImpl)children.item(i);
                Iterator j = this.broker.getDOMIterator(new NodeProxy(doc, node.getGID(), node.getInternalAddress()));
                this.collect(words, j);
            }
            VariableByteInput is = null;
            short collectionId = doc.getCollection().getId();
            Lock lock = this.dbWords.getLock();
            Iterator iter = words.iterator();
            while (iter.hasNext()) {
                String word = (String)iter.next();
                WordRef ref = new WordRef(collectionId, word);
                try {
                    lock.acquire(1);
                    is = this.dbWords.getAsStream(ref);
                    if (is == null) continue;
                    VariableByteOutputStream os = new VariableByteOutputStream();
                    boolean changed = false;
                    try {
                        while (is.available() > 0) {
                            int docId = is.readInt();
                            byte section = is.readByte();
                            int len = is.readInt();
                            if (docId != doc.getDocId()) {
                                os.writeInt(docId);
                                os.writeByte(section);
                                os.writeInt(len);
                                is.copyTo(os, this.termFreq ? len * 2 : len);
                                continue;
                            }
                            changed = true;
                            is.skip(this.termFreq ? len * 2 : len);
                        }
                    }
                    catch (EOFException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (!changed) continue;
                    if (os.data().size() == 0) {
                        this.dbWords.remove(ref);
                        continue;
                    }
                    if (this.dbWords.put(ref, os.data()) >= 0L || !LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("removeDocument() - could not remove index for " + word));
                }
                catch (LockException e) {
                    LOG.warn((Object)"removeDocument(DocumentImpl) - could not acquire lock on words db", (Throwable)e);
                    is = null;
                }
                catch (IOException e) {
                    LOG.error((Object)"removeDocument(DocumentImpl) - io error while reading words", (Throwable)e);
                    is = null;
                }
                finally {
                    lock.release();
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("removeDocument() - " + words.size() + " words updated."));
            }
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)"removeDocument(DocumentImpl) - database is read-only");
        }
    }

    public void storeAttribute(IndexPaths idx, AttrImpl attr) {
        TextToken token;
        DocumentImpl doc = (DocumentImpl)attr.getOwnerDocument();
        this.tokenizer.setText(attr.getValue());
        long gid = attr.getGID();
        while (null != (token = this.tokenizer.nextToken())) {
            String word;
            if (idx != null && !idx.getIncludeAlphaNum() && token.getType() == 2 || this.stoplist.contains(word = token.getText().toLowerCase()) || word.length() > 2048) continue;
            this.invIdx.setDocument(doc);
            this.invIdx.addAttribute(word, gid);
        }
    }

    public void storeText(IndexPaths idx, TextImpl text, boolean onetoken) {
        DocumentImpl doc = (DocumentImpl)text.getOwnerDocument();
        this.tokenizer.setText(text.getXMLString().transformToLower());
        long gid = text.getGID();
        if (onetoken) {
            this.invIdx.setDocument(doc);
            String sal = text.getXMLString().transformToLower().toString();
            this.invIdx.addText(sal, gid);
        } else {
            TextToken token;
            while (null != (token = this.tokenizer.nextToken())) {
                CharSequence word;
                if (idx != null && !idx.getIncludeAlphaNum() && !token.isAlpha() || this.stoplist.contains(word = token.getCharSequence()) || word.length() > 2048) continue;
                this.invIdx.setDocument(doc);
                this.invIdx.addText(word, gid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        this.dbWords.printStatistics();
        Lock lock = this.dbWords.getLock();
        try {
            lock.acquire(1);
            try {
                this.dbWords.flush();
            }
            catch (DBException dbe) {
                LOG.warn((Object)dbe);
            }
        }
        catch (LockException e) {
            LOG.warn((Object)"could not acquire lock on words db", (Throwable)e);
        }
        finally {
            lock.release();
        }
    }

    private static final class WordRef
    extends Value {
        public WordRef(short collectionId) {
            this.data = new byte[2];
            ByteConversion.shortToByte(collectionId, this.data, 0);
            this.len = 2;
        }

        public WordRef(short collectionId, String word) {
            this.len = UTF8.encoded(word) + 2;
            this.data = new byte[this.len];
            ByteConversion.shortToByte(collectionId, this.data, 0);
            UTF8.encode(word, this.data, 2);
        }

        public String toString() {
            return ByteConversion.byteToShort(this.data, this.pos) + new String(this.data, this.pos, this.len);
        }
    }

    private static class TermFrequencyList {
        private TermFreq first = null;
        private TermFreq last = null;
        private int count = 0;

        private TermFrequencyList() {
        }

        public void add(long l) {
            if (this.first == null) {
                this.last = this.first = new TermFreq(l);
            } else {
                TermFreq next;
                this.last.next = next = new TermFreq(l);
                this.last = next;
            }
            ++this.count;
        }

        public void incLastTerm() {
            if (this.last != null) {
                this.last.increment();
            }
        }

        public void setLastTermFreq(int freq) {
            if (this.last != null) {
                this.last.count = freq;
            }
        }

        public long getLast() {
            if (this.last != null) {
                return this.last.l;
            }
            return -1L;
        }

        public boolean contains(long l) {
            TermFreq next = this.first;
            while (next != null) {
                if (next.l == l) {
                    return true;
                }
                next = next.next;
            }
            return false;
        }

        public int getSize() {
            return this.count;
        }

        public TermFreq[] toArray() {
            TermFreq[] data = new TermFreq[this.count];
            TermFreq next = this.first;
            int i = 0;
            while (next != null) {
                data[i++] = next;
                next = next.next;
            }
            return data;
        }

        protected static class TermFreq
        implements Comparable {
            long l;
            int count = 1;
            TermFreq next = null;

            public TermFreq(long l) {
                this.l = l;
            }

            public void increment() {
                ++this.count;
            }

            public int compareTo(Object o) {
                TermFreq other = (TermFreq)o;
                if (this.l == other.l) {
                    return 0;
                }
                return this.l > other.l ? 1 : -1;
            }
        }
    }

    private class RegexMatcher
    implements TermMatcher {
        private Pattern regexp;

        public RegexMatcher(String expr, int type) throws EXistException {
            try {
                this.regexp = type == 1 ? NativeTextEngine.this.regexCompiler.compile(expr, 1) : NativeTextEngine.this.globCompiler.compile(expr, 5);
            }
            catch (MalformedPatternException e) {
                throw new EXistException(e);
            }
        }

        public boolean matches(String term) {
            return NativeTextEngine.this.matcher.matches(term, this.regexp);
        }
    }

    private class SearchCallback
    implements BTreeCallback {
        DocumentSet docs;
        TermMatcher matcher;
        NodeSet result;
        NodeSet contextSet;
        XQueryContext context;

        public SearchCallback(XQueryContext context, TermMatcher comparator, NodeSet result, NodeSet contextSet, DocumentSet docs) {
            this.matcher = comparator;
            this.result = result;
            this.docs = docs;
            this.contextSet = contextSet;
            this.context = context;
        }

        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            String word;
            try {
                word = new String(key.getData(), 2, key.getLength() - 2, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                word = new String(key.getData(), 2, key.getLength() - 2);
            }
            if (this.matcher.matches(word)) {
                VariableByteInput is = null;
                try {
                    is = NativeTextEngine.this.dbWords.getAsStream(pointer);
                }
                catch (IOException ioe) {
                    TextSearchEngine.LOG.warn((Object)ioe.getMessage(), (Throwable)ioe);
                }
                if (is == null) {
                    return true;
                }
                boolean k = false;
                long last = -1L;
                int freq = 1;
                int sizeHint = -1;
                try {
                    while (is.available() > 0) {
                        if (this.context != null) {
                            this.context.proceed();
                        }
                        int docId = is.readInt();
                        byte section = is.readByte();
                        int len = is.readInt();
                        DocumentImpl doc = this.docs.getDoc(docId);
                        if (doc == null) {
                            is.skip(NativeTextEngine.this.termFreq ? len * 2 : len);
                            continue;
                        }
                        if (this.contextSet != null) {
                            sizeHint = this.contextSet.getSizeHint(doc);
                        }
                        last = 0L;
                        for (int j = 0; j < len; ++j) {
                            NodeProxy proxy;
                            long gid = last + is.readLong();
                            if (NativeTextEngine.this.termFreq) {
                                freq = is.readInt();
                            }
                            last = gid;
                            NodeProxy nodeProxy = proxy = section == 0 ? new NodeProxy(doc, gid, 3) : new NodeProxy(doc, gid, 2);
                            if (this.contextSet != null) {
                                NodeProxy parent = this.contextSet.parentWithChild(proxy, false, true, -1);
                                if (parent == null) continue;
                                this.result.add(parent, sizeHint);
                                Match match = new Match(word, gid);
                                match.setFrequency(freq);
                                if (NativeTextEngine.this.trackMatches == 0) continue;
                                parent.addMatch(match);
                                continue;
                            }
                            this.result.add(proxy, sizeHint);
                        }
                    }
                }
                catch (EOFException e) {
                }
                catch (IOException e) {
                    TextSearchEngine.LOG.warn((Object)"io error while reading index", (Throwable)e);
                }
            }
            if (this.contextSet != null) {
                ((ExtArrayNodeSet)this.result).sort();
            }
            return true;
        }
    }

    private class IndexCallback
    implements BTreeCallback {
        List matches = new ArrayList();
        TermMatcher matcher;
        XQueryContext context;

        public IndexCallback(XQueryContext context, TermMatcher matcher) {
            this.matcher = matcher;
            this.context = context;
        }

        public String[] getMatches() {
            String[] a = new String[this.matches.size()];
            return this.matches.toArray(a);
        }

        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            String word;
            if (this.context != null) {
                this.context.proceed();
            }
            try {
                word = new String(key.getData(), 2, key.getLength() - 2, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                word = new String(key.getData(), 2, key.getLength() - 2);
            }
            if (this.matcher.matches(word)) {
                this.matches.add(word);
            }
            return true;
        }
    }

    final class InvertedIndex {
        private DocumentImpl doc = null;
        private Map[] words = new TreeMap[2];
        private VariableByteOutputStream os = new VariableByteOutputStream(7);

        public InvertedIndex() {
            this.words[0] = new TreeMap();
            this.words[1] = new TreeMap();
        }

        public void addText(CharSequence word, long gid) {
            TermFrequencyList buf = (TermFrequencyList)this.words[0].get(word);
            if (buf == null) {
                buf = new TermFrequencyList();
                buf.add(gid);
                this.words[0].put(((Object)word).toString(), buf);
            } else if (buf.getLast() == gid) {
                buf.incLastTerm();
            } else {
                buf.add(gid);
            }
        }

        public void addAttribute(String word, long gid) {
            TermFrequencyList buf = (TermFrequencyList)this.words[1].get(word);
            if (buf == null) {
                buf = new TermFrequencyList();
                buf.add(gid);
                this.words[1].put(word, buf);
            } else if (buf.getLast() == gid) {
                buf.incLastTerm();
            } else {
                buf.add(gid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void remove() {
            if (this.doc == null) {
                return;
            }
            collectionId = this.doc.getCollection().getId();
            freq = 1;
            val = null;
            lock = NativeTextEngine.this.dbWords.getLock();
            for (k = 0; k < 2; ++k) {
                i = this.words[k].entrySet().iterator();
                while (i.hasNext()) {
                    entry = i.next();
                    word = (String)entry.getKey();
                    idList = (TermFrequencyList)entry.getValue();
                    ref = new WordRef(collectionId, word);
                    try {
                        block24: {
                            lock.acquire(1);
                            val = NativeTextEngine.this.dbWords.get(ref);
                            this.os.clear();
                            newList = new TermFrequencyList();
                            if (val == null) break block24;
                            data = val.getData();
                            is = new VariableByteArrayInput(data);
lbl23:
                            // 2 sources

                            try {
                                while (is.available() > 0) {
                                    block25: {
                                        docId = is.readInt();
                                        section = is.readByte();
                                        len = is.readInt();
                                        if (docId != this.doc.getDocId() || section != k) break block25;
                                        last = 0L;
                                        for (j = 0; j < len; ++j) {
                                            last += is.readLong();
                                            if (NativeTextEngine.this.termFreq) {
                                                freq = is.readInt();
                                            }
                                            if (idList.contains(last)) continue;
                                            newList.add(last);
                                            newList.setLastTermFreq(freq);
                                        }
                                        ** GOTO lbl23
                                    }
                                    this.os.writeInt(docId);
                                    this.os.writeByte(section);
                                    this.os.writeInt(len);
                                    is.copyTo(this.os, NativeTextEngine.this.termFreq != false ? len * 2 : len);
                                }
                            }
                            catch (EOFException e) {
                                TextSearchEngine.LOG.error((Object)("end-of-file while reading index entry for " + word));
                            }
                            catch (IOException e) {
                                TextSearchEngine.LOG.error((Object)("io-error while reading index entry for " + word));
                            }
                        }
                        if (newList.getSize() > 0) {
                            ids = newList.toArray();
                            Arrays.sort(ids);
                            len = ids.length;
                            this.os.writeInt(this.doc.getDocId());
                            this.os.writeByte(k == 0 ? 0 : 1);
                            this.os.writeInt(len);
                            last = 0L;
                            for (j = 0; j < len; ++j) {
                                delta = ids[j].l - last;
                                if (delta < 0L) {
                                    TextSearchEngine.LOG.debug((Object)("neg. delta: " + delta + " for " + word));
                                    TextSearchEngine.LOG.debug((Object)("id = " + ids[j] + "; prev = " + last));
                                }
                                this.os.writeLong(delta);
                                if (NativeTextEngine.this.termFreq) {
                                    this.os.writeInt(ids[j].count);
                                }
                                last = ids[j].l;
                            }
                        }
                        if ((ndata = this.os.data()).size() == 0) {
                            try {
                                NativeTextEngine.this.dbWords.remove(ref);
                            }
                            catch (ReadOnlyException e) {
                                TextSearchEngine.LOG.warn((Object)("Error while removing fulltext entry: " + e.getMessage()), (Throwable)e);
                            }
                            continue;
                        }
                        try {
                            if (val == null) {
                                NativeTextEngine.this.dbWords.put(ref, this.os.data());
                                continue;
                            }
                            NativeTextEngine.this.dbWords.update(val.getAddress(), ref, this.os.data());
                        }
                        catch (ReadOnlyException e) {
                            // empty catch block
                        }
                    }
                    catch (LockException e) {
                        TextSearchEngine.LOG.warn((Object)"could not acquire lock", (Throwable)e);
                    }
                    finally {
                        lock.release();
                    }
                }
                this.words[k].clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reindex(DocumentImpl oldDoc, NodeImpl node) {
            short collectionId = oldDoc.getCollection().getId();
            int freq = 1;
            VariableByteInput is = null;
            Lock lock = NativeTextEngine.this.dbWords.getLock();
            for (byte k = 0; k < 2; ++k) {
                Iterator i = this.words[k].entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    String word = (String)entry.getKey();
                    TermFrequencyList idList = (TermFrequencyList)entry.getValue();
                    WordRef ref = new WordRef(collectionId, word);
                    try {
                        int len;
                        lock.acquire(1);
                        is = NativeTextEngine.this.dbWords.getAsStream(ref);
                        this.os.clear();
                        if (is != null) {
                            try {
                                while (is.available() > 0) {
                                    int docId = is.readInt();
                                    byte section = is.readByte();
                                    len = is.readInt();
                                    if (docId != oldDoc.getDocId() || section != k) {
                                        this.os.writeInt(docId);
                                        this.os.writeByte(section);
                                        this.os.writeInt(len);
                                        is.copyTo(this.os, NativeTextEngine.this.termFreq ? len * 2 : len);
                                        continue;
                                    }
                                    long gid = 0L;
                                    for (int j = 0; j < len; ++j) {
                                        gid += is.readLong();
                                        if (NativeTextEngine.this.termFreq) {
                                            freq = is.readInt();
                                        }
                                        if (node == null && oldDoc.getTreeLevel(gid) < oldDoc.reindexRequired()) {
                                            idList.add(gid);
                                            idList.setLastTermFreq(freq);
                                            continue;
                                        }
                                        if (node == null || XMLUtil.isDescendantOrSelf(oldDoc, node.getGID(), gid)) continue;
                                        idList.add(gid);
                                        idList.setLastTermFreq(freq);
                                    }
                                }
                            }
                            catch (EOFException e) {
                            }
                            catch (IOException e) {
                                TextSearchEngine.LOG.error((Object)("io-error while reading index entry for " + word), (Throwable)e);
                            }
                        }
                        Object[] ids = idList.toArray();
                        Arrays.sort(ids);
                        len = ids.length;
                        this.os.writeInt(oldDoc.getDocId());
                        this.os.writeByte(k == 0 ? (byte)0 : 1);
                        this.os.writeInt(len);
                        long last = 0L;
                        for (int j = 0; j < len; ++j) {
                            long delta = ((TermFrequencyList.TermFreq)ids[j]).l - last;
                            if (delta < 0L) {
                                TextSearchEngine.LOG.debug((Object)("neg. delta: " + delta + " for " + word));
                                TextSearchEngine.LOG.debug((Object)("id = " + ids[j] + "; prev = " + last));
                            }
                            this.os.writeLong(delta);
                            if (NativeTextEngine.this.termFreq) {
                                this.os.writeInt(((TermFrequencyList.TermFreq)ids[j]).count);
                            }
                            last = ((TermFrequencyList.TermFreq)ids[j]).l;
                        }
                        try {
                            if (is == null) {
                                NativeTextEngine.this.dbWords.put(ref, this.os.data());
                                continue;
                            }
                            NativeTextEngine.this.dbWords.update(((BFile.PageInputStream)((Object)is)).getAddress(), ref, this.os.data());
                        }
                        catch (ReadOnlyException e) {
                            // empty catch block
                        }
                    }
                    catch (LockException e) {
                        TextSearchEngine.LOG.error((Object)("could not acquire lock on index for '" + word + "'"));
                        is = null;
                    }
                    catch (IOException e) {
                        TextSearchEngine.LOG.error((Object)("io error while reindexing word '" + word + "'"));
                        is = null;
                    }
                    finally {
                        lock.release(1);
                    }
                }
                this.words[k].clear();
            }
        }

        public void flush() {
            int wordsCount = this.words[0].size() + this.words[1].size();
            if (this.doc == null || wordsCount == 0) {
                return;
            }
            ProgressIndicator progress = new ProgressIndicator(wordsCount, 100);
            short collectionId = this.doc.getCollection().getId();
            int count = 1;
            for (int k = 0; k < 2; ++k) {
                Iterator i = this.words[k].entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    String word = (String)entry.getKey();
                    TermFrequencyList idList = (TermFrequencyList)entry.getValue();
                    this.os.clear();
                    int len = idList.getSize();
                    this.os.writeInt(this.doc.getDocId());
                    this.os.writeByte(k == 0 ? (byte)0 : 1);
                    this.os.writeInt(len);
                    long prevId = 0L;
                    Object[] ids = idList.toArray();
                    Arrays.sort(ids);
                    for (int m = 0; m < len; ++m) {
                        long delta = ((TermFrequencyList.TermFreq)ids[m]).l - prevId;
                        if (delta < 0L) {
                            TextSearchEngine.LOG.debug((Object)("neg. delta: " + delta + " for " + word));
                            TextSearchEngine.LOG.debug((Object)("id = " + ids[m] + "; prev = " + prevId));
                        }
                        this.os.writeLong(delta);
                        if (NativeTextEngine.this.termFreq) {
                            this.os.writeInt(((TermFrequencyList.TermFreq)ids[m]).count);
                        }
                        prevId = ((TermFrequencyList.TermFreq)ids[m]).l;
                    }
                    this.flushWord(collectionId, word, this.os.data());
                    progress.setValue(count);
                    if (progress.changed()) {
                        NativeTextEngine.this.setChanged();
                        NativeTextEngine.this.notifyObservers(progress);
                    }
                    ++count;
                }
                if (wordsCount > 100) {
                    progress.finish();
                    NativeTextEngine.this.setChanged();
                    NativeTextEngine.this.notifyObservers(progress);
                }
                this.words[k].clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushWord(short collectionId, String word, ByteArray data) {
            if (data.size() == 0) {
                return;
            }
            Lock lock = NativeTextEngine.this.dbWords.getLock();
            try {
                lock.acquire(1);
                try {
                    NativeTextEngine.this.dbWords.append(new WordRef(collectionId, word), data);
                }
                catch (ReadOnlyException e) {
                }
                catch (IOException ioe) {
                    TextSearchEngine.LOG.warn((Object)("io error while writing '" + word + "'"), (Throwable)ioe);
                }
            }
            catch (LockException e) {
                TextSearchEngine.LOG.warn((Object)"could not acquire lock", (Throwable)e);
            }
            finally {
                lock.release();
            }
        }

        public void setDocument(DocumentImpl doc) {
            if (this.doc != null && this.doc.getDocId() != doc.getDocId()) {
                this.flush();
            }
            this.doc = doc;
        }
    }
}

