/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTreeException;
import org.dbxml.core.filer.Paged;
import org.dbxml.core.indexer.IndexQuery;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.CollectionCache;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.ArraySet;
import org.exist.dom.AttrImpl;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeIndexListener;
import org.exist.dom.NodeListImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.TextImpl;
import org.exist.dom.XMLUtil;
import org.exist.security.MD5;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.ElementIndex;
import org.exist.storage.IndexPaths;
import org.exist.storage.NativeElementIndex;
import org.exist.storage.NativeTextEngine;
import org.exist.storage.NodePath;
import org.exist.storage.TextSearchEngine;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.serializers.NativeSerializer;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.store.BFile;
import org.exist.storage.store.CollectionStore;
import org.exist.storage.store.DOMFile;
import org.exist.storage.store.DOMFileIterator;
import org.exist.storage.store.DOMTransaction;
import org.exist.storage.store.NodeIterator;
import org.exist.storage.store.StorageAddress;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.Collations;
import org.exist.util.Configuration;
import org.exist.util.Lock;
import org.exist.util.LockException;
import org.exist.util.ReadOnlyException;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NativeBroker
extends DBBroker {
    private static final String TEMP_FRAGMENT_REMOVE_ERROR = "Could not remove temporary fragment";
    private static final String TEMP_STORE_ERROR = "An error occurred while storing temporary data: ";
    private static final String EXCEPTION_DURING_REINDEX = "exception during reindex";
    private static final String DATABASE_IS_READ_ONLY = "database is read-only";
    private static final Logger LOG = Logger.getLogger((Class)NativeBroker.class);
    private static final long TEMP_FRAGMENT_TIMEOUT = 300000L;
    private static final String ROOT_COLLECTION = "/db";
    private static final String TEMP_COLLECTION = "/db/system/temp";
    protected static final int BUFFERS = 256;
    protected static final int MEM_LIMIT_CHECK = 10000;
    protected CollectionStore collectionsDb = null;
    protected DOMFile domDb = null;
    protected NativeElementIndex elementIndex;
    protected BFile elementsDb = null;
    protected NativeTextEngine textEngine;
    protected Serializer xmlSerializer;
    protected PatternCompiler compiler = new Perl5Compiler();
    protected PatternMatcher matcher = new Perl5Matcher();
    protected int defaultIndexDepth = 1;
    protected Map idxPathMap;
    protected boolean readOnly = false;
    protected int memMinFree;
    protected int nodesCount = 0;
    protected int pageSize;
    private final Runtime run = Runtime.getRuntime();
    static /* synthetic */ Class class$org$exist$storage$NativeBroker$NodeRef;

    public NativeBroker(BrokerPool pool, Configuration config) throws EXistException {
        super(pool, config);
        int cacheSize;
        int buffers;
        boolean compress = false;
        String dataDir = (String)config.getProperty("db-connection.data-dir");
        if (dataDir == null) {
            dataDir = "data";
        }
        if ((this.pageSize = config.getInteger("db-connection.page-size")) < 0) {
            this.pageSize = 4096;
        }
        if ((buffers = config.getInteger("db-connection.buffers")) < 0) {
            buffers = 256;
        }
        if ((cacheSize = config.getInteger("db-connection.cache-size")) > 0) {
            long totalMem = cacheSize * 1024 * 1024;
            buffers = (int)(totalMem / (long)this.pageSize / 64L);
        }
        if ((this.defaultIndexDepth = config.getInteger("indexer.index-depth")) < 0) {
            this.defaultIndexDepth = 1;
        }
        if ((this.memMinFree = config.getInteger("db-connection.min_free_memory")) < 0) {
            this.memMinFree = 5000000;
        }
        Paged.setPageSize(this.pageSize);
        String pathSep = System.getProperty("file.separator", "/");
        try {
            int dataBuffers;
            int indexBuffers;
            this.elementsDb = (BFile)config.getProperty("db-connection.elements");
            if (this.elementsDb == null) {
                indexBuffers = config.getInteger("db-connection.elements.buffers");
                if (indexBuffers < 0) {
                    indexBuffers = buffers * 4;
                    dataBuffers = buffers * 10;
                } else {
                    dataBuffers = indexBuffers >> 2;
                }
                LOG.debug((Object)("elements index buffer size: " + indexBuffers + "; " + dataBuffers));
                this.elementsDb = new BFile(new File(dataDir + pathSep + "elements.dbx"), indexBuffers, dataBuffers);
                if (!this.elementsDb.exists()) {
                    LOG.info((Object)"creating elements.dbx");
                    this.elementsDb.create();
                } else {
                    this.elementsDb.open();
                }
                config.setProperty("db-connection.elements", this.elementsDb);
                this.readOnly = this.elementsDb.isReadOnly();
            }
            if ((this.domDb = (DOMFile)config.getProperty("db-connection.dom")) == null) {
                if (config.hasProperty("db-connection.buffers")) {
                    indexBuffers = buffers;
                    dataBuffers = 512;
                } else {
                    indexBuffers = buffers * 4;
                    dataBuffers = buffers * 4;
                }
                LOG.debug((Object)("page buffer size = " + indexBuffers + "; " + dataBuffers));
                this.domDb = new DOMFile(new File(dataDir + pathSep + "dom.dbx"), indexBuffers, dataBuffers);
                if (!this.domDb.exists()) {
                    LOG.info((Object)"creating dom.dbx");
                    this.domDb.create();
                } else {
                    this.domDb.open();
                }
                config.setProperty("db-connection.dom", this.domDb);
                if (!this.readOnly) {
                    this.readOnly = this.domDb.isReadOnly();
                }
            }
            if ((this.collectionsDb = (CollectionStore)config.getProperty("db-connection.collections")) == null) {
                indexBuffers = config.getInteger("db-connection.collections.buffers");
                if (indexBuffers < 0) {
                    indexBuffers = buffers * 6;
                    dataBuffers = buffers * 6;
                } else {
                    dataBuffers = indexBuffers;
                }
                LOG.debug((Object)("collections index buffer size: " + indexBuffers + "; " + dataBuffers));
                this.collectionsDb = new CollectionStore(new File(dataDir + pathSep + "collections.dbx"), indexBuffers, dataBuffers);
                if (!this.collectionsDb.exists()) {
                    LOG.info((Object)"creating collections.dbx");
                    this.collectionsDb.create();
                } else {
                    this.collectionsDb.open();
                }
                config.setProperty("db-connection.collections", this.collectionsDb);
                if (!this.readOnly) {
                    this.readOnly = this.collectionsDb.isReadOnly();
                }
            }
            if (this.readOnly) {
                LOG.info((Object)"database runs in read-only mode");
            }
            this.idxPathMap = (Map)config.getProperty("indexer.map");
            this.textEngine = new NativeTextEngine(this, config, buffers);
            this.xmlSerializer = new NativeSerializer(this, config);
            this.elementIndex = new NativeElementIndex(this, config, this.elementsDb);
            this.user = new User("admin", null, "dba");
            if (pool.isInitializing()) {
                this.getOrCreateCollection(ROOT_COLLECTION);
            }
        }
        catch (DBException e) {
            LOG.debug((Object)("failed to initialize database: " + e.getMessage()), (Throwable)e);
            throw new EXistException(e);
        }
        catch (PermissionDeniedException e) {
            LOG.debug((Object)("failed to initialize database: " + e.getMessage()), (Throwable)e);
            throw new EXistException(e);
        }
    }

    protected static final String normalizeCollectionName(String name) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '/' && name.length() > i + 1 && name.charAt(i + 1) == '/') {
                ++i;
                continue;
            }
            out.append(name.charAt(i));
        }
        return out.toString();
    }

    public void addObserver(Observer o) {
        super.addObserver(o);
        this.textEngine.addObserver(o);
        this.elementIndex.addObserver(o);
    }

    private final boolean compare(Collator collator, String o1, String o2, int relation) {
        int cmp = Collations.compare(collator, o1, o2);
        switch (relation) {
            case 0: {
                return cmp < 0;
            }
            case 3: {
                return cmp <= 0;
            }
            case 1: {
                return cmp > 0;
            }
            case 2: {
                return cmp >= 0;
            }
            case 4: {
                return cmp == 0;
            }
            case 5: {
                return cmp != 0;
            }
        }
        return false;
    }

    public ElementIndex getElementIndex() {
        return this.elementIndex;
    }

    public void flush() {
        this.textEngine.flush();
        this.elementIndex.flush();
        if (this.symbols != null && this.symbols.hasChanged()) {
            try {
                this.saveSymbols();
            }
            catch (EXistException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.nodesCount = 0;
    }

    public void endRemove() {
        this.textEngine.remove();
        this.elementIndex.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentSet getAllDocuments(DocumentSet docs) {
        long start = System.currentTimeMillis();
        Collection root = null;
        try {
            root = this.openCollection(ROOT_COLLECTION, 0);
            root.allDocs(this, docs, true, false);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getAllDocuments(DocumentSet) - end - loading " + docs.getLength() + " documents from " + docs.getCollectionCount() + "collections took " + (System.currentTimeMillis() - start) + "ms."));
            }
            DocumentSet documentSet = docs;
            return documentSet;
        }
        finally {
            root.release();
        }
    }

    public Collection getCollection(String name) {
        return this.openCollection(name, -1L, -1);
    }

    public Collection getCollection(String name, long addr) {
        return this.openCollection(name, addr, -1);
    }

    public Collection openCollection(String name, int lockMode) {
        return this.openCollection(name, -1L, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection openCollection(String name, long addr, int lockMode) {
        CollectionCache collectionsCache;
        if ((name = NativeBroker.normalizeCollectionName(name)).length() > 0 && name.charAt(0) != '/') {
            name = "/" + name;
        }
        if (!name.startsWith(ROOT_COLLECTION)) {
            name = ROOT_COLLECTION + name;
        }
        if (name.endsWith("/") && name.length() > 1) {
            name = name.substring(0, name.length() - 1);
        }
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            Collection collection = collectionsCache.get(name);
            if (collection == null) {
                VariableByteInput is = null;
                Lock lock = this.collectionsDb.getLock();
                try {
                    block22: {
                        lock.acquire(0);
                        collection = new Collection(this.collectionsDb, name);
                        Value key = null;
                        if (addr == -1L) {
                            try {
                                key = new Value(name.getBytes("UTF-8"));
                            }
                            catch (UnsupportedEncodingException uee) {
                                key = new Value(name.getBytes());
                            }
                        }
                        is = addr < 0L ? this.collectionsDb.getAsStream(key) : this.collectionsDb.getAsStream(addr);
                        if (is != null) break block22;
                        Collection uee = null;
                        return uee;
                    }
                    try {
                        collection.read(this, is);
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)ioe.getMessage(), (Throwable)ioe);
                    }
                }
                catch (LockException e) {
                    LOG.warn((Object)"failed to acquire lock on collections.dbx");
                    Collection collection2 = null;
                    return collection2;
                }
                finally {
                    lock.release();
                }
            }
            if (lockMode != -1) {
                try {
                    collection.getLock().acquire(lockMode);
                }
                catch (LockException e1) {
                    LOG.warn((Object)("Could not acquire lock on collection " + name));
                }
            }
            if (!this.pool.isInitializing()) {
                collectionsCache.add(collection);
            }
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadCollection(Collection collection) {
        Value key = null;
        if (collection.getAddress() == -1L) {
            try {
                key = new Value(collection.getName().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                key = new Value(collection.getName().getBytes());
            }
        }
        VariableByteInput is = null;
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(0);
            try {
                is = collection.getAddress() == -1L ? this.collectionsDb.getAsStream(key) : this.collectionsDb.getAsStream(collection.getAddress());
            }
            catch (IOException ioe) {
                LOG.warn((Object)ioe.getMessage(), (Throwable)ioe);
            }
            if (is == null) {
                LOG.warn((Object)("Collection data not found for collection " + collection.getName()));
                return;
            }
            try {
                collection.read(this, is);
            }
            catch (IOException ioe) {
                LOG.warn((Object)ioe);
            }
        }
        catch (LockException e) {
            LOG.warn((Object)"failed to acquire lock on collections.dbx");
        }
        finally {
            lock.release();
        }
    }

    public Iterator getDOMIterator(NodeProxy proxy) {
        try {
            return new DOMFileIterator((Object)this, this.domDb, proxy);
        }
        catch (BTreeException e) {
            LOG.debug((Object)"failed to create DOM iterator", (Throwable)e);
        }
        catch (IOException e) {
            LOG.debug((Object)"failed to create DOM iterator", (Throwable)e);
        }
        return null;
    }

    public Iterator getNodeIterator(NodeProxy proxy) {
        try {
            return new NodeIterator((Object)this, this.domDb, proxy, false);
        }
        catch (BTreeException e) {
            LOG.debug((Object)"failed to create node iterator", (Throwable)e);
        }
        catch (IOException e) {
            LOG.debug((Object)"failed to create node iterator", (Throwable)e);
        }
        return null;
    }

    public Document getDocument(String fileName) throws PermissionDeniedException {
        if (!fileName.startsWith("/")) {
            fileName = '/' + fileName;
        }
        if (!fileName.startsWith(ROOT_COLLECTION)) {
            fileName = ROOT_COLLECTION + fileName;
        }
        int pos = fileName.lastIndexOf(47);
        String collName = fileName.substring(0, pos);
        String docName = fileName.substring(pos + 1);
        Collection collection = this.getCollection(collName);
        if (collection == null) {
            LOG.debug((Object)("collection " + collName + " not found!"));
            return null;
        }
        if (!collection.getPermissions().validate(this.user, 4)) {
            throw new PermissionDeniedException("permission denied to read collection");
        }
        DocumentImpl doc = collection.getDocument(this, docName);
        if (doc == null) {
            LOG.debug((Object)("document " + fileName + " not found!"));
            return null;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentImpl openDocument(String docPath, int lockMode) throws PermissionDeniedException {
        if (!docPath.startsWith("/")) {
            docPath = '/' + docPath;
        }
        if (!docPath.startsWith(ROOT_COLLECTION)) {
            docPath = ROOT_COLLECTION + docPath;
        }
        int pos = docPath.lastIndexOf(47);
        String collName = docPath.substring(0, pos);
        String docName = docPath.substring(pos + 1);
        Collection collection = null;
        try {
            collection = this.openCollection(collName, lockMode);
            if (collection == null) {
                LOG.debug((Object)("collection " + collName + " not found!"));
                DocumentImpl documentImpl = null;
                return documentImpl;
            }
            if (!collection.getPermissions().validate(this.user, 4)) {
                throw new PermissionDeniedException("permission denied to read collection");
            }
            DocumentImpl doc = collection.getDocumentWithLock(this, docName, lockMode);
            if (doc == null) {
                DocumentImpl documentImpl = null;
                return documentImpl;
            }
            DocumentImpl documentImpl = doc;
            return documentImpl;
        }
        catch (LockException e) {
            LOG.warn((Object)("Could not acquire lock on document " + docPath), (Throwable)e);
        }
        finally {
            collection.release();
        }
        return null;
    }

    public DocumentSet getDocumentsByCollection(String collection, DocumentSet docs) throws PermissionDeniedException {
        return this.getDocumentsByCollection(collection, docs, true);
    }

    public DocumentSet getDocumentsByCollection(String collection, DocumentSet docs, boolean inclusive) throws PermissionDeniedException {
        Collection root;
        long start = System.currentTimeMillis();
        if (collection == null || collection.length() == 0) {
            return docs;
        }
        if (collection.charAt(0) != '/') {
            collection = "/" + collection;
        }
        if (!collection.startsWith(ROOT_COLLECTION)) {
            collection = ROOT_COLLECTION + collection;
        }
        if ((root = this.getCollection(collection)) == null) {
            LOG.debug((Object)("collection " + collection + " not found"));
            return docs;
        }
        docs = root.allDocs(this, docs, inclusive, false);
        LOG.debug((Object)("loading " + docs.getLength() + " documents from collection " + collection + " took " + (System.currentTimeMillis() - start) + "ms."));
        return docs;
    }

    public DocumentSet getDocumentsByDoctype(String doctypeName, DocumentSet result) {
        DocumentSet docs = this.getAllDocuments(new DocumentSet());
        Iterator i = docs.iterator();
        while (i.hasNext()) {
            DocumentImpl doc = (DocumentImpl)i.next();
            DocumentType doctype = doc.getDoctype();
            if (doctype == null || !doctypeName.equals(doctype.getName()) || !doc.getCollection().getPermissions().validate(this.user, 4) || !doc.getPermissions().validate(this.user, 4)) continue;
            result.add(doc);
        }
        return result;
    }

    protected void freeCollection(short id) throws PermissionDeniedException {
        Value key = new Value("__free_collection_id");
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            Value value = this.collectionsDb.get(key);
            if (value != null) {
                byte[] data = value.getData();
                byte[] ndata = new byte[data.length + 2];
                System.arraycopy(data, 0, ndata, 2, data.length);
                ByteConversion.shortToByte(id, ndata, 0);
                this.collectionsDb.put(key, ndata, true);
            } else {
                byte[] data = new byte[2];
                ByteConversion.shortToByte(id, data, 0);
                this.collectionsDb.put(key, data, true);
            }
        }
        catch (LockException e) {
            LOG.warn((Object)"failed to acquire lock on collections store", (Throwable)e);
        }
        catch (ReadOnlyException e) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getFreeCollectionId() throws ReadOnlyException {
        short freeCollectionId = -1;
        Value key = new Value("__free_collection_id");
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            Value value = this.collectionsDb.get(key);
            if (value != null) {
                byte[] data = value.getData();
                freeCollectionId = ByteConversion.byteToShort(data, data.length - 2);
                if (data.length - 2 > 0) {
                    byte[] ndata = new byte[data.length - 2];
                    System.arraycopy(data, 0, ndata, 0, ndata.length);
                    this.collectionsDb.put(key, ndata, true);
                } else {
                    this.collectionsDb.remove(key);
                }
            }
        }
        catch (LockException e) {
            LOG.warn((Object)"failed to acquire lock on collections store", (Throwable)e);
            short s = -1;
            return s;
        }
        finally {
            lock.release();
        }
        return freeCollectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getNextCollectionId() throws ReadOnlyException {
        short nextCollectionId = this.getFreeCollectionId();
        if (nextCollectionId > -1) {
            return nextCollectionId;
        }
        Value key = new Value("__next_collection_id");
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            Value data = this.collectionsDb.get(key);
            if (data != null) {
                nextCollectionId = ByteConversion.byteToShort(data.getData(), 0);
                nextCollectionId = (short)(nextCollectionId + 1);
            }
            byte[] d = new byte[2];
            ByteConversion.shortToByte(nextCollectionId, d, 0);
            this.collectionsDb.put(key, d, true);
        }
        catch (LockException e) {
            LOG.warn((Object)"failed to acquire lock on collections store", (Throwable)e);
            short s = -1;
            return s;
        }
        finally {
            lock.release();
        }
        return nextCollectionId;
    }

    protected void freeDocument(int id) throws PermissionDeniedException {
        Value key = new Value("__free_doc_id");
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            Value value = this.collectionsDb.get(key);
            if (value != null) {
                byte[] data = value.getData();
                byte[] ndata = new byte[data.length + 4];
                System.arraycopy(data, 0, ndata, 4, data.length);
                ByteConversion.intToByte(id, ndata, 0);
                this.collectionsDb.put(key, ndata, true);
            } else {
                byte[] data = new byte[4];
                ByteConversion.intToByte(id, data, 0);
                this.collectionsDb.put(key, data, true);
            }
        }
        catch (LockException e) {
            LOG.warn((Object)"failed to acquire lock on collections store", (Throwable)e);
        }
        catch (ReadOnlyException e) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getFreeDocId() throws ReadOnlyException {
        int freeDocId = -1;
        Value key = new Value("__free_doc_id");
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            Value value = this.collectionsDb.get(key);
            if (value != null) {
                byte[] data = value.getData();
                freeDocId = ByteConversion.byteToInt(data, data.length - 4);
                if (data.length - 4 > 0) {
                    byte[] ndata = new byte[data.length - 4];
                    System.arraycopy(data, 0, ndata, 0, ndata.length);
                    this.collectionsDb.put(key, ndata, true);
                } else {
                    this.collectionsDb.remove(key);
                }
            }
        }
        catch (LockException e) {
            LOG.warn((Object)"failed to acquire lock on collections store", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            lock.release();
        }
        return freeDocId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextDocId(Collection collection) {
        int nextDocId;
        try {
            nextDocId = this.getFreeDocId();
        }
        catch (ReadOnlyException e1) {
            return 1;
        }
        if (nextDocId > -1) {
            return nextDocId;
        }
        nextDocId = 1;
        Value key = new Value("__next_doc_id");
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            Value data = this.collectionsDb.get(key);
            if (data != null) {
                nextDocId = ByteConversion.byteToInt(data.getData(), 0);
                ++nextDocId;
            }
            byte[] d = new byte[4];
            ByteConversion.intToByte(nextDocId, d, 0);
            try {
                this.collectionsDb.put(key, d, true);
            }
            catch (ReadOnlyException e) {
                LOG.debug((Object)"database read-only");
                int n = -1;
                lock.release();
                return n;
            }
        }
        catch (LockException e) {
            LOG.warn((Object)"failed to acquire lock on collections store", (Throwable)e);
        }
        finally {
            lock.release();
        }
        return nextDocId;
    }

    public void index(final NodeImpl node, NodePath currentPath) {
        int percent;
        if (++this.nodesCount > 10000 && (percent = (int)(this.run.freeMemory() / (this.run.totalMemory() / 100L))) < this.memMinFree) {
            this.flush();
            System.gc();
            LOG.info((Object)("total memory: " + this.run.totalMemory() + "; free: " + this.run.freeMemory()));
        }
        final DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
        final long gid = node.getGID();
        short nodeType = node.getNodeType();
        String nodeName = node.getNodeName();
        long address = node.getInternalAddress();
        IndexPaths idx = (IndexPaths)this.idxPathMap.get(node.getOwnerDocument().getDoctype().getName());
        if (address < 0L) {
            LOG.debug((Object)("node " + gid + ": internal address missing"));
        }
        int depth = idx == null ? this.defaultIndexDepth : idx.getIndexDepth();
        int level = doc.getTreeLevel(gid);
        switch (nodeType) {
            case 1: {
                QName qname = node.getQName();
                qname.setNameType((byte)0);
                NodeProxy tempProxy = new NodeProxy(doc, gid, address);
                tempProxy.setHasIndex(idx == null || currentPath == null || idx.match(currentPath));
                this.elementIndex.setDocument(doc);
                this.elementIndex.addRow(qname, tempProxy);
                break;
            }
            case 2: {
                this.elementIndex.setDocument(doc);
                QName qname = new QName(node.getLocalName(), node.getNamespaceURI(), node.getPrefix());
                qname.setNameType((byte)1);
                NodeProxy tempProxy = new NodeProxy(doc, gid, address);
                tempProxy.setHasIndex(idx == null || currentPath == null || idx.match(currentPath));
                this.elementIndex.addRow(qname, tempProxy);
                boolean indexAttribs = true;
                if (idx != null) {
                    if (idx.getIncludeAttributes()) {
                        if (currentPath != null) {
                            currentPath.addComponent('@' + nodeName);
                            indexAttribs = idx.match(currentPath);
                            currentPath.removeLastComponent();
                        }
                    } else {
                        indexAttribs = false;
                    }
                }
                if (indexAttribs) {
                    this.textEngine.storeAttribute(idx, (AttrImpl)node);
                }
                if (((AttrImpl)node).getType() != 1) break;
                qname = new QName(((AttrImpl)node).getValue(), "", null);
                qname.setNameType((byte)2);
                this.elementIndex.addRow(qname, tempProxy);
                break;
            }
            case 3: {
                boolean indexText = true;
                if (idx != null && currentPath != null) {
                    indexText = idx.match(currentPath);
                }
                boolean valore = idx == null || currentPath == null ? false : idx.preserveContent(currentPath);
                this.textEngine.storeText(idx, (TextImpl)node, valore);
            }
        }
        if (nodeType == 1 && level <= depth) {
            new DOMTransaction(this, this.domDb, 1){

                public Object start() throws ReadOnlyException {
                    try {
                        NativeBroker.this.domDb.addValue(new NodeRef(doc.getDocId(), gid), node.getInternalAddress());
                    }
                    catch (BTreeException e) {
                        LOG.warn((Object)NativeBroker.EXCEPTION_DURING_REINDEX, (Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)NativeBroker.EXCEPTION_DURING_REINDEX, (Throwable)e);
                    }
                    return null;
                }
            }.run();
        }
    }

    public void reindex(final DocumentImpl oldDoc, final DocumentImpl doc, final NodeImpl node) {
        int idxLevel = doc.reindexRequired();
        if (idxLevel < 0) {
            this.flush();
            return;
        }
        oldDoc.setReindexRequired(idxLevel);
        if (node == null) {
            LOG.debug((Object)("reindexing level " + idxLevel + " of document " + doc.getDocId()));
        }
        long start = System.currentTimeMillis();
        new DOMTransaction(this, this.domDb, 1){

            public Object start() throws ReadOnlyException {
                try {
                    Value ref = new NodeRef(doc.getDocId());
                    IndexQuery query = new IndexQuery(7, ref);
                    ArrayList nodes = NativeBroker.this.domDb.findKeys(query);
                    Iterator i = nodes.iterator();
                    while (i.hasNext()) {
                        ref = (Value)i.next();
                        long gid = ByteConversion.byteToLong(ref.data(), ref.start() + 4);
                        if (oldDoc.getTreeLevel(gid) < doc.reindexRequired()) continue;
                        if (node != null) {
                            if (!XMLUtil.isDescendant(oldDoc, node.getGID(), gid)) continue;
                            NativeBroker.this.domDb.removeValue(ref);
                            continue;
                        }
                        NativeBroker.this.domDb.removeValue(ref);
                    }
                }
                catch (BTreeException e) {
                    LOG.debug((Object)("Exception while reindexing document: " + e.getMessage()), (Throwable)e);
                }
                catch (IOException e) {
                    LOG.debug((Object)("Exception while reindexing document: " + e.getMessage()), (Throwable)e);
                }
                return null;
            }
        }.run();
        try {
            if (node == null) {
                NodeList nodes = doc.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    NodeImpl n = (NodeImpl)nodes.item(i);
                    Iterator iterator = this.getNodeIterator(new NodeProxy(doc, n.getGID(), n.getInternalAddress()));
                    iterator.next();
                    this.scanNodes(iterator, n, new NodePath(), false);
                }
            } else {
                Iterator iterator = this.getNodeIterator(new NodeProxy(doc, node.getGID(), node.getInternalAddress()));
                iterator.next();
                this.scanNodes(iterator, node, node.getPath(), false);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error occured while reindexing document: " + e.getMessage()), (Throwable)e);
        }
        this.elementIndex.reindex(oldDoc, node);
        this.textEngine.reindex(oldDoc, node);
        doc.setReindexRequired(-1);
        LOG.debug((Object)("reindex took " + (System.currentTimeMillis() - start) + "ms."));
    }

    private void reindex(final NodeImpl node, NodePath currentPath) {
        if (node.getGID() < 0L) {
            LOG.debug((Object)("illegal node: " + node.getGID() + "; " + node.getNodeName()));
        }
        IndexPaths idx = (IndexPaths)this.idxPathMap.get(node.getOwnerDocument().getDoctype().getName());
        short nodeType = node.getNodeType();
        final long gid = node.getGID();
        final DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
        int depth = idx == null ? this.defaultIndexDepth : idx.getIndexDepth();
        int level = doc.getTreeLevel(gid);
        if (level >= doc.reindexRequired()) {
            NodeIndexListener listener = doc.getIndexListener();
            if (listener != null) {
                listener.nodeChanged(node);
            }
            if (nodeType == 1 && level <= depth) {
                new DOMTransaction(this, this.domDb, 1){

                    public Object start() throws ReadOnlyException {
                        try {
                            NativeBroker.this.domDb.addValue(new NodeRef(doc.getDocId(), gid), node.getInternalAddress());
                        }
                        catch (BTreeException e) {
                            LOG.warn((Object)NativeBroker.EXCEPTION_DURING_REINDEX, (Throwable)e);
                        }
                        catch (IOException e) {
                            LOG.warn((Object)NativeBroker.EXCEPTION_DURING_REINDEX, (Throwable)e);
                        }
                        return null;
                    }
                }.run();
            }
            NodeProxy tempProxy = new NodeProxy(doc, gid, node.getInternalAddress());
            switch (nodeType) {
                case 1: {
                    QName qname = node.getQName();
                    qname.setNameType((byte)0);
                    tempProxy.setHasIndex(idx == null || idx.match(currentPath));
                    this.elementIndex.setDocument(doc);
                    this.elementIndex.addRow(qname, tempProxy);
                    break;
                }
                case 2: {
                    tempProxy.setHasIndex(idx == null || idx.match(currentPath));
                    this.elementIndex.setDocument(doc);
                    QName qname = new QName(node.getLocalName(), node.getNamespaceURI(), node.getPrefix());
                    qname.setNameType((byte)1);
                    this.elementIndex.addRow(qname, tempProxy);
                    boolean indexAttribs = true;
                    if (idx != null) {
                        if (idx.getIncludeAttributes()) {
                            currentPath.addComponent('@' + ((AttrImpl)node).getName());
                            indexAttribs = idx.match(currentPath);
                            currentPath.removeLastComponent();
                        } else {
                            indexAttribs = false;
                        }
                    }
                    if (indexAttribs) {
                        this.textEngine.storeAttribute(idx, (AttrImpl)node);
                    }
                    if (((AttrImpl)node).getType() != 1) break;
                    qname = new QName("&" + ((AttrImpl)node).getValue(), "", null);
                    qname.setNameType((byte)2);
                    this.elementIndex.addRow(qname, tempProxy);
                    break;
                }
                case 3: {
                    if (idx != null && !idx.match(currentPath)) break;
                    boolean valore = idx == null ? false : idx.preserveContent(currentPath);
                    this.textEngine.storeText(idx, (TextImpl)node, valore);
                }
            }
        }
    }

    private void scanNodes(Iterator iterator, NodeImpl node, NodePath currentPath, boolean fullReindex) {
        if (node.getNodeType() == 1) {
            currentPath.addComponent(node.getNodeName());
        }
        if (fullReindex) {
            this.index(node, currentPath);
        } else {
            this.reindex(node, currentPath);
        }
        if (node.hasChildNodes()) {
            DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
            long firstChildId = XMLUtil.getFirstChildId(doc, node.getGID());
            if (firstChildId < 0L) {
                LOG.fatal((Object)("no child found: expected = " + node.getChildCount() + "; node = " + node.getNodeName() + "; gid = " + node.getGID()));
                throw new IllegalStateException("wrong node id");
            }
            long lastChildId = firstChildId + (long)node.getChildCount();
            for (long gid = firstChildId; gid < lastChildId; ++gid) {
                NodeImpl child = (NodeImpl)iterator.next();
                if (child == null) {
                    LOG.debug((Object)("child " + gid + " not found for node: " + node.getNodeName() + "; last = " + lastChildId + "; children = " + node.getChildCount()));
                }
                child.setGID(gid);
                this.scanNodes(iterator, child, currentPath, fullReindex);
            }
        }
        if (node.getNodeType() == 1) {
            currentPath.removeLastComponent();
        }
    }

    private void reindex(DocumentImpl doc) {
        LOG.debug((Object)("Reindexing document " + doc.getFileName()));
        long start = System.currentTimeMillis();
        NodeList nodes = doc.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            NodeImpl n = (NodeImpl)nodes.item(i);
            Iterator iterator = this.getNodeIterator(new NodeProxy(doc, n.getGID(), n.getInternalAddress()));
            iterator.next();
            this.scanNodes(iterator, n, new NodePath(), true);
        }
        this.flush();
        LOG.debug((Object)("reindex took " + (System.currentTimeMillis() - start) + "ms."));
    }

    public void copyResource(DocumentImpl doc, Collection destination, String newName) throws PermissionDeniedException, LockException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        Collection collection = doc.getCollection();
        if (!collection.getPermissions().validate(this.user, 4)) {
            throw new PermissionDeniedException("Insufficient privileges to copy resource " + doc.getFileName());
        }
        if (!doc.getPermissions().validate(this.user, 4)) {
            throw new PermissionDeniedException("Insufficient privileges to copy resource " + doc.getFileName());
        }
        if (newName == null) {
            int p = doc.getFileName().lastIndexOf(47);
            newName = doc.getFileName().substring(p + 1);
        }
        Lock lock = null;
        try {
            lock = this.collectionsDb.getLock();
            lock.acquire(1);
            if (this.getCollection(destination.getName() + '/' + newName) != null) {
                throw new PermissionDeniedException("A resource can not replace an existing collection");
            }
            DocumentImpl oldDoc = destination.getDocument(this, newName);
            if (oldDoc != null) {
                if (doc.getDocId() == oldDoc.getDocId()) {
                    throw new PermissionDeniedException("Cannot copy resource to itself");
                }
                if (!destination.getPermissions().validate(this.user, 1)) {
                    throw new PermissionDeniedException("Resource with same name exists in target collection and update is denied");
                }
                if (!oldDoc.getPermissions().validate(this.user, 1)) {
                    throw new PermissionDeniedException("Resource with same name exists in target collection and update is denied");
                }
                collection.removeDocument(this, oldDoc.getFileName());
            } else if (!destination.getPermissions().validate(this.user, 2)) {
                throw new PermissionDeniedException("Insufficient privileges on target collection " + destination.getName());
            }
            DocumentImpl newDoc = new DocumentImpl(this, newName, destination);
            newDoc.copyOf(doc);
            newDoc.setDocId(this.getNextDocId(destination));
            this.copyResource(doc, newDoc);
            destination.addDocument(this, newDoc);
            this.updateDocument(newDoc);
        }
        catch (TriggerException e) {
            throw new PermissionDeniedException(e.getMessage());
        }
        finally {
            lock.release();
        }
    }

    private void copyResource(DocumentImpl oldDoc, DocumentImpl newDoc) {
        LOG.debug((Object)("Copying document " + oldDoc.getFileName() + " to " + newDoc.getName()));
        long start = System.currentTimeMillis();
        NodeList nodes = oldDoc.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            NodeImpl n = (NodeImpl)nodes.item(i);
            Iterator iterator = this.getNodeIterator(new NodeProxy(oldDoc, n.getGID(), n.getInternalAddress()));
            iterator.next();
            this.copyNodes(iterator, n, new NodePath(), newDoc, true);
        }
        this.flush();
        this.closeDocument();
        LOG.debug((Object)("Copy took " + (System.currentTimeMillis() - start) + "ms."));
    }

    public void defrag(DocumentImpl doc) {
        LOG.debug((Object)("============> Defragmenting document " + doc.getCollection().getName() + '/' + doc.getFileName()));
        long start = System.currentTimeMillis();
        try {
            final long firstChild = doc.getFirstChildAddress();
            this.elementIndex.dropIndex(doc);
            NodeRef ref = new NodeRef(doc.getDocId());
            final IndexQuery idx = new IndexQuery(7, (Value)ref);
            new DOMTransaction(this, this.domDb){

                public Object start() {
                    try {
                        NativeBroker.this.domDb.remove(idx, null);
                        NativeBroker.this.domDb.flush();
                    }
                    catch (BTreeException e) {
                        LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    catch (TerminatedException e) {
                        LOG.warn((Object)"method terminated", (Throwable)e);
                    }
                    catch (DBException e) {
                        LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    return null;
                }
            }.run();
            DocumentImpl tempDoc = new DocumentImpl(this, doc.getFileName(), doc.getCollection());
            tempDoc.copyOf(doc);
            tempDoc.setDocId(doc.getDocId());
            NodeList nodes = doc.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                NodeImpl n = (NodeImpl)nodes.item(i);
                Iterator iterator = this.getNodeIterator(new NodeProxy(doc, n.getGID(), n.getInternalAddress()));
                iterator.next();
                this.copyNodes(iterator, n, new NodePath(), tempDoc, false);
            }
            this.flush();
            new DOMTransaction(this, this.domDb){

                public Object start() {
                    NativeBroker.this.domDb.removeAll(firstChild);
                    try {
                        NativeBroker.this.domDb.flush();
                    }
                    catch (DBException e) {
                        LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    return null;
                }
            }.run();
            doc.copyChildren(tempDoc);
            doc.setSplitCount(0);
            doc.setAddress(-1L);
            doc.setPageCount(tempDoc.getPageCount());
            this.storeDocument(doc);
            LOG.debug((Object)("new doc address = " + StorageAddress.toString(doc.getAddress())));
            this.closeDocument();
            this.saveCollection(doc.getCollection());
            LOG.debug((Object)("Defragmentation took " + (System.currentTimeMillis() - start) + "ms."));
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)DATABASE_IS_READ_ONLY, (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            LOG.warn((Object)DATABASE_IS_READ_ONLY, (Throwable)e);
        }
    }

    private void copyNodes(Iterator iterator, NodeImpl node, NodePath currentPath, DocumentImpl newDoc, boolean index) {
        if (node.getNodeType() == 1) {
            currentPath.addComponent(node.getNodeName());
        }
        DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
        node.setOwnerDocument(newDoc);
        node.setInternalAddress(-1L);
        this.store(node, currentPath, index);
        if (node.getGID() == 1L) {
            newDoc.appendChild(node);
        }
        node.setOwnerDocument(doc);
        if (node.hasChildNodes()) {
            long firstChildId = XMLUtil.getFirstChildId(doc, node.getGID());
            if (firstChildId < 0L) {
                LOG.fatal((Object)("no child found: expected = " + node.getChildCount() + "; node = " + node.getNodeName() + "; gid = " + node.getGID()));
                throw new IllegalStateException("wrong node id");
            }
            long lastChildId = firstChildId + (long)node.getChildCount();
            for (long gid = firstChildId; gid < lastChildId; ++gid) {
                NodeImpl child = (NodeImpl)iterator.next();
                if (child == null) {
                    LOG.debug((Object)("child " + gid + " not found for node: " + node.getNodeName() + "; last = " + lastChildId + "; children = " + node.getChildCount()));
                }
                child.setGID(gid);
                this.copyNodes(iterator, child, currentPath, newDoc, index);
            }
        }
        if (node.getNodeType() == 1) {
            currentPath.removeLastComponent();
        }
    }

    public void consistencyCheck(DocumentImpl doc) throws EXistException {
        if (this.xupdateConsistencyChecks) {
            LOG.debug((Object)("Checking document " + doc.getFileName()));
            this.checkTree(doc);
        }
    }

    public void checkTree(final DocumentImpl doc) {
        LOG.debug((Object)("Checking DOM tree for document " + doc.getFileName()));
        if (this.xupdateConsistencyChecks) {
            new DOMTransaction(this, this.domDb, 0){

                public Object start() throws ReadOnlyException {
                    LOG.debug((Object)("Pages used: " + NativeBroker.this.domDb.debugPages(doc)));
                    return null;
                }
            }.run();
            NodeList nodes = doc.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                NodeImpl n = (NodeImpl)nodes.item(i);
                Iterator iterator = this.getNodeIterator(new NodeProxy(doc, n.getGID(), n.getInternalAddress()));
                iterator.next();
                this.checkTree(iterator, n);
            }
            NodeRef ref = new NodeRef(doc.getDocId());
            final IndexQuery idx = new IndexQuery(7, (Value)ref);
            new DOMTransaction(this, this.domDb){

                public Object start() {
                    try {
                        NativeBroker.this.domDb.findKeys(idx);
                    }
                    catch (BTreeException e) {
                        LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    return null;
                }
            }.run();
        }
    }

    private void checkTree(Iterator iterator, NodeImpl node) {
        if (node.hasChildNodes()) {
            long firstChildId = XMLUtil.getFirstChildId((DocumentImpl)node.getOwnerDocument(), node.getGID());
            if (firstChildId < 0L) {
                LOG.fatal((Object)("no child found: expected = " + node.getChildCount() + "; node = " + node.getNodeName() + "; gid = " + node.getGID()));
                throw new IllegalStateException("wrong node id");
            }
            long lastChildId = firstChildId + (long)node.getChildCount();
            for (long gid = firstChildId; gid < lastChildId; ++gid) {
                NodeImpl child = (NodeImpl)iterator.next();
                if (child == null) {
                    LOG.debug((Object)("child " + gid + " not found for node: " + node.getNodeName() + "; last = " + lastChildId + "; children = " + node.getChildCount()));
                }
                child.setGID(gid);
                this.checkTree(iterator, child);
            }
        }
    }

    public String getNodeValue(final NodeProxy proxy) {
        return (String)new DOMTransaction(this, this.domDb, 0){

            public Object start() {
                return NativeBroker.this.domDb.getNodeValue(proxy);
            }
        }.run();
    }

    public NodeSet getNodesEqualTo(NodeSet context, DocumentSet docs, int relation, String expr, Collator collator) {
        int truncation = -1;
        if (expr.length() > 0 && expr.charAt(0) == '%') {
            expr = expr.substring(1);
            truncation = 1;
        }
        if (expr.length() > 1 && expr.charAt(expr.length() - 1) == '%') {
            expr = expr.substring(0, expr.length() - 1);
            int n = truncation = truncation == 1 ? 2 : 0;
        }
        if (!this.isCaseSensitive()) {
            expr = expr.toLowerCase();
        }
        NodeSet result = this.scanSequential(context, docs, relation, truncation, expr, collator);
        return result;
    }

    public Collection getOrCreateCollection(String name) throws PermissionDeniedException {
        CollectionCache collectionsCache;
        if ((name = NativeBroker.normalizeCollectionName(name)).length() > 0 && name.charAt(0) != '/') {
            name = "/" + name;
        }
        if (!name.startsWith(ROOT_COLLECTION)) {
            name = ROOT_COLLECTION + name;
        }
        if (name.endsWith("/") && name.length() > 1) {
            name = name.substring(0, name.length() - 1);
        }
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            try {
                StringTokenizer tok = new StringTokenizer(name, "/");
                String temp = tok.nextToken();
                String path = ROOT_COLLECTION;
                Collection current = this.getCollection(ROOT_COLLECTION);
                if (current == null) {
                    LOG.debug((Object)"creating root collection /db");
                    current = new Collection(this.collectionsDb, ROOT_COLLECTION);
                    current.getPermissions().setPermissions(511);
                    current.getPermissions().setOwner(this.user);
                    current.getPermissions().setGroup(this.user.getPrimaryGroup());
                    current.setId(this.getNextCollectionId());
                    current.setCreationTime(System.currentTimeMillis());
                    this.saveCollection(current);
                }
                while (tok.hasMoreTokens()) {
                    temp = tok.nextToken();
                    path = path + "/" + temp;
                    if (current.hasSubcollection(temp)) {
                        current = this.getCollection(path);
                        continue;
                    }
                    if (!current.getPermissions().validate(this.user, 2)) {
                        LOG.debug((Object)("permission denied to create collection " + path));
                        throw new PermissionDeniedException("not allowed to write to collection");
                    }
                    LOG.debug((Object)("creating collection " + path));
                    Collection sub = new Collection(this.collectionsDb, path);
                    sub.getPermissions().setOwner(this.user);
                    sub.getPermissions().setGroup(this.user.getPrimaryGroup());
                    sub.setId(this.getNextCollectionId());
                    sub.setCreationTime(System.currentTimeMillis());
                    current.addCollection(sub);
                    this.saveCollection(current);
                    current = sub;
                }
                return current;
            }
            catch (ReadOnlyException e) {
                throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
            }
        }
    }

    public NodeList getRange(Document doc, long first, long last) {
        NodeListImpl result = new NodeListImpl((int)(last - first + 1L));
        for (long gid = first; gid <= last; ++gid) {
            result.add(this.objectWith(doc, gid));
        }
        return result;
    }

    public Serializer getSerializer() {
        this.xmlSerializer.reset();
        return this.xmlSerializer;
    }

    public TextSearchEngine getTextEngine() {
        return this.textEngine;
    }

    public Serializer newSerializer() {
        return new NativeSerializer(this, this.getConfiguration());
    }

    public Node objectWith(final Document doc, final long gid) {
        return (Node)new DOMTransaction(this, this.domDb){

            public Object start() {
                Value val = NativeBroker.this.domDb.get(new NodeProxy((DocumentImpl)doc, gid));
                if (val == null) {
                    return null;
                }
                NodeImpl node = NodeImpl.deserialize(val.getData(), 0, val.getLength(), (DocumentImpl)doc);
                node.setGID(gid);
                node.setOwnerDocument(doc);
                node.setInternalAddress(val.getAddress());
                return node;
            }
        }.run();
    }

    public Node objectWith(final NodeProxy p) {
        if (p.getInternalAddress() < 0L) {
            return this.objectWith(p.getDocument(), p.gid);
        }
        return (Node)new DOMTransaction(this, this.domDb){

            public Object start() {
                Value val = NativeBroker.this.domDb.get(p.getInternalAddress());
                if (val == null) {
                    LOG.debug((Object)("Node " + p.gid + " not found in document " + p.getDocument().getName() + "; docId = " + p.getDocument().getDocId()));
                    Thread.dumpStack();
                    return NativeBroker.this.objectWith(p.getDocument(), p.gid);
                }
                NodeImpl node = NodeImpl.deserialize(val.getData(), 0, val.getLength(), p.getDocument());
                node.setGID(p.gid);
                node.setOwnerDocument(p.getDocument());
                node.setInternalAddress(p.getInternalAddress());
                return node;
            }
        }.run();
    }

    public void dropIndex(Collection collection) throws PermissionDeniedException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        if (!collection.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("insufficient privileges on collection " + collection.getName());
        }
        this.textEngine.dropIndex(collection);
        this.elementIndex.dropIndex(collection);
        Iterator i = collection.iterator(this);
        while (i.hasNext()) {
            final DocumentImpl doc = (DocumentImpl)i.next();
            LOG.debug((Object)("Dropping index for document " + doc.getFileName()));
            new DOMTransaction(this, this.domDb, 1){

                public Object start() {
                    try {
                        NodeRef ref = new NodeRef(doc.getDocId());
                        IndexQuery query = new IndexQuery(7, (Value)ref);
                        NativeBroker.this.domDb.remove(query, null);
                        NativeBroker.this.domDb.flush();
                    }
                    catch (BTreeException e) {
                        LOG.warn((Object)"btree error while removing document", (Throwable)e);
                    }
                    catch (DBException e) {
                        LOG.warn((Object)"db error while removing document", (Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"io error while removing document", (Throwable)e);
                    }
                    catch (TerminatedException e) {
                        LOG.warn((Object)"method terminated", (Throwable)e);
                    }
                    return null;
                }
            }.run();
        }
    }

    public void reindex(Collection collection) throws PermissionDeniedException {
        Object next;
        if (!collection.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("insufficient privileges on collection " + collection.getName());
        }
        LOG.debug((Object)("Reindexing collection " + collection.getName()));
        this.dropIndex(collection);
        Iterator i = collection.iterator(this);
        while (i.hasNext()) {
            next = (DocumentImpl)i.next();
            this.reindex((DocumentImpl)next);
        }
        i = collection.collectionIterator();
        while (i.hasNext()) {
            next = (String)i.next();
            Collection child = this.getCollection(collection.getName() + '/' + (String)next);
            if (child == null) {
                LOG.warn((Object)("Collection " + (String)next + " not found"));
                continue;
            }
            this.reindex(child);
        }
    }

    public void reindex(String collectionName) throws PermissionDeniedException {
        Collection collection;
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        if (!collectionName.startsWith(ROOT_COLLECTION)) {
            collectionName = ROOT_COLLECTION + collectionName;
        }
        if ((collection = this.getCollection(collectionName)) == null) {
            LOG.debug((Object)("collection " + collectionName + " not found!"));
            return;
        }
        this.reindex(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCollection(Collection collection) throws PermissionDeniedException {
        CollectionCache collectionsCache;
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        if (!collection.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("not allowed to remove collection");
        }
        boolean isRoot = collection.getParentPath() == null;
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            block27: {
                Collection parent;
                String name = collection.getName();
                if (!isRoot && (parent = this.openCollection(collection.getParentPath(), 1)) != null) {
                    try {
                        parent.removeCollection(name.substring(name.lastIndexOf("/") + 1));
                        this.saveCollection(parent);
                    }
                    catch (LockException e) {
                        LOG.warn((Object)("LockException while removing collection " + name));
                    }
                    finally {
                        parent.getLock().release();
                    }
                }
                LOG.debug((Object)"removing sub-collections");
                Iterator i = collection.collectionIterator();
                while (i.hasNext()) {
                    String childName = (String)i.next();
                    Collection childCollection = this.openCollection(name + '/' + childName, 1);
                    try {
                        this.removeCollection(childCollection);
                    }
                    finally {
                        childCollection.getLock().release();
                    }
                }
                Lock lock = this.collectionsDb.getLock();
                try {
                    Value key;
                    lock.acquire(1);
                    if (isRoot) {
                        this.saveCollection(collection);
                        break block27;
                    }
                    try {
                        key = new Value(name.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException uee) {
                        key = new Value(name.getBytes());
                    }
                    this.collectionsDb.remove(key);
                    collectionsCache.remove(collection);
                    this.freeCollection(collection.getId());
                }
                catch (LockException e) {
                    LOG.warn((Object)"Failed to acquire lock on collections.dbx");
                }
                catch (ReadOnlyException e) {
                    throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
                }
                finally {
                    lock.release();
                }
            }
            this.textEngine.dropIndex(collection);
            this.elementIndex.dropIndex(collection);
            LOG.debug((Object)"removing resources ...");
            Iterator i = collection.iterator(this);
            while (i.hasNext()) {
                final DocumentImpl doc = (DocumentImpl)i.next();
                LOG.debug((Object)("removing document " + doc.getFileName()));
                new DOMTransaction(this, this.domDb, 1){

                    public Object start() {
                        if (doc.getResourceType() == 1) {
                            NativeBroker.this.domDb.remove(doc.getAddress());
                            NativeBroker.this.domDb.removeOverflowValue(((BinaryDocument)doc).getPage());
                        } else {
                            NodeImpl node = (NodeImpl)doc.getFirstChild();
                            NativeBroker.this.domDb.removeAll(node.getInternalAddress());
                        }
                        return null;
                    }
                }.run();
                new DOMTransaction(this, this.domDb, 1){

                    public Object start() {
                        try {
                            NodeRef ref = new NodeRef(doc.getDocId());
                            IndexQuery query = new IndexQuery(7, (Value)ref);
                            NativeBroker.this.domDb.remove(query, null);
                            NativeBroker.this.domDb.flush();
                        }
                        catch (BTreeException e) {
                            LOG.warn((Object)"btree error while removing document", (Throwable)e);
                        }
                        catch (DBException e) {
                            LOG.warn((Object)"db error while removing document", (Throwable)e);
                        }
                        catch (IOException e) {
                            LOG.warn((Object)"io error while removing document", (Throwable)e);
                        }
                        catch (TerminatedException e) {
                            LOG.warn((Object)"method terminated", (Throwable)e);
                        }
                        return null;
                    }
                }.run();
                this.freeDocument(doc.getDocId());
            }
            return true;
        }
    }

    public void removeDocument(final DocumentImpl document, boolean freeDocId) throws PermissionDeniedException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("removeDocument() - removing document " + document.getDocId() + " ..."));
            }
            this.elementIndex.dropIndex(document);
            this.textEngine.dropIndex(document);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"removeDocument() - removing dom");
            }
            new DOMTransaction(this, this.domDb){

                public Object start() {
                    NodeImpl node = (NodeImpl)document.getFirstChild();
                    NativeBroker.this.domDb.removeAll(node.getInternalAddress());
                    return null;
                }
            }.run();
            NodeRef ref = new NodeRef(document.getDocId());
            final IndexQuery idx = new IndexQuery(7, (Value)ref);
            new DOMTransaction(this, this.domDb){

                public Object start() {
                    try {
                        NativeBroker.this.domDb.remove(idx, null);
                        NativeBroker.this.domDb.flush();
                    }
                    catch (BTreeException e) {
                        LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    catch (DBException e) {
                        LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    catch (TerminatedException e) {
                        LOG.warn((Object)"method terminated", (Throwable)e);
                    }
                    return null;
                }
            }.run();
            if (freeDocId) {
                this.freeDocument(document.getDocId());
            }
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)"removeDocument(String) - database is read-only");
        }
    }

    public void removeNode(final NodeImpl node, NodePath currentPath) {
        IndexPaths idx = (IndexPaths)this.idxPathMap.get(node.getOwnerDocument().getDoctype().getName());
        final DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
        long gid = node.getGID();
        short nodeType = node.getNodeType();
        String nodeName = node.getNodeName();
        new DOMTransaction(this, this.domDb, 1, doc){

            public Object start() {
                long address = node.getInternalAddress();
                if (address > -1L) {
                    NativeBroker.this.domDb.remove(new NodeRef(doc.getDocId(), node.getGID()), address);
                } else {
                    NativeBroker.this.domDb.remove(new NodeRef(doc.getDocId(), node.getGID()));
                }
                return null;
            }
        }.run();
        NodeProxy tempProxy = new NodeProxy(doc, gid, node.getInternalAddress());
        switch (nodeType) {
            case 1: {
                QName qname = node.getQName();
                qname.setNameType((byte)0);
                this.elementIndex.setDocument(doc);
                this.elementIndex.addRow(qname, tempProxy);
                break;
            }
            case 2: {
                this.elementIndex.setDocument(doc);
                QName qname = new QName(node.getLocalName(), node.getNamespaceURI(), node.getPrefix());
                qname.setNameType((byte)1);
                this.elementIndex.addRow(qname, tempProxy);
                boolean indexAttribs = true;
                if (idx != null) {
                    if (idx.getIncludeAttributes()) {
                        currentPath.addComponent('@' + ((AttrImpl)node).getName());
                        indexAttribs = idx.match(currentPath);
                        currentPath.removeLastComponent();
                    } else {
                        indexAttribs = false;
                    }
                }
                if (indexAttribs) {
                    this.textEngine.storeAttribute(idx, (AttrImpl)node);
                }
                if (((AttrImpl)node).getType() != 1) break;
                qname = new QName(((AttrImpl)node).getValue(), "", null);
                qname.setNameType((byte)2);
                this.elementIndex.addRow(qname, tempProxy);
                break;
            }
            case 3: {
                if (idx != null && !idx.match(currentPath)) break;
                boolean valore = idx == null ? false : idx.preserveContent(currentPath);
                this.textEngine.storeText(idx, (TextImpl)node, valore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Collection collection, DocumentImpl doc) throws PermissionDeniedException {
        Lock lock = this.collectionsDb.getLock();
        try {
            Value name;
            lock.acquire();
            try {
                name = new Value(collection.getName().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                LOG.debug((Object)uee);
                name = new Value(collection.getName().getBytes());
            }
            this.storeDocument(doc);
            VariableByteOutputStream ostream = new VariableByteOutputStream(6);
            doc.write(ostream);
            long address = this.collectionsDb.append(name, ostream.data());
            if (address < 0L) {
                LOG.debug((Object)("could not store collection data for " + collection.getName()));
                return;
            }
            collection.setAddress(address);
            ostream.close();
        }
        catch (IOException ioe) {
            LOG.debug((Object)ioe);
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)DATABASE_IS_READ_ONLY);
        }
        catch (LockException e) {
            LOG.warn((Object)"failed to acquire lock on collections.dbx");
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCollection(Collection collection) throws PermissionDeniedException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        if (!this.pool.isInitializing()) {
            this.pool.getCollectionsCache().add(collection);
        }
        Lock lock = null;
        try {
            long addr;
            VariableByteOutputStream ostream;
            block16: {
                Value name;
                lock = this.collectionsDb.getLock();
                lock.acquire(1);
                if (collection.getId() < 0) {
                    collection.setId(this.getNextCollectionId());
                }
                try {
                    name = new Value(collection.getName().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    LOG.debug((Object)uee);
                    name = new Value(collection.getName().getBytes());
                }
                ostream = new VariableByteOutputStream(8);
                collection.write(this, ostream);
                addr = this.collectionsDb.put(name, ostream.data());
                if (addr >= 0L) break block16;
                LOG.debug((Object)("could not store collection data for " + collection.getName()));
                return;
            }
            try {
                collection.setAddress(addr);
                ostream.close();
            }
            catch (IOException ioe) {
                LOG.debug((Object)ioe);
            }
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)DATABASE_IS_READ_ONLY);
        }
        catch (LockException e) {
            LOG.warn((Object)"could not acquire lock for collections store", (Throwable)e);
        }
        finally {
            lock.release();
        }
    }

    public void moveResource(DocumentImpl doc, Collection destination, String newName) throws PermissionDeniedException, LockException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        Collection collection = doc.getCollection();
        if (!collection.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("Insufficient privileges to move resource " + doc.getFileName());
        }
        if (!doc.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("Insufficient privileges to move resource " + doc.getFileName());
        }
        if (newName == null) {
            int p = doc.getFileName().lastIndexOf(47);
            newName = doc.getFileName().substring(p + 1);
        }
        Lock lock = null;
        try {
            lock = this.collectionsDb.getLock();
            lock.acquire(1);
            if (this.getCollection(destination.getName() + '/' + newName) != null) {
                throw new PermissionDeniedException("A resource can not replace an existing collection");
            }
            DocumentImpl oldDoc = destination.getDocument(this, newName);
            if (oldDoc != null) {
                if (doc.getDocId() == oldDoc.getDocId()) {
                    throw new PermissionDeniedException("Cannot move resource to itself");
                }
                if (!destination.getPermissions().validate(this.user, 1)) {
                    throw new PermissionDeniedException("Resource with same name exists in target collection and update is denied");
                }
                if (!oldDoc.getPermissions().validate(this.user, 1)) {
                    throw new PermissionDeniedException("Resource with same name exists in target collection and update is denied");
                }
                collection.removeDocument(this, oldDoc.getFileName());
            } else if (!destination.getPermissions().validate(this.user, 2)) {
                throw new PermissionDeniedException("Insufficient privileges on target collection " + destination.getName());
            }
            boolean renameOnly = collection.getId() == destination.getId();
            collection.unlinkDocument(doc);
            if (!renameOnly) {
                this.elementIndex.dropIndex(doc);
                this.textEngine.dropIndex(doc);
                this.saveCollection(collection);
            }
            doc.setFileName(newName);
            destination.addDocument(this, doc);
            doc.setCollection(destination);
            if (!renameOnly) {
                this.reindex(doc);
            }
            this.saveCollection(destination);
        }
        catch (TriggerException e) {
            throw new PermissionDeniedException(e.getMessage());
        }
        catch (ReadOnlyException e) {
            throw new PermissionDeniedException(e.getMessage());
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyCollection(Collection collection, Collection destination, String newName) throws PermissionDeniedException, LockException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        if (!collection.getPermissions().validate(this.user, 4)) {
            throw new PermissionDeniedException("Read permission denied on collection " + collection.getName());
        }
        if (collection.getId() == destination.getId()) {
            throw new PermissionDeniedException("Cannot move collection to itself");
        }
        if (!destination.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("Insufficient privileges on target collection " + destination.getName());
        }
        if (newName == null) {
            int p = collection.getName().lastIndexOf(47);
            newName = collection.getName().substring(p + 1);
        }
        if (newName.indexOf(47) > -1) {
            throw new PermissionDeniedException("New collection name is illegal (may not contain a '/')");
        }
        Collection old = this.openCollection(destination.getName() + '/' + newName, 1);
        if (old != null) {
            LOG.debug((Object)("removing old collection: " + newName));
            try {
                this.removeCollection(old);
            }
            finally {
                old.release();
            }
        }
        Collection destCollection = null;
        Lock lock = null;
        try {
            lock = this.collectionsDb.getLock();
            lock.acquire(1);
            newName = destination.getName() + '/' + newName;
            LOG.debug((Object)("Copying collection to " + newName));
            destCollection = this.getOrCreateCollection(newName);
            Iterator i = collection.iterator(this);
            while (i.hasNext()) {
                DocumentImpl child = (DocumentImpl)i.next();
                LOG.debug((Object)("Copying resource: " + child.getName()));
                DocumentImpl newDoc = new DocumentImpl(this, child.getFileName(), destCollection);
                newDoc.copyOf(child);
                this.copyResource(child, newDoc);
                this.flush();
                destCollection.addDocument(this, newDoc);
            }
            this.saveCollection(destCollection);
        }
        finally {
            lock.release();
        }
        String name = collection.getName();
        Iterator i = collection.collectionIterator();
        while (i.hasNext()) {
            String childName = (String)i.next();
            Collection child = this.openCollection(name + '/' + childName, 1);
            if (child == null) {
                LOG.warn((Object)("Child collection " + childName + " not found"));
                continue;
            }
            try {
                this.copyCollection(child, destCollection, childName);
            }
            finally {
                child.release();
            }
        }
        this.saveCollection(destCollection);
        this.saveCollection(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveCollection(Collection collection, Collection destination, String newName) throws PermissionDeniedException, LockException {
        CollectionCache collectionsCache;
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        if (collection.getId() == destination.getId()) {
            throw new PermissionDeniedException("Cannot move collection to itself");
        }
        if (collection.getName().equals(ROOT_COLLECTION)) {
            throw new PermissionDeniedException("Cannot move the db root collection");
        }
        if (!collection.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("Insufficient privileges to move collection " + collection.getName());
        }
        if (!destination.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("Insufficient privileges on target collection " + destination.getName());
        }
        if (newName == null) {
            int p = collection.getName().lastIndexOf(47);
            newName = collection.getName().substring(p + 1);
        }
        if (newName.indexOf(47) > -1) {
            throw new PermissionDeniedException("New collection name is illegal (may not contain a '/')");
        }
        Collection old = this.openCollection(destination.getName() + '/' + newName, 1);
        if (old != null) {
            try {
                this.removeCollection(old);
            }
            finally {
                old.release();
            }
        }
        String name = collection.getName();
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            Collection parent = this.openCollection(collection.getParentPath(), 1);
            if (parent != null) {
                try {
                    parent.removeCollection(name.substring(name.lastIndexOf("/") + 1));
                }
                finally {
                    parent.release();
                }
            }
            Lock lock = null;
            try {
                Value key;
                lock = this.collectionsDb.getLock();
                lock.acquire(1);
                collectionsCache.remove(collection);
                try {
                    key = new Value(name.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    key = new Value(name.getBytes());
                }
                this.collectionsDb.remove(key);
                collection.setName(destination.getName() + '/' + newName);
                collection.setCreationTime(System.currentTimeMillis());
                destination.addCollection(collection);
                if (parent != null) {
                    this.saveCollection(parent);
                }
                if (parent != destination) {
                    this.saveCollection(destination);
                }
                this.saveCollection(collection);
            }
            catch (ReadOnlyException e) {
                throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
            }
            finally {
                lock.release();
            }
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                String childName = (String)i.next();
                Collection child = this.openCollection(name + '/' + childName, 1);
                if (child == null) {
                    LOG.warn((Object)("Child collection " + childName + " not found"));
                    continue;
                }
                try {
                    this.moveCollection(child, collection, childName);
                }
                finally {
                    child.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeSet scanSequential(NodeSet context, DocumentSet doc, int relation, int truncation, String expr, Collator collator) {
        ArraySet resultNodeSet = new ArraySet(context.getLength());
        Pattern regexp = null;
        if (relation == 7) {
            try {
                regexp = this.compiler.compile(expr.toLowerCase(), 1);
                truncation = 7;
            }
            catch (MalformedPatternException e) {
                LOG.debug((Object)e);
            }
        }
        Iterator i = context.iterator();
        while (i.hasNext()) {
            String content;
            NodeProxy p = (NodeProxy)i.next();
            try {
                this.domDb.getLock().acquire(0);
                this.domDb.setOwnerObject(this);
                content = this.domDb.getNodeValue(p);
            }
            catch (LockException e) {
                LOG.warn((Object)"failed to acquire read lock on dom.dbx");
                continue;
            }
            finally {
                this.domDb.getLock().release();
                continue;
            }
            String cmp = this.isCaseSensitive() ? StringValue.collapseWhitespace(content) : StringValue.collapseWhitespace(content.toLowerCase());
            switch (truncation) {
                case 1: {
                    if (!Collations.endsWith(collator, cmp, expr)) break;
                    resultNodeSet.add(p);
                    break;
                }
                case 0: {
                    if (!Collations.startsWith(collator, cmp, expr)) break;
                    resultNodeSet.add(p);
                    break;
                }
                case 2: {
                    if (-1 >= Collations.indexOf(collator, cmp, expr)) break;
                    resultNodeSet.add(p);
                    break;
                }
                case -1: {
                    if (!this.compare(collator, cmp, expr, relation)) break;
                    resultNodeSet.add(p);
                    break;
                }
                case 7: {
                    if (regexp == null || !this.matcher.contains(cmp, regexp)) break;
                    resultNodeSet.add(p);
                }
            }
        }
        return resultNodeSet;
    }

    public void shutdown() {
        super.shutdown();
        try {
            this.flush();
            this.sync(1);
            this.textEngine.close();
            this.domDb.close();
            this.elementsDb.close();
            this.collectionsDb.close();
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            e.printStackTrace();
        }
    }

    public void store(final NodeImpl node, NodePath currentPath, boolean index) {
        int percent;
        if (this.nodesCount > 10000 && (percent = (int)(this.run.freeMemory() / (this.run.totalMemory() / 100L))) < this.memMinFree) {
            this.flush();
            System.gc();
            LOG.info((Object)("total memory: " + this.run.totalMemory() + "; free: " + this.run.freeMemory()));
        }
        final DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
        boolean isTemp = TEMP_COLLECTION.equals(doc.getCollection().getName());
        IndexPaths idx = (IndexPaths)this.idxPathMap.get(doc.getDoctype().getName());
        final long gid = node.getGID();
        if (gid < 0L) {
            LOG.debug((Object)("illegal node: " + gid + "; " + node.getNodeName()));
            Thread.dumpStack();
            return;
        }
        final short nodeType = node.getNodeType();
        String nodeName = node.getNodeName();
        final int depth = idx == null ? this.defaultIndexDepth : idx.getIndexDepth();
        new DOMTransaction(this, this.domDb, 1, doc){

            public Object start() throws ReadOnlyException {
                long address = -1L;
                byte[] data = node.serialize();
                address = nodeType == 3 || nodeType == 2 || doc.getTreeLevel(gid) > depth ? NativeBroker.this.domDb.add(data) : NativeBroker.this.domDb.put(new NodeRef(doc.getDocId(), gid), data);
                if (address < 0L) {
                    LOG.warn((Object)"address is missing");
                }
                node.setInternalAddress(address);
                ByteArrayPool.releaseByteArray(data);
                return null;
            }
        }.run();
        ++this.nodesCount;
        NodeProxy tempProxy = null;
        switch (nodeType) {
            case 1: {
                tempProxy = new NodeProxy(doc, gid, node.getInternalAddress());
                tempProxy.setHasIndex(idx == null || idx.match(currentPath));
                this.elementIndex.setDocument(doc);
                this.elementIndex.addRow(node.getQName(), tempProxy);
                break;
            }
            case 2: {
                tempProxy = new NodeProxy(doc, gid, node.getInternalAddress());
                tempProxy.setHasIndex(idx == null || idx.match(currentPath));
                QName qname = new QName(node.getLocalName(), node.getNamespaceURI(), node.getPrefix());
                qname.setNameType((byte)1);
                this.elementIndex.setDocument(doc);
                this.elementIndex.addRow(qname, tempProxy);
                boolean indexAttribs = index;
                if (index && idx != null) {
                    if (idx.getIncludeAttributes()) {
                        currentPath.addComponent('@' + nodeName);
                        indexAttribs = idx.match(currentPath);
                        currentPath.removeLastComponent();
                    } else {
                        indexAttribs = false;
                    }
                }
                if (indexAttribs && !isTemp) {
                    this.textEngine.storeAttribute(idx, (AttrImpl)node);
                }
                if (((AttrImpl)node).getType() != 1) break;
                qname = new QName(((AttrImpl)node).getValue(), "", null);
                qname.setNameType((byte)2);
                this.elementIndex.addRow(qname, tempProxy);
                break;
            }
            case 3: {
                if (isTemp || !index || idx != null && !idx.match(currentPath)) break;
                boolean valore = idx == null ? false : idx.preserveContent(currentPath);
                this.textEngine.storeText(idx, (TextImpl)node, valore);
            }
        }
    }

    public void storeDocument(final DocumentImpl doc) {
        final byte[] data = doc.serialize();
        new DOMTransaction(this, this.domDb, 1){

            public Object start() throws ReadOnlyException {
                if (doc.getAddress() > -1L) {
                    NativeBroker.this.domDb.remove(doc.getAddress());
                }
                doc.setAddress(NativeBroker.this.domDb.add(data));
                return null;
            }
        }.run();
    }

    public void updateDocument(DocumentImpl doc) throws LockException, PermissionDeniedException {
        this.storeDocument(doc);
        this.saveCollection(doc.getCollection());
    }

    public void storeBinaryResource(final BinaryDocument blob, final byte[] data) {
        new DOMTransaction(this, this.domDb, 1){

            public Object start() throws ReadOnlyException {
                LOG.debug((Object)("Storing binary resource " + blob.getFileName()));
                blob.setPage(NativeBroker.this.domDb.addBinary(data));
                return null;
            }
        }.run();
    }

    public byte[] getBinaryResourceData(final BinaryDocument blob) {
        byte[] data = (byte[])new DOMTransaction(this, this.domDb, 1){

            public Object start() throws ReadOnlyException {
                return NativeBroker.this.domDb.getBinary(blob.getPage());
            }
        }.run();
        return data;
    }

    public void removeBinaryResource(final BinaryDocument blob) throws PermissionDeniedException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        LOG.info((Object)("removing binary resource " + blob.getDocId() + "..."));
        new DOMTransaction(this, this.domDb, 1){

            public Object start() throws ReadOnlyException {
                NativeBroker.this.domDb.remove(blob.getAddress());
                NativeBroker.this.domDb.removeOverflowValue(blob.getPage());
                return null;
            }
        }.run();
    }

    public void readDocumentMetadata(final DocumentImpl doc) {
        new DOMTransaction(this, this.domDb, 1){

            public Object start() throws ReadOnlyException {
                Value val = NativeBroker.this.domDb.get(doc.getAddress());
                doc.deserialize(val.getData());
                return null;
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(int syncEvent) {
        try {
            Lock lock = this.collectionsDb.getLock();
            try {
                lock.acquire(1);
                this.collectionsDb.flush();
            }
            catch (LockException e) {
                LOG.warn((Object)"failed to acquire lock on collections store", (Throwable)e);
            }
            finally {
                lock.release();
            }
            new DOMTransaction(this, this.domDb, 1){

                public Object start() {
                    try {
                        NativeBroker.this.domDb.flush();
                    }
                    catch (DBException e) {
                        LOG.warn((Object)"error while flushing dom.dbx", (Throwable)e);
                    }
                    return null;
                }
            }.run();
            if (syncEvent == 1) {
                this.elementIndex.sync();
                this.textEngine.sync();
                System.gc();
                Runtime runtime = Runtime.getRuntime();
                LOG.info((Object)("Memory: " + runtime.totalMemory() / 1024L + "K total; " + runtime.maxMemory() / 1024L + "K max; " + runtime.freeMemory() / 1024L + "K free"));
                this.elementsDb.printStatistics();
                this.collectionsDb.printStatistics();
                this.domDb.printStatistics();
            }
        }
        catch (DBException dbe) {
            dbe.printStackTrace();
            LOG.debug((Object)dbe);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void closeDocument() {
        new DOMTransaction(this, this.domDb, 1){

            public Object start() {
                NativeBroker.this.domDb.closeDocument();
                return null;
            }
        }.run();
    }

    public void update(final NodeImpl node) {
        try {
            final DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
            final long internalAddress = node.getInternalAddress();
            final byte[] data = node.serialize();
            new DOMTransaction(this, this.domDb, 1){

                public Object start() throws ReadOnlyException {
                    if (-1L < internalAddress) {
                        NativeBroker.this.domDb.update(internalAddress, data);
                    } else {
                        NativeBroker.this.domDb.update(new NodeRef(doc.getDocId(), node.getGID()), data);
                    }
                    return null;
                }
            }.run();
            ByteArrayPool.releaseByteArray(data);
        }
        catch (Exception e) {
            Value oldVal = this.domDb.get(node.getInternalAddress());
            NodeImpl old = NodeImpl.deserialize(oldVal.data(), oldVal.start(), oldVal.getLength(), (DocumentImpl)node.getOwnerDocument(), false);
            LOG.debug((Object)("Exception while storing " + node.getNodeName() + "; gid = " + node.getGID() + "; old = " + old.getNodeName()), (Throwable)e);
        }
    }

    public void insertAfter(final NodeImpl previous, final NodeImpl node) {
        final byte[] data = node.serialize();
        final DocumentImpl doc = (DocumentImpl)previous.getOwnerDocument();
        new DOMTransaction(this, this.domDb, 1, doc){

            public Object start() {
                long address = previous.getInternalAddress();
                if (address > -1L) {
                    address = NativeBroker.this.domDb.insertAfter(doc, address, data);
                } else {
                    NodeRef ref = new NodeRef(doc.getDocId(), previous.getGID());
                    address = NativeBroker.this.domDb.insertAfter(doc, ref, data);
                }
                node.setInternalAddress(address);
                return null;
            }
        }.run();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public DocumentImpl storeTemporaryDoc(String data) throws EXistException, PermissionDeniedException, LockException {
        IndexInfo info;
        String docName = MD5.md(Thread.currentThread().getName() + Long.toString(System.currentTimeMillis())) + ".xml";
        Collection temp = this.openCollection(TEMP_COLLECTION, 1);
        if (temp == null) {
            temp = this.createTempCollection();
        }
        try {
            info = temp.validate((DBBroker)this, docName, data);
        }
        catch (TriggerException e) {
            throw new EXistException(TEMP_STORE_ERROR + e.getMessage());
        }
        catch (SAXException e) {
            throw new EXistException(TEMP_STORE_ERROR + e.getMessage());
        }
        finally {
            temp.release();
        }
        try {
            temp.store((DBBroker)this, info, data, false);
        }
        catch (TriggerException e) {
            throw new EXistException(TEMP_STORE_ERROR + e.getMessage());
        }
        catch (SAXException e) {
            throw new EXistException(TEMP_STORE_ERROR + e.getMessage());
        }
        return info.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTempDocs(List docs) {
        Collection temp = this.openCollection(TEMP_COLLECTION, 1);
        if (temp == null) {
            return;
        }
        try {
            Iterator i = docs.iterator();
            while (i.hasNext()) {
                temp.removeDocument(this, (String)i.next());
            }
        }
        catch (PermissionDeniedException e) {
            LOG.warn((Object)TEMP_FRAGMENT_REMOVE_ERROR, (Throwable)e);
        }
        catch (TriggerException e) {
            LOG.warn((Object)TEMP_FRAGMENT_REMOVE_ERROR, (Throwable)e);
        }
        catch (LockException e) {
            LOG.warn((Object)TEMP_FRAGMENT_REMOVE_ERROR, (Throwable)e);
        }
        finally {
            temp.release();
        }
    }

    public void cleanUpAll() {
        Collection temp = this.getCollection(TEMP_COLLECTION);
        if (temp == null) {
            return;
        }
        try {
            this.removeCollection(temp);
        }
        catch (PermissionDeniedException e) {
            LOG.warn((Object)("Failed to remove temporary collection: " + e.getMessage()), (Throwable)e);
        }
    }

    public void cleanUp() {
        Collection temp = this.getCollection(TEMP_COLLECTION);
        if (temp == null) {
            return;
        }
        long now = System.currentTimeMillis();
        Iterator i = temp.iterator(this);
        while (i.hasNext()) {
            DocumentImpl next = (DocumentImpl)i.next();
            long modified = next.getLastModified();
            if (now - modified <= 300000L) continue;
            try {
                temp.removeDocument(this, next.getFileName());
            }
            catch (PermissionDeniedException e) {
                LOG.warn((Object)("Failed to remove temporary fragment: " + e.getMessage()), (Throwable)e);
            }
            catch (TriggerException e) {
                LOG.warn((Object)("Failed to remove temporary fragment: " + e.getMessage()), (Throwable)e);
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to remove temporary fragment: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection createTempCollection() throws LockException, PermissionDeniedException {
        User u = this.user;
        Lock lock = null;
        try {
            lock = this.collectionsDb.getLock();
            lock.acquire(1);
            this.user = this.pool.getSecurityManager().getUser("admin");
            Collection temp = this.getOrCreateCollection(TEMP_COLLECTION);
            temp.setPermissions(511);
            this.saveCollection(temp);
            temp.getLock().acquire(1);
            Collection collection = temp;
            return collection;
        }
        finally {
            lock.release();
            this.user = u;
        }
    }

    public static final class NodeRef
    extends Value {
        private static final Logger LOG = Logger.getLogger((Class)(class$org$exist$storage$NativeBroker$NodeRef == null ? (class$org$exist$storage$NativeBroker$NodeRef = NativeBroker.class$("org.exist.storage.NativeBroker$NodeRef")) : class$org$exist$storage$NativeBroker$NodeRef));

        public NodeRef() {
            this.data = new byte[12];
        }

        public NodeRef(int docId, long gid) {
            this.data = new byte[12];
            ByteConversion.intToByte(docId, this.data, 0);
            ByteConversion.longToByte(gid, this.data, 4);
            this.len = 12;
            this.pos = 0;
        }

        public NodeRef(int docId) {
            this.data = new byte[4];
            ByteConversion.intToByte(docId, this.data, 0);
            this.len = 4;
            this.pos = 0;
        }

        int getDocId() {
            return ByteConversion.byteToInt(this.data, 0);
        }

        long getGid() {
            return ByteConversion.byteToLong(this.data, 4);
        }

        void set(int docId, long gid) {
            ByteConversion.intToByte(docId, this.data, 0);
            ByteConversion.longToByte(gid, this.data, 4);
            this.len = 12;
            this.pos = 0;
        }
    }
}

