/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.exist.storage.NodePath;

public class IndexPaths {
    private static final HashMap cache = new HashMap();
    protected ArrayList includePath;
    protected ArrayList excludePath;
    protected ArrayList preserveContent;
    protected boolean includeByDefault = true;
    protected boolean includeAttributes = true;
    protected boolean includeAlphaNum = true;
    protected int depth = 1;

    public IndexPaths(boolean def) {
        this.includeByDefault = def;
        this.includePath = new ArrayList();
        this.excludePath = new ArrayList();
        this.preserveContent = new ArrayList();
    }

    public void addInclude(String path) {
        this.includePath.add(new NodePath(path));
    }

    public void addExclude(String path) {
        this.excludePath.add(new NodePath(path));
    }

    public boolean isSelective() {
        return this.includeByDefault && this.excludePath.size() > 0 || !this.includeByDefault && this.includePath.size() > 0;
    }

    public void setIncludeAttributes(boolean index) {
        this.includeAttributes = index;
    }

    public boolean getIncludeAttributes() {
        return this.includeAttributes;
    }

    public void setIncludeAlphaNum(boolean index) {
        this.includeAlphaNum = index;
    }

    public boolean getIncludeAlphaNum() {
        return this.includeAlphaNum;
    }

    public int getIndexDepth() {
        return this.depth;
    }

    public void setIndexDepth(int depth) {
        this.depth = depth;
    }

    public boolean match(NodePath path) {
        if (this.includeByDefault) {
            Iterator i = this.excludePath.iterator();
            while (i.hasNext()) {
                if (!((NodePath)i.next()).match(path)) continue;
                return false;
            }
            return true;
        }
        Iterator i = this.includePath.iterator();
        while (i.hasNext()) {
            if (!((NodePath)i.next()).match(path)) continue;
            return true;
        }
        return false;
    }

    public void addpreserveContent(String path) {
        this.preserveContent.add(new NodePath(path));
    }

    public boolean preserveContent(NodePath path) {
        Iterator i = this.preserveContent.iterator();
        while (i.hasNext()) {
            if (!((NodePath)i.next()).match(path)) continue;
            return true;
        }
        return false;
    }
}

