/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import org.dbxml.core.data.Value;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;

public class ElementValue
extends Value {
    public static final byte ELEMENT = 0;
    public static final byte ATTRIBUTE = 1;
    public static final byte ATTRIBUTE_ID = 2;
    public static final String[] type = new String[]{"element", "attribute", "id"};

    ElementValue(short collectionId) {
        this.data = new byte[2];
        ByteConversion.shortToByte(collectionId, this.data, 0);
        this.len = 2;
        this.pos = 0;
    }

    ElementValue(byte type, short collectionId) {
        this.data = new byte[3];
        ByteConversion.shortToByte(collectionId, this.data, 0);
        this.data[2] = type;
        this.len = 3;
        this.pos = 0;
    }

    ElementValue(byte type, short collectionId, short symbol) {
        this.len = 5;
        this.data = new byte[this.len];
        ByteConversion.shortToByte(collectionId, this.data, 0);
        this.data[2] = type;
        ByteConversion.shortToByte(symbol, this.data, 3);
        this.pos = 0;
    }

    ElementValue(byte type, short collectionId, short symbol, short nsSymbol) {
        this.len = 7;
        this.data = new byte[this.len];
        ByteConversion.shortToByte(collectionId, this.data, 0);
        this.data[2] = type;
        ByteConversion.shortToByte(symbol, this.data, 3);
        ByteConversion.shortToByte(nsSymbol, this.data, 5);
        this.pos = 0;
    }

    ElementValue(byte type, short collectionId, String idValue) {
        this.len = 3 + UTF8.encoded(idValue);
        this.data = new byte[this.len];
        ByteConversion.shortToByte(collectionId, this.data, 0);
        this.data[2] = type;
        UTF8.encode(idValue, this.data, 3);
    }

    short getCollectionId() {
        return ByteConversion.byteToShort(this.data, 0);
    }
}

