/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.SymbolTable;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.ElementIndex;
import org.exist.storage.NodePath;
import org.exist.storage.TextSearchEngine;
import org.exist.storage.io.VariableByteInputStream;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.serializers.Serializer;
import org.exist.util.Configuration;
import org.exist.util.LockException;
import org.exist.xquery.XQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DBBroker
extends Observable {
    public static final int MATCH_EXACT = 0;
    public static final int MATCH_REGEXP = 1;
    public static final int MATCH_WILDCARDS = 2;
    public static final int MYSQL = 0;
    public static final int NATIVE = 4;
    public static final int ORACLE = 1;
    public static final int POSTGRESQL = 2;
    public static final int DBM = 3;
    protected static final Logger LOG = Logger.getLogger((Class)DBBroker.class);
    protected boolean caseSensitive = true;
    protected Configuration config;
    protected BrokerPool pool;
    protected File symbolsFile;
    protected SymbolTable symbols = null;
    protected User user = null;
    protected XQuery xqueryService;
    private int referenceCount = 0;
    protected int xupdateGrowthFactor = 1;
    protected int docFragmentationLimit = 25;
    protected boolean xupdateConsistencyChecks = false;
    protected String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveSymbols() throws EXistException {
        SymbolTable symbolTable = this.symbols;
        synchronized (symbolTable) {
            try {
                VariableByteOutputStream os = new VariableByteOutputStream(256);
                this.symbols.write(os);
                FileOutputStream fos = new FileOutputStream(this.symbols.getFile().getAbsolutePath(), false);
                fos.write(os.toByteArray());
                fos.close();
            }
            catch (FileNotFoundException e) {
                throw new EXistException("file not found: " + this.symbols.getFile().getAbsolutePath());
            }
            catch (IOException e) {
                throw new EXistException("io error occurred while creating " + this.symbolsFile.getAbsolutePath());
            }
        }
    }

    protected void loadSymbols() throws EXistException {
        try {
            FileInputStream fis = new FileInputStream(this.symbols.getFile());
            VariableByteInputStream is = new VariableByteInputStream(fis);
            this.symbols.read(is);
            fis.close();
        }
        catch (FileNotFoundException e) {
            throw new EXistException("could not read " + this.symbolsFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new EXistException("io error occurred while reading " + this.symbolsFile.getAbsolutePath());
        }
    }

    public SymbolTable getSymbols() {
        return this.symbols;
    }

    public DBBroker(BrokerPool pool, Configuration config) throws EXistException {
        String dataDir;
        this.config = config;
        Boolean temp = (Boolean)config.getProperty("indexer.case-sensitive");
        if (temp != null) {
            this.caseSensitive = temp;
        }
        if ((dataDir = (String)config.getProperty("db-connection.data-dir")) == null) {
            dataDir = "data";
        }
        if ((this.symbols = (SymbolTable)config.getProperty("db-connection.symbol-table")) == null) {
            this.symbolsFile = new File(dataDir + File.separatorChar + "symbols.dbx");
            LOG.debug((Object)("Loading symbol table from " + this.symbolsFile.getAbsolutePath()));
            this.symbols = new SymbolTable(this.symbolsFile);
            if (!this.symbolsFile.canRead()) {
                this.saveSymbols();
            } else {
                this.loadSymbols();
            }
            config.setProperty("db-connection.symbol-table", this.symbols);
        }
        if ((this.xupdateGrowthFactor = config.getInteger("xupdate.growth-factor")) < 0) {
            this.xupdateGrowthFactor = 1;
        }
        if ((this.docFragmentationLimit = config.getInteger("xupdate.fragmentation")) < 0) {
            this.docFragmentationLimit = 50;
        }
        if ((temp = (Boolean)config.getProperty("xupdate.consistency-checks")) != null) {
            this.xupdateConsistencyChecks = temp;
        }
        LOG.debug((Object)("fragmentation = " + this.docFragmentationLimit));
        this.pool = pool;
        this.xqueryService = new XQuery(this);
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public XQuery getXQueryService() {
        return this.xqueryService;
    }

    public abstract ElementIndex getElementIndex();

    public void flush() {
    }

    public abstract DocumentSet getAllDocuments(DocumentSet var1);

    public abstract Collection getCollection(String var1);

    public abstract Collection getCollection(String var1, long var2);

    public abstract Collection openCollection(String var1, int var2);

    public Collection getOrCreateCollection(String name) throws PermissionDeniedException {
        return null;
    }

    public abstract void reloadCollection(Collection var1);

    public Configuration getConfiguration() {
        return this.config;
    }

    public Iterator getDOMIterator(Document doc, long gid) {
        throw new RuntimeException("not implemented for this storage backend");
    }

    public Iterator getDOMIterator(NodeProxy proxy) {
        throw new RuntimeException("not implemented for this storage backend");
    }

    public Iterator getNodeIterator(NodeProxy proxy) {
        throw new RuntimeException("not implemented for this storage backend");
    }

    public abstract Document getDocument(String var1) throws PermissionDeniedException;

    public abstract DocumentImpl openDocument(String var1, int var2) throws PermissionDeniedException;

    public abstract DocumentSet getDocumentsByCollection(String var1, DocumentSet var2) throws PermissionDeniedException;

    public abstract DocumentSet getDocumentsByCollection(String var1, DocumentSet var2, boolean var3) throws PermissionDeniedException;

    public abstract int getNextDocId(Collection var1);

    public String getNodeValue(NodeProxy proxy) {
        throw new RuntimeException("not implemented for this storage backend");
    }

    public abstract NodeSet getNodesEqualTo(NodeSet var1, DocumentSet var2, int var3, String var4, Collator var5);

    public abstract NodeList getRange(Document var1, long var2, long var4);

    public abstract Serializer getSerializer();

    public abstract TextSearchEngine getTextEngine();

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public abstract Serializer newSerializer();

    public abstract Node objectWith(Document var1, long var2);

    public abstract Node objectWith(NodeProxy var1);

    public abstract boolean removeCollection(Collection var1) throws PermissionDeniedException;

    public void removeDocument(DocumentImpl document) throws PermissionDeniedException {
        this.removeDocument(document, true);
    }

    public abstract void removeDocument(DocumentImpl var1, boolean var2) throws PermissionDeniedException;

    public abstract void reindex(String var1) throws PermissionDeniedException;

    public abstract void saveCollection(Collection var1) throws PermissionDeniedException;

    public void addDocument(Collection collection, DocumentImpl doc) throws PermissionDeniedException {
    }

    public void closeDocument() {
    }

    public void shutdown() {
    }

    public abstract void store(NodeImpl var1, NodePath var2, boolean var3);

    public void store(NodeImpl node, NodePath currentPath) {
        this.store(node, currentPath, true);
    }

    public abstract void storeDocument(DocumentImpl var1);

    public abstract void updateDocument(DocumentImpl var1) throws LockException, PermissionDeniedException;

    public abstract void storeBinaryResource(BinaryDocument var1, byte[] var2);

    public abstract byte[] getBinaryResourceData(BinaryDocument var1);

    public abstract void removeBinaryResource(BinaryDocument var1) throws PermissionDeniedException;

    public abstract void moveCollection(Collection var1, Collection var2, String var3) throws PermissionDeniedException, LockException;

    public abstract void moveResource(DocumentImpl var1, Collection var2, String var3) throws PermissionDeniedException, LockException;

    public abstract void copyCollection(Collection var1, Collection var2, String var3) throws PermissionDeniedException, LockException;

    public abstract void copyResource(DocumentImpl var1, Collection var2, String var3) throws PermissionDeniedException, LockException;

    public abstract void defrag(DocumentImpl var1);

    public abstract void checkTree(DocumentImpl var1);

    public abstract void consistencyCheck(DocumentImpl var1) throws EXistException;

    public abstract void sync(int var1);

    public void update(NodeImpl node) {
        throw new RuntimeException("not implemented");
    }

    public boolean isReadOnly() {
        return false;
    }

    public BrokerPool getBrokerPool() {
        return this.pool;
    }

    public void insertAfter(NodeImpl previous, NodeImpl node) {
        throw new RuntimeException("not implemented");
    }

    public void reindex(DocumentImpl oldDoc, DocumentImpl doc, NodeImpl node) {
        throw new RuntimeException("not implemented");
    }

    public void index(NodeImpl node) {
        this.index(node, null);
    }

    public void index(NodeImpl node, NodePath currentPath) {
        throw new RuntimeException("not implemented");
    }

    public void removeNode(NodeImpl node, NodePath currentPath) {
        throw new RuntimeException("not implemented");
    }

    public void endRemove() {
        throw new RuntimeException("not implemented");
    }

    public abstract DocumentImpl storeTemporaryDoc(String var1) throws EXistException, PermissionDeniedException, LockException;

    public abstract void cleanUpAll();

    public abstract void cleanUp();

    public abstract void removeTempDocs(List var1);

    public void readDocumentMetadata(DocumentImpl doc) {
    }

    public abstract DocumentSet getDocumentsByDoctype(String var1, DocumentSet var2);

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void incReferenceCount() {
        ++this.referenceCount;
    }

    public void decReferenceCount() {
        --this.referenceCount;
    }

    public int getXUpdateGrowthFactor() {
        return this.xupdateGrowthFactor;
    }

    public int getFragmentationLimit() {
        return this.docFragmentationLimit;
    }

    public boolean consistencyChecksEnabled() {
        return this.xupdateConsistencyChecks;
    }

    public abstract int getPageSize();

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }
}

