/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.CollectionCache;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.storage.BrokerFactory;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryMonitor;
import org.exist.storage.XQueryPool;
import org.exist.storage.sync.Sync;
import org.exist.storage.sync.SyncDaemon;
import org.exist.util.Configuration;
import org.exist.util.Lock;
import org.exist.util.ReentrantReadWriteLock;
import org.exist.util.XMLReaderObjectFactory;
import org.exist.util.XMLReaderPool;
import org.exist.xmldb.ShutdownListener;

public class BrokerPool {
    private static final Logger LOG = Logger.getLogger((Class)BrokerPool.class);
    private static final TreeMap instances = new TreeMap();
    private static boolean registerShutdownHook = true;
    private static final ShutdownThread shutdownThread = new ShutdownThread();
    public static final int COLLECTION_BUFFER_SIZE = 128;
    public static final String DEFAULT_INSTANCE = "exist";
    public static final long MAX_SHUTDOWN_WAIT = 45000L;
    private int max = 15;
    private int min = 1;
    protected Configuration conf = null;
    private int brokers = 0;
    private Stack pool = new Stack();
    private Map threads = new HashMap();
    private String instanceId;
    private boolean syncRequired = false;
    private int syncEvent = 0;
    private boolean initializing = true;
    private long maxShutdownWait = 45000L;
    private SecurityManager secManager = null;
    private SyncDaemon syncDaemon;
    private ShutdownListener shutdownListener = null;
    private XQueryPool xqueryCache;
    private XQueryMonitor monitor;
    protected CollectionCache collectionsCache;
    protected XMLReaderPool xmlReaderPool;
    private Lock globalXUpdateLock = new ReentrantReadWriteLock("xupdate");

    public static final void setRegisterShutdownHook(boolean register) {
        registerShutdownHook = register;
    }

    public static final void configure(int minBrokers, int maxBrokers, Configuration config) throws EXistException {
        BrokerPool.configure(DEFAULT_INSTANCE, minBrokers, maxBrokers, config);
    }

    public static final void configure(String id, int minBrokers, int maxBrokers, Configuration config) throws EXistException {
        BrokerPool instance = (BrokerPool)instances.get(id);
        if (instance == null) {
            LOG.debug((Object)("configuring database instance '" + id + "' ..."));
            instance = new BrokerPool(id, minBrokers, maxBrokers, config);
            instances.put(id, instance);
            if (instances.size() == 1 && registerShutdownHook) {
                LOG.debug((Object)"registering shutdown hook");
                try {
                    Runtime.getRuntime().addShutdownHook(shutdownThread);
                }
                catch (IllegalArgumentException e) {
                    LOG.debug((Object)"shutdown hook already registered");
                }
            }
        } else {
            LOG.warn((Object)("instance with id " + id + " already configured"));
        }
    }

    public static final boolean isConfigured(String id) {
        BrokerPool instance = (BrokerPool)instances.get(id);
        if (instance == null) {
            return false;
        }
        return instance.isInstanceConfigured();
    }

    public static final boolean isConfigured() {
        return BrokerPool.isConfigured(DEFAULT_INSTANCE);
    }

    public static final BrokerPool getInstance(String id) throws EXistException {
        BrokerPool instance = (BrokerPool)instances.get(id);
        if (instance != null) {
            return instance;
        }
        throw new EXistException("instance with id " + id + " has not been configured yet");
    }

    public static final BrokerPool getInstance() throws EXistException {
        return BrokerPool.getInstance(DEFAULT_INSTANCE);
    }

    public static final Iterator getInstances() {
        return instances.values().iterator();
    }

    public static final void stop(String id) throws EXistException {
        BrokerPool instance = (BrokerPool)instances.get(id);
        if (instance == null) {
            throw new EXistException("instance with id  is not available");
        }
        instance.shutdown();
    }

    public static final void stop() throws EXistException {
        BrokerPool.stop(DEFAULT_INSTANCE);
    }

    public static final void stopAll(boolean killed) {
        Vector tmpInstances = new Vector();
        Iterator i = instances.values().iterator();
        while (i.hasNext()) {
            tmpInstances.add(i.next());
        }
        Iterator i2 = tmpInstances.iterator();
        while (i2.hasNext()) {
            BrokerPool instance = (BrokerPool)i2.next();
            if (instance.conf == null) continue;
            instance.shutdown(killed);
        }
        instances.clear();
    }

    public BrokerPool(String id, int minBrokers, int maxBrokers, Configuration config) throws EXistException {
        this.instanceId = id;
        this.min = minBrokers;
        this.max = maxBrokers;
        Integer minInt = (Integer)config.getProperty("db-connection.pool.min");
        Integer maxInt = (Integer)config.getProperty("db-connection.pool.max");
        Long syncInt = (Long)config.getProperty("db-connection.pool.sync-period");
        Long maxWaitInt = (Long)config.getProperty("db-connection.pool.shutdown-wait");
        if (minInt != null) {
            this.min = minInt;
        }
        if (maxInt != null) {
            this.max = maxInt;
        }
        long syncPeriod = 120000L;
        if (syncInt != null) {
            syncPeriod = syncInt;
        }
        if (maxWaitInt != null) {
            this.maxShutdownWait = maxWaitInt;
            LOG.info((Object)("Max. wait during shutdown: " + this.maxShutdownWait));
        }
        LOG.info((Object)("Instances: min = " + this.min + "; max = " + this.max + "; sync = " + syncPeriod));
        this.syncDaemon = new SyncDaemon();
        if (syncPeriod > 0L) {
            this.syncDaemon.executePeriodically(1000L, new Sync(this, syncPeriod), false);
        }
        this.conf = config;
        this.xqueryCache = new XQueryPool();
        this.monitor = new XQueryMonitor();
        this.collectionsCache = new CollectionCache(128);
        this.xmlReaderPool = new XMLReaderPool((PoolableObjectFactory)new XMLReaderObjectFactory(this), 5, 0);
        this.initialize();
    }

    public int active() {
        return this.threads.size();
    }

    public int available() {
        return this.pool.size();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public CollectionCache getCollectionsCache() {
        return this.collectionsCache;
    }

    public XMLReaderPool getParserPool() {
        return this.xmlReaderPool;
    }

    protected DBBroker createBroker() throws EXistException {
        DBBroker broker = BrokerFactory.getInstance(this, this.conf);
        LOG.debug((Object)("database " + this.instanceId + ": created new instance of " + broker.getClass().getName()));
        this.pool.push(broker);
        ++this.brokers;
        broker.setId(broker.getClass().getName() + '_' + this.brokers);
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBBroker get() throws EXistException {
        if (!this.isInstanceConfigured()) {
            throw new EXistException("database instance is not available");
        }
        DBBroker broker = (DBBroker)this.threads.get(Thread.currentThread());
        if (broker != null) {
            broker.incReferenceCount();
            return broker;
        }
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            if (this.pool.isEmpty()) {
                if (this.brokers < this.max) {
                    this.createBroker();
                } else {
                    while (this.pool.isEmpty()) {
                        LOG.debug((Object)"waiting for broker instance to become available");
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            broker = (DBBroker)this.pool.pop();
            this.threads.put(Thread.currentThread(), broker);
            broker.incReferenceCount();
            this.notifyAll();
            return broker;
        }
    }

    public DBBroker get(User user) throws EXistException {
        DBBroker broker = this.get();
        broker.setUser(user);
        return broker;
    }

    public SecurityManager getSecurityManager() {
        return this.secManager;
    }

    public void reloadSecurityManager(DBBroker broker) {
        LOG.debug((Object)"reloading security manager");
        this.secManager = new SecurityManager(this, broker);
    }

    public SyncDaemon getSyncDaemon() {
        return this.syncDaemon;
    }

    protected void initialize() throws EXistException {
        LOG.debug((Object)("initializing database " + this.instanceId));
        this.initializing = true;
        this.createBroker();
        DBBroker broker = (DBBroker)this.pool.peek();
        broker.cleanUpAll();
        this.secManager = new SecurityManager(this, broker);
        this.initializing = false;
        for (int i = 1; i < this.min; ++i) {
            this.createBroker();
        }
        LOG.debug((Object)("database engine " + this.instanceId + " initialized."));
    }

    protected boolean isInitializing() {
        return this.initializing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DBBroker broker) {
        if (broker == null) {
            return;
        }
        broker.decReferenceCount();
        if (broker.getReferenceCount() > 0) {
            return;
        }
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            this.threads.remove(Thread.currentThread());
            this.pool.push(broker);
            if (this.syncRequired && this.threads.size() == 0) {
                this.sync(broker, this.syncEvent);
                this.syncRequired = false;
            }
            this.notifyAll();
        }
    }

    public void sync(DBBroker broker, int syncEvent) {
        broker.sync(syncEvent);
        broker.cleanUp();
    }

    public synchronized void shutdown() {
        this.shutdown(false);
    }

    public synchronized void shutdown(boolean killed) {
        this.syncDaemon.shutDown();
        this.monitor.killAll(500L);
        long waitStart = System.currentTimeMillis();
        while (this.threads.size() > 0) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (System.currentTimeMillis() - waitStart <= this.maxShutdownWait) continue;
            LOG.debug((Object)"Not all threads returned. Forcing shutdown ...");
            break;
        }
        LOG.debug((Object)"calling shutdown ...");
        DBBroker broker = null;
        if (this.pool.isEmpty()) {
            try {
                broker = this.createBroker();
            }
            catch (EXistException e) {
                LOG.warn((Object)"could not create instance for shutdown. Giving up.");
            }
        } else {
            broker = (DBBroker)this.pool.peek();
        }
        broker.shutdown();
        LOG.debug((Object)"shutdown!");
        this.conf = null;
        instances.remove(this.instanceId);
        if (instances.size() == 0 && !killed) {
            LOG.debug((Object)"removing shutdown hook");
            Runtime.getRuntime().removeShutdownHook(shutdownThread);
        }
        if (this.shutdownListener != null) {
            this.shutdownListener.shutdown(this.instanceId, instances.size());
        }
    }

    public int getMax() {
        return this.max;
    }

    public String getId() {
        return this.instanceId;
    }

    public final boolean isInstanceConfigured() {
        return this.conf != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSync(int event) {
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            if (this.pool.size() == 0) {
                return;
            }
            if (this.pool.size() == this.brokers) {
                DBBroker broker = (DBBroker)this.pool.peek();
                this.sync(broker, event);
                this.syncRequired = false;
            } else {
                this.syncEvent = event;
                this.syncRequired = true;
            }
        }
    }

    public void registerShutdownListener(ShutdownListener listener) {
        this.shutdownListener = listener;
    }

    public XQueryPool getXQueryPool() {
        return this.xqueryCache;
    }

    public XQueryMonitor getXQueryMonitor() {
        return this.monitor;
    }

    public Lock getGlobalUpdateLock() {
        return this.globalXUpdateLock;
    }

    protected static class ShutdownThread
    extends Thread {
        public void run() {
            LOG.debug((Object)"shutdown forced");
            BrokerPool.stopAll(true);
        }
    }
}

