/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exist.source.AbstractSource;
import org.exist.source.Source;

public class FileSource
extends AbstractSource {
    private String filePath;
    private long lastModified;
    private String encoding;

    public FileSource(File file, String encoding) {
        this.filePath = file.getAbsolutePath();
        this.lastModified = file.lastModified();
        this.encoding = encoding;
    }

    public Object getKey() {
        return this.filePath;
    }

    public int isValid() {
        File f = new File(this.filePath);
        if (f.lastModified() > this.lastModified) {
            return -1;
        }
        return 1;
    }

    public int isValid(Source other) {
        return -1;
    }

    public Reader getReader() throws IOException {
        return new FileReader(new File(this.filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent() throws IOException {
        FileInputStream is = new FileInputStream(new File(this.filePath));
        try {
            int read;
            InputStreamReader reader = new InputStreamReader((InputStream)is, this.encoding);
            char[] chars = new char[1024];
            StringBuffer buf = new StringBuffer();
            while ((read = reader.read(chars)) > -1) {
                buf.append(chars, 0, read);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            is.close();
        }
    }
}

