/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.exist.security.MD5;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class User {
    public static final User DEFAULT = new User("guest", null, "guest");
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String PASS = "password";
    private static final String USER_ID = "uid";
    private static final String HOME = "home";
    public static final int PLAIN_ENCODING = 0;
    public static final int SIMPLE_MD5_ENCODING = 1;
    public static final int MD5_ENCODING = 2;
    public static int PASSWORD_ENCODING;
    private ArrayList groups = new ArrayList(2);
    private String password = null;
    private String user;
    private int uid = -1;
    private String home = null;

    public User(String user, String password) {
        this.user = user;
        this.setPassword(password);
    }

    public User(String user) {
        this.user = user;
    }

    public User(String user, String password, String primaryGroup) {
        this(user, password);
        this.addGroup(primaryGroup);
    }

    public User(Element node) throws DatabaseConfigurationException {
        this.user = node.getAttribute(NAME);
        if (this.user == null) {
            throw new DatabaseConfigurationException("user needs a name");
        }
        this.password = node.getAttribute(PASS);
        String userId = node.getAttribute(USER_ID);
        if (userId == null) {
            throw new DatabaseConfigurationException("attribute id missing");
        }
        try {
            this.uid = Integer.parseInt(userId);
        }
        catch (NumberFormatException e) {
            throw new DatabaseConfigurationException("illegal user id: " + userId + " for user " + this.user);
        }
        this.home = node.getAttribute(HOME);
        NodeList gl = node.getChildNodes();
        for (int i = 0; i < gl.getLength(); ++i) {
            Node group = gl.item(i);
            if (group.getNodeType() != 1 || !group.getLocalName().equals(GROUP)) continue;
            this.groups.add(group.getFirstChild().getNodeValue());
        }
    }

    public final void addGroup(String group) {
        this.groups.add(group);
    }

    public final void setGroups(Iterator iter) {
        while (iter.hasNext()) {
            this.addGroup((String)iter.next());
        }
    }

    public final Iterator getGroups() {
        return this.groups.iterator();
    }

    public final String getName() {
        return this.user;
    }

    public final int getUID() {
        return this.uid;
    }

    public final String getPassword() {
        return this.password;
    }

    public final String getPrimaryGroup() {
        if (this.groups.size() == 0) {
            return null;
        }
        return (String)this.groups.get(0);
    }

    public final boolean hasGroup(String group) {
        Iterator i = this.getGroups();
        while (i.hasNext()) {
            String g = (String)i.next();
            if (!g.equals(group)) continue;
            return true;
        }
        return false;
    }

    public final void setPassword(String passwd) {
        this.password = passwd == null ? null : this.digest(passwd);
    }

    public final void setPasswordDigest(String passwd) {
        this.password = passwd == null ? null : passwd;
    }

    public final String digest(String passwd) {
        switch (PASSWORD_ENCODING) {
            case 0: {
                return passwd;
            }
            case 2: {
                return MD5.md(this.user + ":exist:" + passwd);
            }
        }
        return MD5.md(passwd);
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<user name=\"");
        buf.append(this.user);
        buf.append("\" ");
        buf.append("uid=\"");
        buf.append(Integer.toString(this.uid));
        buf.append("\"");
        if (this.password != null) {
            buf.append(" password=\"");
            buf.append(this.password);
            buf.append('\"');
        }
        if (this.home != null) {
            buf.append(" home=\"");
            buf.append(this.home);
            buf.append("\">");
        } else {
            buf.append(">");
        }
        Iterator i = this.groups.iterator();
        while (i.hasNext()) {
            String group = (String)i.next();
            buf.append("<group>");
            buf.append(group);
            buf.append("</group>");
        }
        buf.append("</user>");
        return buf.toString();
    }

    public final boolean validate(String passwd) {
        if (this.password == null) {
            return true;
        }
        if (passwd == null) {
            return false;
        }
        return this.digest(passwd).equals(this.password);
    }

    public void setUID(int uid) {
        this.uid = uid;
    }

    public void setHome(String homeCollection) {
        this.home = homeCollection;
    }

    public String getHome() {
        return this.home;
    }

    public boolean equals(Object obj) {
        User other = (User)obj;
        return this.uid == other.uid;
    }

    static {
        Properties props = new Properties();
        try {
            props.load(User.class.getClassLoader().getResourceAsStream("org/exist/security/security.properties"));
        }
        catch (IOException e) {
            // empty catch block
        }
        String encoding = props.getProperty("passwords.encoding", "md5");
        if (encoding != null) {
            PASSWORD_ENCODING = encoding.equalsIgnoreCase("plain") ? 0 : (encoding.equalsIgnoreCase("md5") ? 2 : 1);
        }
    }
}

