/*
 * Decompiled with CFR 0.152.
 */
package org.exist.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.tools.ant.filters.StringInputStream;
import org.apache.xerces.parsers.DOMParser;
import org.exist.schema.SchemaService;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.SchemaReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;
import org.xmldb.api.modules.XUpdateQueryService;

public abstract class GenericSchemaService
implements SchemaService {
    protected Logger LOG = Logger.getLogger((Class)GenericSchemaService.class);
    protected static final String INDEX_COLLECTION_NAME = "/db/system/schema/";
    protected static final String INDEX_RESOURCE_NAME = ".index";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private Collection parentCollection;
    private Collection schemasCollection;
    private ArrayList transientSchemas = null;
    XUpdateQueryService updateService = null;
    XPathQueryService queryService = null;

    public GenericSchemaService(Collection collection) {
        this.setParentCollection(collection);
    }

    public String getName() throws XMLDBException {
        return "SchemaService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void setCollection(Collection arg0) throws XMLDBException {
    }

    public String getProperty(String arg0) throws XMLDBException {
        return null;
    }

    public void setProperty(String arg0, String arg1) throws XMLDBException {
    }

    protected XMLResource testAndCreateIndexResource() throws XMLDBException {
        XMLResource index = null;
        try {
            index = (XMLResource)this.getSchemasCollection().getResource(INDEX_RESOURCE_NAME);
        }
        catch (XMLDBException xMLDBException) {
            // empty catch block
        }
        if (index == null) {
            index = (XMLResource)this.schemasCollection.createResource(INDEX_RESOURCE_NAME, "XMLResource");
            index.setContent((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><schema-index/>");
            this.getSchemasCollection().storeResource((Resource)index);
        }
        return index;
    }

    protected Collection getSchemasCollection() throws XMLDBException {
        if (this.schemasCollection == null) {
            Collection parent = this.getParentCollection();
            while (parent.getParentCollection() != null) {
                parent = parent.getParentCollection();
            }
            this.schemasCollection = parent.getChildCollection("system").getChildCollection("schema");
            if (this.schemasCollection == null) {
                CollectionManagementService cms = (CollectionManagementService)this.getParentCollection().getService("CollectionManagementService", "1.0");
                if (cms != null) {
                    cms.setCollection(parent.getChildCollection("system"));
                    this.schemasCollection = cms.createCollection("schema");
                } else {
                    throw new XMLDBException(1, "Could not get CollectionManagementService.", null);
                }
            }
        }
        return this.schemasCollection;
    }

    protected String findTargetNamespace(String schemaContents) throws XMLDBException {
        String targetNamespace = null;
        DOMParser parser = new DOMParser();
        try {
            parser.parse(new InputSource(new StringReader(schemaContents)));
            Element rootNode = parser.getDocument().getDocumentElement();
            Node targetNamespaceAttr = rootNode.getAttributes().getNamedItem("targetNamespace");
            if (targetNamespaceAttr != null) {
                targetNamespace = targetNamespaceAttr.getNodeValue();
            }
        }
        catch (SAXException e) {
            throw new XMLDBException(1, "Error parsing schema: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, "Error parsing schema: " + e.getMessage(), (Throwable)e);
        }
        return targetNamespace;
    }

    public void putSchema(String schemaContents) throws XMLDBException {
        Collection schemasCollection = this.getSchemasCollection();
        String targetNamespace = this.findTargetNamespace(schemaContents);
        String filename = this.getSchemaFilename(targetNamespace);
        XMLResource schemaResource = null;
        if (filename == null) {
            filename = String.valueOf(System.currentTimeMillis());
            schemaResource = schemasCollection.createResource(filename, "XMLResource");
            this.addToIndex(targetNamespace, filename);
        } else {
            schemaResource = (XMLResource)schemasCollection.getResource(filename);
        }
        schemaResource.setContent((Object)schemaContents);
        schemasCollection.storeResource((Resource)schemaResource);
        schemasCollection.close();
    }

    public XMLResource getSchema(String targetNamespace) throws XMLDBException {
        String filename = this.getSchemaFilename(targetNamespace);
        if (filename != null) {
            return (XMLResource)this.getSchemasCollection().getResource(filename);
        }
        return null;
    }

    public boolean validateContents(String contents) throws XMLDBException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            ValidationErrorHandler errorHandler = new ValidationErrorHandler();
            docBuilder.setErrorHandler(errorHandler);
            Document document = docBuilder.parse((InputStream)new StringInputStream(contents));
            TreeSet namespaces = new TreeSet();
            this.findNamespaces(document.getDocumentElement(), namespaces);
            SchemaService schemaService = (SchemaService)this.getParentCollection().getService("SchemaService", "1.0");
            ArrayList<String> schemas = new ArrayList<String>();
            this.LOG.debug((Object)("Getting schemas for validation (" + namespaces.size() + "): "));
            Iterator i = namespaces.iterator();
            while (i.hasNext()) {
                String namespaceURI = (String)i.next();
                XMLResource resource = schemaService.getSchema(namespaceURI);
                if (resource != null) {
                    schemas.add((String)resource.getContent());
                    this.LOG.info((Object)namespaceURI);
                    continue;
                }
                this.LOG.warn((Object)("No schema for target namespace " + namespaceURI + " found."));
            }
            factory.setValidating(true);
            try {
                int i2;
                factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                InputSource[] schemaSources = new InputSource[schemas.size() + this.getTransientSchemas().size()];
                for (i2 = 0; i2 < schemas.size(); ++i2) {
                    schemaSources[i2] = new InputSource(new StringReader((String)schemas.get(i2)));
                }
                Iterator iter = this.getTransientSchemas().iterator();
                while (iter.hasNext()) {
                    schemaSources[i2] = new InputSource(new StringReader((String)iter.next()));
                    ++i2;
                }
                factory.setAttribute(JAXP_SCHEMA_SOURCE, schemaSources);
            }
            catch (IllegalArgumentException e) {
                throw new XMLDBException(1, "Parser does not support JAXP 1.2", (Throwable)e);
            }
            docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler(errorHandler);
            docBuilder.parse((InputStream)new StringInputStream(contents));
            if (errorHandler.getErrors().size() > 0) {
                throw errorHandler.toException();
            }
            return true;
        }
        catch (ParserConfigurationException e) {
            throw new XMLDBException(1, "Parser config error validating contents.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new XMLDBException(1, "SAX error reading contents.", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, "IO error reading contents", (Throwable)e);
        }
    }

    public boolean validateResource(String id) throws XMLDBException {
        Resource doc = this.getParentCollection().getResource(id);
        if ("XMLResource".equals(doc.getResourceType()) || "XMLView".equals(doc.getResourceType())) {
            XMLResource xmlResource = (XMLResource)doc;
            Node root = xmlResource.getContentAsDOM();
            try {
                return this.validateContents((String)xmlResource.getContent());
            }
            catch (XMLDBException e) {
                throw new XMLDBException(1, "Error validating resource " + id, (Throwable)e);
            }
        }
        throw new XMLDBException(3, "Can only validate XML documents, but " + id + " is a " + doc.getResourceType(), null);
    }

    private void findNamespaces(Node root, Set namespaces) {
        if (root != null) {
            this.LOG.debug((Object)("locating namespace in " + root.getNodeName()));
            String namespace = root.getNamespaceURI();
            if (namespace != null && !"".equals(namespace)) {
                namespaces.add(namespace);
            }
            this.findNamespaces(root.getFirstChild(), namespaces);
            this.findNamespaces(root.getNextSibling(), namespaces);
        }
    }

    public Collection getParentCollection() {
        return this.parentCollection;
    }

    public void setParentCollection(Collection collection) {
        this.parentCollection = collection;
    }

    public AttributeDecl getAttribute(QName qname) throws XMLDBException {
        return this.getCastorSchema(qname.getNamespaceURI()).getAttribute(qname.getLocalPart());
    }

    public ElementDecl getElement(QName qname) throws XMLDBException {
        return this.getCastorSchema(qname.getNamespaceURI()).getElementDecl(qname.getLocalPart());
    }

    public XMLType getType(QName qname) throws XMLDBException {
        return this.getCastorSchema(qname.getNamespaceURI()).getType(qname.getLocalPart());
    }

    private Schema getCastorSchema(String namespaceURI) throws XMLDBException {
        XMLResource resource = this.getSchema(namespaceURI);
        try {
            Schema schema = new SchemaReader(new InputSource(new StringReader((String)resource.getContent()))).read();
            return schema;
        }
        catch (IOException e) {
            throw new XMLDBException(1, "Error reading schema information for target namespace: " + namespaceURI, (Throwable)e);
        }
    }

    public boolean isKnownNamespace(String namespaceURI) throws XMLDBException {
        return this.getSchema(namespaceURI) != null;
    }

    public void registerTransientSchema(String schema) throws XMLDBException {
        this.getTransientSchemas().add(schema);
    }

    public ArrayList getTransientSchemas() {
        if (this.transientSchemas == null) {
            this.transientSchemas = new ArrayList();
        }
        return this.transientSchemas;
    }

    protected String getDocumentExpression() {
        return "document('/db/system/schema/.index')";
    }

    protected String getRetrieveIndexRecordQuery(String targetNamespace) {
        return "/schema-index/schema[@targetNamespace=\"" + targetNamespace + "\"]";
    }

    protected String getAppendSchemaXUpdate(String targetNamespace, String resourceName) {
        return "<xupdate:modifications version=\"1.0\" xmlns:xupdate=\"http://www.xmldb.org/xupdate\"><xupdate:append select=\"" + this.getDocumentExpression() + "/schema-index\">" + "<xupdate:element name=\"schema\">" + "<xupdate:attribute name=\"targetNamespace\">" + targetNamespace + "</xupdate:attribute>" + "<xupdate:attribute name=\"resourceName\">" + resourceName + "</xupdate:attribute>" + "</xupdate:element>" + "</xupdate:append>" + "</xupdate:modifications>";
    }

    protected String getSchemaFilename(String targetNamespace) throws XMLDBException {
        if (targetNamespace == null) {
            throw new XMLDBException(1, "null is not a valid namespace!");
        }
        this.testAndCreateIndexResource();
        String query = this.getRetrieveIndexRecordQuery(targetNamespace) + "/@resourceName";
        ResourceSet set = this.getXQueryService().queryResource(INDEX_RESOURCE_NAME, query);
        if (set.getSize() == 1L) {
            ResourceIterator iterator = set.getIterator();
            return iterator.nextResource().getContent().toString();
        }
        if (set.getSize() == 0L) {
            return null;
        }
        throw new XMLDBException(1, "Multiple index entries for one targetNamespace in the schema index. The index is corrupt.");
    }

    protected void addToIndex(String targetNamespace, String resourceName) throws XMLDBException {
        this.getXUpdateService().update(this.getAppendSchemaXUpdate(targetNamespace, resourceName));
    }

    protected XUpdateQueryService getXUpdateService() throws XMLDBException {
        if (this.updateService == null) {
            this.updateService = (XUpdateQueryService)this.getSchemasCollection().getService("XUpdateQueryService", "1.0");
        }
        return this.updateService;
    }

    protected XPathQueryService getXQueryService() throws XMLDBException {
        if (this.queryService == null) {
            this.queryService = (XPathQueryService)this.getSchemasCollection().getService("XPathQueryService", "1.0");
        }
        return this.queryService;
    }

    private void deleteIndex() throws XMLDBException {
        Resource index = this.getSchemasCollection().getResource(INDEX_RESOURCE_NAME);
        this.getSchemasCollection().removeResource(index);
    }

    public void rebuildIndex() throws XMLDBException {
        this.deleteIndex();
        Collection collection = this.getSchemasCollection();
        String[] resourceNames = collection.listResources();
        for (int i = 0; i < resourceNames.length; ++i) {
            XMLResource schema = (XMLResource)collection.getResource(resourceNames[i]);
            String targetNamespace = this.findTargetNamespace((String)schema.getContent());
            this.addToIndex(targetNamespace, resourceNames[i]);
        }
    }

    private class ValidationErrorHandler
    implements ErrorHandler {
        private ArrayList warnings = new ArrayList();
        private ArrayList errors = new ArrayList();

        private ValidationErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            this.addError(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.addError(exception);
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.addWarning(exception);
        }

        public ArrayList getErrors() {
            return this.errors;
        }

        private void addError(SAXParseException e) {
            this.getErrors().add("Error: (" + e.getLineNumber() + ", " + e.getColumnNumber() + "): " + e.getMessage());
        }

        public ArrayList getWarnings() {
            return this.warnings;
        }

        private void addWarning(SAXParseException e) {
            this.getWarnings().add("Warning: (" + e.getLineNumber() + ", " + e.getColumnNumber() + "): " + e.getMessage());
        }

        public XMLDBException toException() {
            String errors = "";
            Iterator i = this.getErrors().iterator();
            while (i.hasNext()) {
                errors = errors + (String)i.next() + "\n";
            }
            return new XMLDBException(1, "Error validating: \n" + errors, null);
        }
    }
}

