/*
 * Decompiled with CFR 0.152.
 */
package org.exist.memtree;

import org.exist.dom.DocumentSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.QNameable;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.DocumentImpl;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.DOMStreamer;
import org.exist.util.serializer.DOMStreamerPool;
import org.exist.util.serializer.Receiver;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class NodeImpl
implements Node,
NodeValue,
QNameable,
Comparable {
    public static final short REFERENCE_NODE = 100;
    public static final short NAMESPACE_NODE = 101;
    protected int nodeNumber;
    protected DocumentImpl document;

    public NodeImpl(DocumentImpl doc, int nodeNumber) {
        this.document = doc;
        this.nodeNumber = nodeNumber;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public int getImplementationType() {
        return 0;
    }

    public DocumentSet getDocumentSet() {
        return DocumentSet.EMPTY_DOCUMENT_SET;
    }

    public Node getNode() {
        return this;
    }

    public String getNodeName() {
        switch (this.getNodeType()) {
            case 9: {
                return "#document";
            }
            case 1: 
            case 7: {
                QName qn = (QName)this.document.namePool.get(this.document.nodeName[this.nodeNumber]);
                return qn.toString();
            }
            case 2: {
                return this.document.namePool.get(this.document.attrName[this.nodeNumber]).toString();
            }
            case 101: {
                return this.document.namePool.get(this.document.namespaceCode[this.nodeNumber]).toString();
            }
            case 3: {
                return "#text";
            }
        }
        return "#unknown";
    }

    public QName getQName() {
        switch (this.getNodeType()) {
            case 9: {
                return QName.DOCUMENT_QNAME;
            }
            case 1: 
            case 2: 
            case 7: {
                QName qn = (QName)this.document.namePool.get(this.document.nodeName[this.nodeNumber]);
                return qn;
            }
            case 8: {
                return QName.COMMENT_QNAME;
            }
            case 3: {
                return QName.TEXT_QNAME;
            }
        }
        return null;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String arg0) throws DOMException {
    }

    public short getNodeType() {
        return this.document.nodeKind[this.nodeNumber];
    }

    public Node getParentNode() {
        int next = this.document.next[this.nodeNumber];
        while (next > this.nodeNumber) {
            next = this.document.next[next];
        }
        if (next < 0) {
            return this.document;
        }
        return this.document.getNode(next);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeImpl)) {
            return false;
        }
        return this.nodeNumber == ((NodeImpl)obj).nodeNumber;
    }

    public boolean equals(NodeValue other) throws XPathException {
        if (other.getImplementationType() != 0) {
            throw new XPathException("annot compare persistent node with in-memory node");
        }
        return this.nodeNumber == ((NodeImpl)other).nodeNumber;
    }

    public boolean after(NodeValue other) throws XPathException {
        if (other.getImplementationType() != 0) {
            throw new XPathException("annot compare persistent node with in-memory node");
        }
        return this.nodeNumber < ((NodeImpl)other).nodeNumber;
    }

    public boolean before(NodeValue other) throws XPathException {
        if (other.getImplementationType() != 0) {
            throw new XPathException("annot compare persistent node with in-memory node");
        }
        return this.nodeNumber > ((NodeImpl)other).nodeNumber;
    }

    public int compareTo(Object other) {
        if (!(other instanceof NodeImpl)) {
            return -1;
        }
        NodeImpl n = (NodeImpl)other;
        if (n.document == this.document) {
            if (this.nodeNumber == n.nodeNumber) {
                return 0;
            }
            if (this.nodeNumber < n.nodeNumber) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    public NodeList getChildNodes() {
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        int nextNr = this.document.next[this.nodeNumber];
        return nextNr < this.nodeNumber ? null : this.document.getNode(nextNr);
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.document;
    }

    public DocumentImpl getDocument() {
        return this.document;
    }

    public Node insertBefore(Node arg0, Node arg1) throws DOMException {
        return null;
    }

    public Node replaceChild(Node arg0, Node arg1) throws DOMException {
        return null;
    }

    public Node removeChild(Node arg0) throws DOMException {
        return null;
    }

    public Node appendChild(Node arg0) throws DOMException {
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node cloneNode(boolean arg0) {
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String arg0, String arg1) {
        return false;
    }

    public String getNamespaceURI() {
        return "";
    }

    public String getPrefix() {
        return "";
    }

    public void setPrefix(String arg0) throws DOMException {
    }

    public String getLocalName() {
        return "";
    }

    public boolean hasAttributes() {
        return false;
    }

    public int getType() {
        short type = this.getNodeType();
        switch (type) {
            case 9: {
                return 6;
            }
            case 8: {
                return 5;
            }
            case 7: {
                return 4;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    public String getStringValue() {
        short level = this.document.treeLevel[this.nodeNumber];
        StringBuffer buf = null;
        for (int next = this.nodeNumber + 1; next < this.document.size && this.document.treeLevel[next] > level; ++next) {
            if (this.document.nodeKind[next] != 3) continue;
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(this.document.characters, this.document.alpha[next], this.document.alphaLen[next]);
        }
        return buf == null ? "" : buf.toString();
    }

    public Sequence toSequence() {
        return this;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        return new StringValue(this.getStringValue()).convertTo(requiredType);
    }

    public AtomicValue atomize() throws XPathException {
        return new StringValue(this.getStringValue());
    }

    public void add(Item item) throws XPathException {
    }

    public void addAll(Sequence other) throws XPathException {
    }

    public int getItemType() {
        return -1;
    }

    public SequenceIterator iterate() {
        return new SingleNodeIterator(this);
    }

    public SequenceIterator unorderedIterator() {
        return new SingleNodeIterator(this);
    }

    public int getLength() {
        return 1;
    }

    public int getCardinality() {
        return 2;
    }

    public Item itemAt(int pos) {
        return pos == 0 ? this : null;
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return true;
    }

    public NodeSet toNodeSet() throws XPathException {
        return this.document.toNodeSet(this);
    }

    public void toSAX(DBBroker broker, ContentHandler handler) throws SAXException {
        DOMStreamer streamer = null;
        try {
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperty("sax-document-events", "false");
            serializer.setSAXHandlers(handler, null);
            streamer = DOMStreamerPool.getInstance().borrowDOMStreamer(serializer);
            streamer.setContentHandler(handler);
            streamer.serialize(this, false);
        }
        catch (Exception e) {
            DOMStreamerPool.getInstance().returnDOMStreamer(streamer);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    public void copyTo(DBBroker broker, DocumentBuilderReceiver receiver) throws SAXException {
        this.document.copyTo(this, receiver);
    }

    public void streamTo(Serializer serializer, Receiver receiver) throws SAXException {
        this.document.streamTo(serializer, this, receiver);
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(NodeImpl.class)) {
            return 0;
        }
        if (javaClass.isAssignableFrom(Node.class)) {
            return 1;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 2;
        }
        if (javaClass == Character.class || javaClass == Character.TYPE) {
            return 2;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 10;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 11;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 12;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 13;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 14;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 15;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 16;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(NodeImpl.class)) {
            return this;
        }
        if (target.isAssignableFrom(Node.class)) {
            return this;
        }
        if (target == Object.class) {
            return this;
        }
        StringValue v = new StringValue(this.getStringValue());
        return v.toJavaObject(target);
    }

    public void setSelfAsContext() {
    }

    public boolean isCached() {
        return false;
    }

    public void setIsCached(boolean cached) {
    }

    public void removeDuplicates() {
    }

    private static final class SingleNodeIterator
    implements SequenceIterator {
        NodeImpl node;

        public SingleNodeIterator(NodeImpl node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public Item nextItem() {
            NodeImpl next = this.node;
            this.node = null;
            return next;
        }
    }
}

