/*
 * Decompiled with CFR 0.152.
 */
package org.exist.memtree;

import org.exist.dom.NamedNodeMapImpl;
import org.exist.dom.QName;
import org.exist.dom.QNameable;
import org.exist.memtree.AttributeImpl;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.NamespaceNode;
import org.exist.memtree.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementImpl
extends NodeImpl
implements Element,
QNameable {
    public ElementImpl(DocumentImpl doc, int nodeNumber) {
        super(doc, nodeNumber);
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public QName getQName() {
        return (QName)this.document.namePool.get(this.document.nodeName[this.nodeNumber]);
    }

    public boolean hasChildNodes() {
        return this.nodeNumber + 1 < this.document.size && this.document.treeLevel[this.nodeNumber + 1] > this.document.treeLevel[this.nodeNumber];
    }

    public Node getFirstChild() {
        short level = this.document.treeLevel[this.nodeNumber];
        int nextNode = this.nodeNumber + 1;
        if (nextNode < this.document.size && this.document.treeLevel[nextNode] > level) {
            return this.document.getNode(nextNode);
        }
        return null;
    }

    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    public String getPrefix() {
        return this.getQName().getPrefix();
    }

    public String getLocalName() {
        return this.getQName().getLocalName();
    }

    public boolean hasAttributes() {
        return this.document.alpha[this.nodeNumber] > -1;
    }

    public String getAttribute(String name) {
        int attr = this.document.alpha[this.nodeNumber];
        if (attr < 0) {
            return null;
        }
        while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
            QName attrQName = (QName)this.document.namePool.get(this.document.attrName[attr]);
            if (attrQName.getLocalName().equals(name)) {
                return this.document.attrValue[attr];
            }
            ++attr;
        }
        return null;
    }

    public void setAttribute(String arg0, String arg1) throws DOMException {
    }

    public void removeAttribute(String arg0) throws DOMException {
    }

    public NamedNodeMap getAttributes() {
        int ns;
        NamedNodeMapImpl map = new NamedNodeMapImpl();
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                map.add(new AttributeImpl(this.document, attr));
                ++attr;
            }
        }
        if ((ns = this.document.alphaLen[this.nodeNumber]) < 0) {
            return map;
        }
        while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
            map.add(new NamespaceNode(this.document, ns));
            ++ns;
        }
        return map;
    }

    public Attr getAttributeNode(String name) {
        int attr = this.document.alpha[this.nodeNumber];
        if (attr < 0) {
            return null;
        }
        while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
            QName attrQName = (QName)this.document.namePool.get(this.document.attrName[attr]);
            if (attrQName.equals(name)) {
                return new AttributeImpl(this.document, attr);
            }
            ++attr;
        }
        return null;
    }

    public Attr setAttributeNode(Attr arg0) throws DOMException {
        return null;
    }

    public Attr removeAttributeNode(Attr arg0) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagName(String arg0) {
        return null;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        int attr = this.document.alpha[this.nodeNumber];
        if (attr < 0) {
            return null;
        }
        while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
            QName name = (QName)this.document.namePool.get(this.document.attrName[attr]);
            if (name.getLocalName().equals(localName) && name.getNamespaceURI().equals(namespaceURI)) {
                return this.document.attrValue[attr];
            }
            ++attr;
        }
        return null;
    }

    public void setAttributeNS(String arg0, String arg1, String arg2) throws DOMException {
    }

    public void removeAttributeNS(String arg0, String arg1) throws DOMException {
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        int attr = this.document.alpha[this.nodeNumber];
        if (attr < 0) {
            return null;
        }
        while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
            QName name = (QName)this.document.namePool.get(this.document.attrName[attr]);
            if (name.getLocalName().equals(localName) && name.getNamespaceURI().equals(namespaceURI)) {
                return new AttributeImpl(this.document, attr);
            }
            ++attr;
        }
        return null;
    }

    public Attr setAttributeNodeNS(Attr arg0) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagNameNS(String arg0, String arg1) {
        return null;
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNS(namespaceURI, localName) != null;
    }
}

