/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Put
extends AbstractWebDAVMethod {
    public Put(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        block29: {
            boolean collectionLocked;
            Collection collection;
            DBBroker broker;
            block28: {
                block27: {
                    block26: {
                        File tempFile = this.saveRequestContent(request);
                        String url = tempFile.toURI().toASCIIString();
                        String contentType = request.getContentType();
                        broker = null;
                        collection = null;
                        collectionLocked = true;
                        try {
                            try {
                                int p;
                                broker = this.pool.get(user);
                                if (path == null) {
                                    path = "";
                                }
                                if (path.endsWith("/")) {
                                    path = path.substring(0, path.length() - 1);
                                }
                                if ((p = path.lastIndexOf(47)) < 1) {
                                    response.sendError(409, "No collection specified for PUT");
                                    Object var18_17 = null;
                                    if (collectionLocked) {
                                        collection.release();
                                    }
                                    this.pool.release(broker);
                                    return;
                                }
                                String collectionName = path.substring(0, p);
                                path = path.substring(p + 1);
                                collection = broker.openCollection(collectionName, 1);
                                if (collection == null) {
                                    response.sendError(409, "Parent collection " + collectionName + " not found");
                                    break block26;
                                }
                                if (collection.hasChildCollection(path)) {
                                    response.sendError(409, "Cannot overwrite an existing collection with a resource");
                                    break block27;
                                }
                                if (contentType == null) {
                                    contentType = URLConnection.guessContentTypeFromName(path);
                                }
                                LOG.debug((Object)("storing document " + path + "; content-type = " + contentType));
                                if (contentType == null || contentType.equalsIgnoreCase("text/xml") || contentType.equals("application/xml")) {
                                    InputSource is = new InputSource(url);
                                    IndexInfo info = collection.validate(broker, path, is);
                                    collection.release();
                                    collectionLocked = false;
                                    collection.store(broker, info, is, false);
                                    break block28;
                                } else {
                                    int l;
                                    byte[] chunk = new byte[4096];
                                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                                    FileInputStream is = new FileInputStream(tempFile);
                                    while ((l = is.read(chunk)) > -1) {
                                        os.write(chunk, 0, l);
                                    }
                                    collection.addBinaryResource(broker, path, os.toByteArray());
                                }
                                break block28;
                            }
                            catch (EXistException e) {
                                throw new ServletException("Failed to store resource: " + e.getMessage(), (Throwable)e);
                            }
                            catch (PermissionDeniedException e) {
                                response.sendError(403);
                                Object var18_21 = null;
                                if (collectionLocked) {
                                    collection.release();
                                }
                                this.pool.release(broker);
                                break block29;
                            }
                            catch (TriggerException e) {
                                response.sendError(403);
                                Object var18_22 = null;
                                if (collectionLocked) {
                                    collection.release();
                                }
                                this.pool.release(broker);
                                break block29;
                            }
                            catch (SAXException e) {
                                response.sendError(400);
                                Object var18_23 = null;
                                if (collectionLocked) {
                                    collection.release();
                                }
                                this.pool.release(broker);
                                break block29;
                            }
                            catch (LockException e) {
                                response.sendError(409);
                                Object var18_24 = null;
                                if (collectionLocked) {
                                    collection.release();
                                }
                                this.pool.release(broker);
                                break block29;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var18_25 = null;
                            if (collectionLocked) {
                                collection.release();
                            }
                            this.pool.release(broker);
                            throw throwable;
                        }
                    }
                    Object var18_18 = null;
                    if (collectionLocked) {
                        collection.release();
                    }
                    this.pool.release(broker);
                    return;
                }
                Object var18_19 = null;
                if (collectionLocked) {
                    collection.release();
                }
                this.pool.release(broker);
                return;
            }
            Object var18_20 = null;
            if (collectionLocked) {
                collection.release();
            }
            this.pool.release(broker);
        }
        response.setStatus(201);
    }

    private File saveRequestContent(HttpServletRequest request) throws IOException {
        int count;
        ServletInputStream is = request.getInputStream();
        int len = request.getContentLength();
        File tempFile = File.createTempFile("exist", ".tmp");
        FileOutputStream os = new FileOutputStream(tempFile);
        byte[] buffer = new byte[4096];
        int l = 0;
        do {
            if ((count = is.read(buffer)) <= 0) continue;
            ((OutputStream)os).write(buffer, 0, count);
        } while ((l += count) < len);
        ((OutputStream)os).close();
        return tempFile;
    }
}

