/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;

public class Mkcol
extends AbstractWebDAVMethod {
    public Mkcol(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        String origPath = request.getPathInfo();
        if (path == null || path.equals("")) {
            response.sendError(405, "no path specified");
            return;
        }
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.pool.get(user);
            collection = broker.openCollection(path, 0);
            if (collection != null) {
                collection.release();
                response.sendError(405, "collection " + request.getPathInfo() + " already exists");
                return;
            }
            int p = path.lastIndexOf(47);
            String parentPath = -1 < p ? path.substring(0, p) : "/db";
            String newCollection = -1 < p ? path.substring(p + 1) : path;
            collection = broker.openCollection(parentPath, 1);
            if (collection == null) {
                LOG.debug((Object)("Parent collection " + parentPath + " not found"));
                response.sendError(409, "Parent collection not found");
                return;
            }
            if (collection.hasDocument(newCollection)) {
                collection.release();
                response.sendError(405, "path conflicts with an existing resource");
                return;
            }
            collection.release();
            Collection created = broker.getOrCreateCollection(path);
            broker.saveCollection(created);
            broker.flush();
            LOG.debug((Object)("Created collection " + path));
            response.setStatus(201);
        }
        catch (EXistException e) {
            throw new ServletException("Database error: " + e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            response.sendError(403, e.getMessage());
        }
        finally {
            this.pool.release(broker);
        }
    }
}

