/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.http.webdav.WebDAVUtil;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Lock
extends AbstractWebDAVMethod {
    private static final int SCOPE_EXCLUSIVE = 0;
    private static final int SCOPE_SHARED = 1;
    private DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private BrokerPool pool;

    public Lock(BrokerPool pool) {
        super(pool);
        this.docFactory.setNamespaceAware(true);
    }

    public void process(User user, HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl resource = null;
        try {
            DocumentBuilder docBuilder;
            broker = this.pool.get(user);
            collection = broker.openCollection(path, 1);
            if (collection == null) {
                int pos = path.lastIndexOf(47);
                String collName = path.substring(0, pos);
                String docName = path.substring(pos + 1);
                LOG.debug((Object)("collection = " + collName + "; doc = " + docName));
                collection = broker.openCollection(collName, 1);
                if (collection == null) {
                    LOG.debug((Object)("No resource or collection found for path: " + path));
                    response.sendError(404, "No resource or collection found");
                    return;
                }
                resource = collection.getDocument(broker, docName);
                if (resource == null) {
                    LOG.debug((Object)("No resource found for path: " + path));
                    response.sendError(404, "No resource or collection found");
                    return;
                }
            }
            if (resource == null) {
                response.sendError(400, "Lock on collections is not supported yet");
                return;
            }
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            try {
                docBuilder = docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e1) {
                throw new ServletException("Failed to create XML parser: ", (Throwable)e1);
            }
            Document doc = WebDAVUtil.parseRequestContent(request, response, docBuilder);
            Element lockinfo = doc.getDocumentElement();
            if (!lockinfo.getLocalName().equals("lockinfo") || !lockinfo.getNamespaceURI().equals("DAV:")) {
                LOG.debug((Object)("Unexpected element found: " + lockinfo.getNodeName()));
                response.sendError(400, "Unexpected element found: " + lockinfo.getNodeName());
                return;
            }
            int scope = 0;
            String owner = null;
            for (Node node = lockinfo.getFirstChild(); node != null; node = node.getNextSibling()) {
                Node typeNode;
                if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("DAV:")) continue;
                if ("lockscope".equals(node.getLocalName())) {
                    Node scopeNode = WebDAVUtil.firstElementNode(node);
                    if ("exclusive".equals(scopeNode.getLocalName())) {
                        scope = 0;
                    } else if ("shared".equals(scopeNode.getLocalName())) {
                        scope = 1;
                    }
                }
                if ("locktype".equals(node.getLocalName()) && !"write".equals((typeNode = WebDAVUtil.firstElementNode(node)).getLocalName())) {
                    response.sendError(400, "Unexpected element found: " + typeNode.getNodeName());
                    return;
                }
                if (!"owner".equals(node.getLocalName())) continue;
                Node href = WebDAVUtil.firstElementNode(node);
                owner = WebDAVUtil.getElementContent(href);
            }
            LOG.debug((Object)("Received lock request [" + scope + "] for owner " + owner));
            if (resource != null) {
                this.lockResource(request, response, resource, scope);
            }
        }
        catch (EXistException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (collection != null) {
                collection.release();
            }
        }
    }

    private void lockResource(HttpServletRequest request, HttpServletResponse response, DocumentImpl resource, int scope) throws ServletException, IOException {
        if (scope == 1) {
            response.sendError(501, "Shared locks are not implemented");
            return;
        }
    }
}

