/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;

public class Copy
extends AbstractWebDAVMethod {
    public Copy(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        DocumentImpl resource;
        Collection collection;
        DBBroker broker;
        block30: {
            block28: {
                block27: {
                    broker = null;
                    collection = null;
                    resource = null;
                    try {
                        try {
                            String destPath;
                            block29: {
                                URI uri;
                                broker = this.pool.get(user);
                                collection = broker.openCollection(path, 0);
                                if (collection == null) {
                                    int pos = path.lastIndexOf(47);
                                    String collName = path.substring(0, pos);
                                    String docName = path.substring(pos + 1);
                                    collection = broker.openCollection(collName, 0);
                                    if (collection == null) {
                                        LOG.debug((Object)("No resource or collection found for path: " + path));
                                        response.sendError(404, "No resource or collection found");
                                        Object var14_15 = null;
                                        if (collection != null) {
                                            collection.release();
                                        }
                                        if (resource != null) {
                                            resource.getUpdateLock().release(0);
                                        }
                                        this.pool.release(broker);
                                        return;
                                    }
                                    resource = collection.getDocumentWithLock(broker, docName, 0);
                                    if (resource == null) {
                                        LOG.debug((Object)("No resource found for path: " + path));
                                        response.sendError(404, "No resource or collection found");
                                        break block27;
                                    }
                                }
                                String destination = request.getHeader("Destination");
                                destPath = null;
                                try {
                                    uri = new URI(destination);
                                    String host = uri.getHost();
                                    int port = uri.getPort();
                                    if (!host.equals(request.getServerName()) || port != request.getServerPort()) {
                                        response.sendError(501, "Copying to a different server is not yet implemented");
                                        break block28;
                                    }
                                }
                                catch (URISyntaxException e) {
                                    response.sendError(400, "Malformed URL in destination header");
                                    break block29;
                                }
                                {
                                    destPath = uri.getPath();
                                    if (destPath.startsWith(request.getContextPath())) {
                                        destPath = destPath.substring(request.getContextPath().length());
                                    }
                                    if (!destPath.startsWith(request.getServletPath())) break block29;
                                    destPath = destPath.substring(request.getServletPath().length());
                                }
                            }
                            if (resource != null) {
                                this.copyResource(user, broker, request, response, collection, resource, destPath);
                                break block30;
                            } else {
                                this.copyCollection(user, broker, request, response, collection, destPath);
                            }
                            break block30;
                        }
                        catch (EXistException e) {
                            throw new ServletException("Failed to copy: " + e.getMessage(), (Throwable)e);
                        }
                        catch (LockException e) {
                            throw new ServletException("Failed to copy: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_19 = null;
                        if (collection != null) {
                            collection.release();
                        }
                        if (resource != null) {
                            resource.getUpdateLock().release(0);
                        }
                        this.pool.release(broker);
                        throw throwable;
                    }
                }
                Object var14_16 = null;
                if (collection != null) {
                    collection.release();
                }
                if (resource != null) {
                    resource.getUpdateLock().release(0);
                }
                this.pool.release(broker);
                return;
            }
            Object var14_17 = null;
            if (collection != null) {
                collection.release();
            }
            if (resource != null) {
                resource.getUpdateLock().release(0);
            }
            this.pool.release(broker);
            return;
        }
        Object var14_18 = null;
        if (collection != null) {
            collection.release();
        }
        if (resource != null) {
            resource.getUpdateLock().release(0);
        }
        this.pool.release(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(User user, DBBroker broker, HttpServletRequest request, HttpServletResponse response, Collection sourceCollection, DocumentImpl resource, String destination) throws ServletException, IOException {
        int p = destination.lastIndexOf(47);
        if (p < 0) {
            response.sendError(400, "Bad destination: " + destination);
            return;
        }
        String newResourceName = destination.substring(p + 1);
        destination = destination.substring(0, p);
        boolean replaced = false;
        Collection destCollection = null;
        try {
            destCollection = broker.openCollection(destination, 1);
            if (destCollection == null) {
                response.sendError(409, "Destination collection not found");
                return;
            }
            DocumentImpl oldDoc = destCollection.getDocument(broker, newResourceName);
            if (oldDoc != null) {
                boolean overwrite = this.overwrite(request);
                if (!overwrite) {
                    response.sendError(412, "Destination resource exists and overwrite is not allowed");
                    return;
                }
                replaced = true;
            }
            broker.copyResource(resource, destCollection, newResourceName);
            if (replaced) {
                response.setStatus(204);
            } else {
                response.setStatus(201);
            }
        }
        catch (PermissionDeniedException e) {
            response.sendError(403, e.getMessage());
        }
        catch (LockException e) {
            response.sendError(500, e.getMessage());
        }
        finally {
            if (destCollection != null) {
                destCollection.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCollection(User user, DBBroker broker, HttpServletRequest request, HttpServletResponse response, Collection collection, String destination) throws ServletException, IOException {
        int p = destination.lastIndexOf(47);
        if (p < 0) {
            response.sendError(400, "Bad destination: " + destination);
            return;
        }
        String newCollectionName = destination.substring(p + 1);
        destination = destination.substring(0, p);
        boolean replaced = false;
        Collection destCollection = null;
        try {
            destCollection = broker.openCollection(destination, 1);
            if (destCollection == null) {
                response.sendError(409, "Destination collection not found");
                return;
            }
            if (destCollection.hasChildCollection(newCollectionName)) {
                boolean overwrite = this.overwrite(request);
                if (!overwrite) {
                    response.sendError(412, "Destination collection exists and overwrite is not allowed");
                    return;
                }
                replaced = true;
            }
            broker.copyCollection(collection, destCollection, newCollectionName);
            if (replaced) {
                response.setStatus(204);
            } else {
                response.setStatus(201);
            }
        }
        catch (PermissionDeniedException e) {
            response.sendError(403, e.getMessage());
        }
        catch (LockException e) {
            response.sendError(500, e.getMessage());
        }
        finally {
            if (destCollection != null) {
                destCollection.release();
            }
        }
    }

    private boolean overwrite(HttpServletRequest request) {
        String header = request.getHeader("Overwrite");
        if (header == null) {
            return false;
        }
        return header.equals("T");
    }
}

